/*
 * Decompiled with CFR 0.152.
 */
package mikera.arrayz;

import java.nio.DoubleBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import mikera.arrayz.Array;
import mikera.arrayz.INDArray;
import mikera.arrayz.impl.BaseNDArray;
import mikera.arrayz.impl.IStridedArray;
import mikera.arrayz.impl.ImmutableArray;
import mikera.matrixx.Matrix;
import mikera.vectorz.AVector;
import mikera.vectorz.IOp;
import mikera.vectorz.Op;
import mikera.vectorz.Vector;
import mikera.vectorz.Vectorz;
import mikera.vectorz.impl.ArrayIndexScalar;
import mikera.vectorz.impl.ArraySubVector;
import mikera.vectorz.impl.SingleDoubleIterator;
import mikera.vectorz.impl.StridedVector;
import mikera.vectorz.impl.Vector0;
import mikera.vectorz.util.ErrorMessages;
import mikera.vectorz.util.IntArrays;
import mikera.vectorz.util.VectorzException;

public final class NDArray
extends BaseNDArray {
    NDArray(int ... shape) {
        super(new double[(int)IntArrays.arrayProduct(shape)], shape.length, 0, shape, IntArrays.calcStrides(shape));
    }

    NDArray(double[] data, int offset, int[] shape, int[] stride) {
        this(data, shape.length, offset, shape, stride);
    }

    NDArray(double[] data, int dimensions, int offset, int[] shape, int[] stride) {
        super(data, shape.length, offset, shape, stride);
    }

    public static NDArray wrap(double[] data, int[] shape) {
        int dims = shape.length;
        return new NDArray(data, dims, 0, shape, IntArrays.calcStrides(shape));
    }

    public static NDArray wrap(Vector v) {
        return NDArray.wrap(v.data, v.getShape());
    }

    public static NDArray wrap(Matrix m) {
        return NDArray.wrap(m.data, m.getShape());
    }

    public static NDArray wrap(IStridedArray a) {
        return new NDArray(a.getArray(), a.getArrayOffset(), a.getShape(), a.getStrides());
    }

    public static NDArray wrap(INDArray a) {
        if (!(a instanceof IStridedArray)) {
            throw new IllegalArgumentException(a.getClass() + " is not a strided array!");
        }
        return NDArray.wrap((IStridedArray)a);
    }

    public static NDArray newArray(int ... shape) {
        return new NDArray(shape);
    }

    @Override
    public void set(double value) {
        if (this.dimensions == 0) {
            this.data[this.offset] = value;
        } else if (this.dimensions == 1) {
            int n = this.getShape(0);
            int st = this.getStride(0);
            for (int i = 0; i < n; ++i) {
                this.data[this.offset + i * st] = value;
            }
        } else {
            for (INDArray s : this.getSlices()) {
                s.set(value);
            }
        }
    }

    @Override
    public void set(int x, double value) {
        if (this.dimensions != 1) {
            throw new UnsupportedOperationException(ErrorMessages.invalidIndex(this, x));
        }
        this.data[this.offset + x * this.getStride((int)0)] = value;
    }

    @Override
    public void set(int x, int y, double value) {
        if (this.dimensions != 2) {
            throw new UnsupportedOperationException(ErrorMessages.invalidIndex(this, x, y));
        }
        this.data[this.offset + x * this.getStride((int)0) + y * this.getStride((int)1)] = value;
    }

    @Override
    public void set(int[] indexes, double value) {
        int ix = this.offset;
        if (indexes.length != this.dimensions) {
            throw new IllegalArgumentException(ErrorMessages.invalidIndex(this, indexes));
        }
        for (int i = 0; i < this.dimensions; ++i) {
            ix += indexes[i] * this.getStride(i);
        }
        this.data[ix] = value;
    }

    @Override
    public void add(double a) {
        super.add(a);
    }

    @Override
    public void add(INDArray a) {
        super.add(a);
    }

    @Override
    public void sub(INDArray a) {
        super.sub(a);
    }

    @Override
    public INDArray innerProduct(INDArray a) {
        return super.innerProduct(a);
    }

    @Override
    public INDArray outerProduct(INDArray a) {
        return super.outerProduct(a);
    }

    @Override
    public INDArray getTranspose() {
        return new NDArray(this.data, this.dimensions, this.offset, IntArrays.reverse(this.shape), IntArrays.reverse(this.stride));
    }

    @Override
    public INDArray getTransposeView() {
        return this.getTranspose();
    }

    @Override
    public AVector asVector() {
        if (this.isPackedArray()) {
            return Vector.wrap(this.data);
        }
        if (this.dimensions == 0) {
            return ArraySubVector.wrap(this.data, this.offset, 1);
        }
        if (this.dimensions == 1) {
            return StridedVector.wrap(this.data, this.offset, this.getShape(0), this.getStride(0));
        }
        AVector v = Vector0.INSTANCE;
        int n = this.getShape(0);
        for (int i = 0; i < n; ++i) {
            v = ((AVector)v).join(this.slice(i).asVector());
        }
        return v;
    }

    @Override
    public INDArray reshape(int ... dimensions) {
        return super.reshape(dimensions);
    }

    @Override
    public INDArray broadcast(int ... dimensions) {
        return super.broadcast(dimensions);
    }

    @Override
    public INDArray slice(int majorSlice) {
        if (this.dimensions == 0) {
            throw new IllegalArgumentException("Can't slice a 0-d NDArray");
        }
        if (this.dimensions == 1) {
            return new ArrayIndexScalar(this.data, this.offset + majorSlice * this.getStride(0));
        }
        if (this.dimensions == 2) {
            if (majorSlice < 0 || majorSlice > this.shape[0]) {
                throw new IllegalArgumentException(ErrorMessages.invalidSlice(this, majorSlice));
            }
            int st = this.stride[1];
            if (st == 1) {
                return Vectorz.wrap(this.data, this.offset + majorSlice * this.getStride(0), this.getShape(1));
            }
            return StridedVector.wrapStrided(this.data, this.offset + majorSlice * this.getStride(0), this.getShape(1), st);
        }
        return new NDArray(this.data, this.offset + majorSlice * this.getStride(0), Arrays.copyOfRange(this.shape, 1, this.dimensions), Arrays.copyOfRange(this.stride, 1, this.dimensions));
    }

    @Override
    public INDArray slice(int dimension, int index) {
        if (dimension < 0 || dimension >= this.dimensions) {
            throw new IllegalArgumentException(ErrorMessages.invalidDimension(this, dimension));
        }
        if (dimension == 0) {
            return this.slice(index);
        }
        if (this.dimensions == 2) {
            if (dimension != 1) {
                throw new IllegalArgumentException(ErrorMessages.invalidDimension(this, dimension));
            }
            return StridedVector.wrap(this.data, this.offset + index * this.getStride(1), this.getShape(0), this.getStride(0));
        }
        return new NDArray(this.data, this.offset + index * this.stride[dimension], IntArrays.removeIndex(this.shape, index), IntArrays.removeIndex(this.stride, index));
    }

    @Override
    public NDArray subArray(int[] offsets, int[] shape) {
        int n = this.dimensions;
        if (offsets.length != n) {
            throw new IllegalArgumentException(ErrorMessages.invalidIndex(this, offsets));
        }
        if (shape.length != n) {
            throw new IllegalArgumentException(ErrorMessages.invalidIndex(this, offsets));
        }
        if (IntArrays.equals(shape, this.shape)) {
            if (IntArrays.isZero(offsets)) {
                return this;
            }
            throw new IllegalArgumentException("Invalid subArray offsets");
        }
        return new NDArray(this.data, this.offset + IntArrays.dotProduct(offsets, this.stride), IntArrays.copyOf(shape), this.stride);
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    @Override
    public boolean isFullyMutable() {
        return true;
    }

    @Override
    public boolean isElementConstrained() {
        return false;
    }

    @Override
    public boolean isView() {
        return !this.isPackedArray();
    }

    @Override
    public void applyOp(Op op) {
        if (this.dimensions == 0) {
            this.data[this.offset] = op.apply(this.data[this.offset]);
        } else if (this.dimensions == 1) {
            int st = this.getStride(0);
            int len = this.getShape(0);
            if (st == 1) {
                op.applyTo(this.data, this.offset, len);
            } else {
                for (int i = 0; i < len; ++i) {
                    this.data[this.offset + i * st] = op.apply(this.data[this.offset + i * st]);
                }
            }
        } else {
            int n = this.shape[0];
            for (int i = 0; i < n; ++i) {
                this.slice(i).applyOp(op);
            }
        }
    }

    @Override
    public void applyOp(IOp op) {
        this.applyOp((Op)op);
    }

    public boolean equals(NDArray a) {
        if (this.dimensions != a.dimensions) {
            return false;
        }
        if (this.dimensions == 0) {
            return this.get() == a.get();
        }
        int sc = this.sliceCount();
        if (a.sliceCount() != sc) {
            return false;
        }
        for (int i = 0; i < sc; ++i) {
            if (this.slice(i).equals(a.slice(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(INDArray a) {
        if (a instanceof NDArray) {
            return this.equals((NDArray)a);
        }
        if (this.dimensions != a.dimensionality()) {
            return false;
        }
        if (this.dimensions == 0) {
            return this.get() == a.get();
        }
        int sc = this.sliceCount();
        if (a.sliceCount() != sc) {
            return false;
        }
        for (int i = 0; i < sc; ++i) {
            if (this.slice(i).equals(a.slice(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public NDArray exactClone() {
        NDArray c = new NDArray((double[])this.data.clone(), this.offset, (int[])this.shape.clone(), (int[])this.stride.clone());
        return c;
    }

    @Override
    public INDArray clone() {
        return Array.create(this);
    }

    @Override
    public void multiply(double d) {
        if (this.dimensions == 0) {
            int n = this.offset;
            this.data[n] = this.data[n] * d;
        } else if (this.dimensions == 1) {
            int n = this.getShape(0);
            for (int i = 0; i < n; ++i) {
                int n2 = this.offset + i * this.getStride(0);
                this.data[n2] = this.data[n2] * d;
            }
        } else {
            int n = this.getShape(0);
            for (int i = 0; i < n; ++i) {
                this.slice(i).scale(d);
            }
        }
    }

    @Override
    public void setElements(double[] values, int offset, int length) {
        if (this.dimensions == 0) {
            this.data[this.offset] = values[offset];
        } else if (this.dimensions == 1) {
            if (length > this.getShape(0)) {
                throw new IllegalArgumentException("Too many values for NDArray: " + length);
            }
            int st0 = this.getStride(0);
            for (int i = 0; i < length; ++i) {
                this.data[this.offset + i * st0] = values[offset + i];
            }
        } else {
            int sc = this.getShape(0);
            int ssize = (int)IntArrays.arrayProduct(this.shape, 1, this.dimensions);
            for (int i = 0; i < sc; ++i) {
                this.slice(i).setElements(values, offset + ssize * i, ssize);
            }
        }
    }

    @Override
    public void toDoubleBuffer(DoubleBuffer dest) {
        if (this.dimensions == 0) {
            dest.put(this.data[this.offset]);
        } else if (this.isPackedArray()) {
            dest.put(this.data, 0, this.data.length);
        } else {
            int sc = this.sliceCount();
            for (int i = 0; i < sc; ++i) {
                INDArray s = this.slice(i);
                s.toDoubleBuffer(dest);
            }
        }
    }

    @Override
    public double[] asDoubleArray() {
        return this.isPackedArray() ? this.data : null;
    }

    @Override
    public List<INDArray> getSlices() {
        if (this.dimensions == 0) {
            throw new IllegalArgumentException(ErrorMessages.noSlices(this));
        }
        ArrayList<INDArray> al = new ArrayList<INDArray>();
        int n = this.getShape(0);
        for (int i = 0; i < n; ++i) {
            al.add(this.slice(i));
        }
        return al;
    }

    @Override
    public Iterator<Double> elementIterator() {
        if (this.dimensionality() == 0) {
            return new SingleDoubleIterator(this.data[this.offset]);
        }
        return super.elementIterator();
    }

    @Override
    public void validate() {
        if (this.dimensions > this.shape.length) {
            throw new VectorzException("Insufficient shape data");
        }
        if (this.dimensions > this.stride.length) {
            throw new VectorzException("Insufficient stride data");
        }
        if (this.offset < 0 || this.offset >= this.data.length) {
            throw new VectorzException("Offset out of bounds");
        }
        int[] endIndex = IntArrays.decrementAll(this.shape);
        int endOffset = this.offset + IntArrays.dotProduct(endIndex, this.stride);
        if (endOffset < 0 || endOffset > this.data.length) {
            throw new VectorzException("End offset out of bounds");
        }
        super.validate();
    }

    @Override
    public INDArray immutable() {
        return ImmutableArray.create(this);
    }

    @Override
    public double[] getArray() {
        return this.data;
    }

    public static INDArray wrapStrided(double[] data, int offset, int[] shape, int[] strides) {
        return new NDArray(data, offset, shape, strides);
    }
}

