/*
 * Decompiled with CFR 0.152.
 */
package mikera.vectorz.impl;

import java.nio.DoubleBuffer;
import java.util.Iterator;
import mikera.randomz.Hash;
import mikera.vectorz.AVector;
import mikera.vectorz.Vector;
import mikera.vectorz.impl.StridedElementIterator;
import mikera.vectorz.util.DoubleArrays;
import mikera.vectorz.util.ErrorMessages;
import mikera.vectorz.util.VectorzException;

public class ImmutableVector
extends AVector {
    private static final AVector EMPTY_IMMUTABLE_VECTOR = new ImmutableVector(DoubleArrays.EMPTY);
    private double[] data;
    public int offset;
    public int length;

    private ImmutableVector(double[] data) {
        this(data, 0, data.length);
    }

    private ImmutableVector(double[] data, int offset, int length) {
        this.data = data;
        this.length = length;
        this.offset = offset;
    }

    public static ImmutableVector create(AVector v) {
        int length = v.length();
        double[] data = new double[length];
        v.getElements(data, 0);
        return new ImmutableVector(data, 0, length);
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @Override
    public boolean isFullyMutable() {
        return false;
    }

    @Override
    public boolean isView() {
        return false;
    }

    @Override
    public boolean isZero() {
        return DoubleArrays.isZero(this.data, this.offset, this.length);
    }

    @Override
    public AVector subVector(int start, int length) {
        if (start < 0 || start + length > this.length || length < 0) {
            throw new IllegalArgumentException("Illegal subvector with arguments start= " + start + ", length= " + length);
        }
        if (length == 0) {
            return EMPTY_IMMUTABLE_VECTOR;
        }
        if (length == this.length) {
            return this;
        }
        return new ImmutableVector(this.data, this.offset + start, length);
    }

    @Override
    public void toDoubleBuffer(DoubleBuffer dest) {
        dest.put(this.data, this.offset, this.length());
    }

    @Override
    public void getElements(double[] data, int offset) {
        System.arraycopy(this.data, this.offset, data, offset, this.length());
    }

    @Override
    public void copyTo(int offset, double[] dest, int destOffset, int length) {
        System.arraycopy(this.data, this.offset + offset, dest, destOffset, length);
    }

    @Override
    public void multiplyTo(double[] data, int offset) {
        DoubleArrays.arraymultiply(this.data, this.offset, data, offset, this.length());
    }

    @Override
    public void addToArray(double[] array, int offset) {
        this.addToArray(0, array, offset, this.length());
    }

    @Override
    public void addToArray(int offset, double[] array, int arrayOffset, int length) {
        if (offset < 0 || offset + length > this.length()) {
            throw new IndexOutOfBoundsException();
        }
        DoubleArrays.add(this.data, offset + this.offset, array, arrayOffset, length);
    }

    @Override
    public void addMultipleToArray(double factor, int offset, double[] array, int arrayOffset, int length) {
        int dataOffset = this.offset + offset;
        for (int i = 0; i < length; ++i) {
            int n = i + arrayOffset;
            array[n] = array[n] + factor * this.data[i + dataOffset];
        }
    }

    @Override
    public void divideTo(double[] data, int offset) {
        DoubleArrays.arraydivide(this.data, this.offset, data, offset, this.length());
    }

    @Override
    public double dotProduct(double[] data, int offset) {
        return DoubleArrays.dotProduct(this.data, this.offset, data, offset, this.length());
    }

    @Override
    public double dotProduct(AVector v) {
        return v.dotProduct(this.data, this.offset);
    }

    @Override
    public double magnitudeSquared() {
        return DoubleArrays.elementSquaredSum(this.data, this.offset, this.length);
    }

    @Override
    public double get(int i) {
        return this.data[this.offset + i];
    }

    @Override
    public void set(int i, double value) {
        throw new UnsupportedOperationException(ErrorMessages.immutable(this));
    }

    @Override
    public double unsafeGet(int i) {
        return this.data[this.offset + i];
    }

    @Override
    public void unsafeSet(int i, double value) {
        throw new UnsupportedOperationException(ErrorMessages.immutable(this));
    }

    @Override
    public void addAt(int i, double v) {
        throw new UnsupportedOperationException(ErrorMessages.immutable(this));
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public Iterator<Double> iterator() {
        return new StridedElementIterator(this.data, this.offset, this.length, 1);
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        for (int i = 0; i < this.length; ++i) {
            hashCode = 31 * hashCode + Hash.hashCode((double)this.data[this.offset + i]);
        }
        return hashCode;
    }

    @Override
    public boolean equals(AVector v) {
        if (v.length() != this.length) {
            return false;
        }
        return v.equalsArray(this.data, this.offset);
    }

    @Override
    public boolean equalsArray(double[] data, int offset) {
        return DoubleArrays.equals(data, offset, this.data, this.offset, this.length());
    }

    @Override
    public boolean equalsArray(double[] data) {
        if (this.length() != data.length) {
            return false;
        }
        return DoubleArrays.equals(data, 0, this.data, this.offset, this.length());
    }

    @Override
    public Vector clone() {
        Vector v = Vector.createLength(this.length);
        v.set(this);
        return v;
    }

    @Override
    public AVector exactClone() {
        return new ImmutableVector(this.data, this.offset, this.length);
    }

    @Override
    public AVector immutable() {
        return this;
    }

    @Override
    public void validate() {
        if (this.offset < 0 || this.offset + this.length > this.data.length || this.length < 0) {
            throw new VectorzException("ImmutableVector data out of bounds");
        }
        super.validate();
    }
}

