/*
 * Decompiled with CFR 0.152.
 */
package mikera.vectorz;

import mikera.vectorz.AVector;
import mikera.vectorz.Op;
import mikera.vectorz.Vector;
import mikera.vectorz.impl.APrimitiveVector;
import mikera.vectorz.util.ErrorMessages;

public final class Vector1
extends APrimitiveVector {
    private static final long serialVersionUID = -6312801771839902928L;
    public double x;

    public Vector1() {
    }

    public Vector1(double x) {
        this.x = x;
    }

    public Vector1(double ... values) {
        if (values.length != this.length()) {
            throw new IllegalArgumentException("Can't create " + this.length() + "D vector from: " + values);
        }
        this.x = values[0];
    }

    public static Vector1 of(double x) {
        return new Vector1(x);
    }

    public static Vector1 of(double ... values) {
        return new Vector1(values);
    }

    @Override
    public double dotProduct(AVector a) {
        if (a.length() != this.length()) {
            throw new IllegalArgumentException(ErrorMessages.incompatibleShapes(this, a));
        }
        return this.x * a.unsafeGet(0);
    }

    @Override
    public double dotProduct(Vector v) {
        if (v.length() != this.length()) {
            throw new IllegalArgumentException(ErrorMessages.incompatibleShapes(this, v));
        }
        return this.x * v.data[0];
    }

    @Override
    public double dotProduct(double[] data, int offset) {
        return this.x * data[offset + 0];
    }

    @Override
    public int length() {
        return 1;
    }

    @Override
    public double elementSum() {
        return this.x;
    }

    @Override
    public void applyOp(Op op) {
        this.x = op.apply(this.x);
    }

    @Override
    public double get(int i) {
        if (i == 0) {
            return this.x;
        }
        throw new IndexOutOfBoundsException(ErrorMessages.invalidIndex(this, i));
    }

    @Override
    public void set(int i, double value) {
        if (i != 0) {
            throw new IndexOutOfBoundsException(ErrorMessages.invalidIndex(this, i));
        }
        this.x = value;
    }

    @Override
    public void fill(double v) {
        this.x = v;
    }

    @Override
    public void getElements(double[] data, int offset) {
        data[offset] = this.x;
    }

    @Override
    public void addAt(int i, double value) {
        switch (i) {
            case 0: {
                this.x += value;
                return;
            }
        }
        throw new IndexOutOfBoundsException(ErrorMessages.invalidIndex(this, i));
    }

    public void setValues(double x) {
        this.x = x;
    }

    @Override
    public void negate() {
        this.x = -this.x;
    }

    @Override
    public Vector1 clone() {
        return new Vector1(this.x);
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public Vector1 exactClone() {
        return this.clone();
    }
}

