/*
 * Decompiled with CFR 0.152.
 */
package mikera.matrixx.impl;

import java.util.Arrays;
import mikera.matrixx.AMatrix;
import mikera.matrixx.Matrix;
import mikera.matrixx.Matrixx;
import mikera.matrixx.impl.ABooleanMatrix;
import mikera.randomz.Hash;
import mikera.transformz.ATransform;
import mikera.vectorz.AVector;
import mikera.vectorz.impl.RepeatedElementVector;
import mikera.vectorz.impl.ZeroVector;
import mikera.vectorz.util.ErrorMessages;

public final class ZeroMatrix
extends ABooleanMatrix {
    private final int inputDimensions;
    private final int outputDimensions;

    @Override
    public boolean isFullyMutable() {
        return false;
    }

    private ZeroMatrix(int rows, int columns) {
        this.outputDimensions = rows;
        this.inputDimensions = columns;
    }

    public static ZeroMatrix create(int rows, int columns) {
        return new ZeroMatrix(rows, columns);
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @Override
    public int inputDimensions() {
        return this.inputDimensions;
    }

    @Override
    public boolean isSymmetric() {
        return this.isSquare();
    }

    @Override
    public boolean isDiagonal() {
        return this.isSquare();
    }

    @Override
    public boolean isUpperTriangular() {
        return true;
    }

    @Override
    public boolean isLowerTriangular() {
        return true;
    }

    @Override
    public boolean isBoolean() {
        return true;
    }

    @Override
    public void multiply(double factor) {
    }

    @Override
    public void copyRowTo(int row, double[] dest, int destOffset) {
        Arrays.fill(dest, destOffset, destOffset + this.columnCount(), 0.0);
    }

    @Override
    public void copyColumnTo(int col, double[] dest, int destOffset) {
        Arrays.fill(dest, destOffset, destOffset + this.rowCount(), 0.0);
    }

    @Override
    public void getElements(double[] dest, int destOffset) {
        Arrays.fill(dest, destOffset, destOffset + this.rowCount() * this.columnCount(), 0.0);
    }

    @Override
    public int outputDimensions() {
        return this.outputDimensions;
    }

    @Override
    public int rowCount() {
        return this.outputDimensions;
    }

    @Override
    public int columnCount() {
        return this.inputDimensions;
    }

    @Override
    public double determinant() {
        if (this.isSquare()) {
            throw new UnsupportedOperationException(ErrorMessages.squareMatrixRequired(this));
        }
        return 0.0;
    }

    @Override
    public double trace() {
        return 0.0;
    }

    @Override
    public double calculateElement(int i, AVector v) {
        assert (i >= 0);
        assert (i < this.outputDimensions);
        return 0.0;
    }

    @Override
    public double get(int row, int column) {
        if (row < 0 || row >= this.outputDimensions || column < 0 || column >= this.inputDimensions) {
            throw new IndexOutOfBoundsException(ErrorMessages.invalidIndex(this, row, column));
        }
        return 0.0;
    }

    @Override
    public void set(int row, int column, double value) {
        throw new UnsupportedOperationException(ErrorMessages.immutable(this));
    }

    @Override
    public double unsafeGet(int row, int column) {
        return 0.0;
    }

    @Override
    public void unsafeSet(int row, int column, double value) {
        throw new UnsupportedOperationException(ErrorMessages.immutable(this));
    }

    @Override
    public AMatrix clone() {
        return Matrixx.newMatrix(this.outputDimensions, this.inputDimensions);
    }

    @Override
    public boolean isZero() {
        return true;
    }

    @Override
    public double elementSum() {
        return 0.0;
    }

    @Override
    public long nonZeroCount() {
        return 0L;
    }

    @Override
    public int hashCode() {
        return Hash.zeroVectorHash((int)(this.inputDimensions * this.outputDimensions));
    }

    @Override
    public void transform(AVector input, AVector output) {
        assert (output.length() == this.outputDimensions);
        output.fill(0.0);
    }

    @Override
    public boolean isInvertible() {
        return false;
    }

    @Override
    public AVector asVector() {
        return ZeroVector.create(this.inputDimensions * this.outputDimensions);
    }

    @Override
    public AMatrix compose(ATransform t) {
        assert (this.inputDimensions() == t.outputDimensions());
        return ZeroMatrix.create(this.outputDimensions, t.inputDimensions());
    }

    @Override
    public AMatrix innerProduct(AMatrix m) {
        assert (this.inputDimensions() == m.outputDimensions());
        return ZeroMatrix.create(this.outputDimensions, m.inputDimensions());
    }

    @Override
    public void composeWith(ATransform t) {
        assert (t.inputDimensions() == t.outputDimensions());
    }

    @Override
    public void composeWith(AMatrix t) {
        assert (t.inputDimensions() == t.outputDimensions());
    }

    @Override
    public void elementMul(AMatrix m) {
    }

    @Override
    public boolean equals(AMatrix m) {
        return m.isZero();
    }

    @Override
    public ZeroMatrix getTranspose() {
        if (this.inputDimensions == this.outputDimensions) {
            return this;
        }
        return ZeroMatrix.create(this.inputDimensions, this.outputDimensions);
    }

    @Override
    public Matrix toMatrix() {
        return Matrix.create(this.rowCount(), this.columnCount());
    }

    @Override
    public Matrix toMatrixTranspose() {
        return Matrix.create(this.columnCount(), this.rowCount());
    }

    @Override
    public AVector getLeadingDiagonal() {
        return RepeatedElementVector.create(this.inputDimensions, 0.0);
    }

    @Override
    public ZeroMatrix exactClone() {
        return new ZeroMatrix(this.outputDimensions, this.inputDimensions);
    }
}

