/*
 * Decompiled with CFR 0.152.
 */
package mikera.matrixx;

import java.nio.DoubleBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import mikera.arrayz.Array;
import mikera.arrayz.Arrayz;
import mikera.arrayz.INDArray;
import mikera.arrayz.impl.SliceArray;
import mikera.matrixx.IMatrix;
import mikera.matrixx.Matrix;
import mikera.matrixx.Matrixx;
import mikera.matrixx.algo.Multiplications;
import mikera.matrixx.impl.IdentityMatrix;
import mikera.matrixx.impl.MatrixColumnView;
import mikera.matrixx.impl.MatrixElementIterator;
import mikera.matrixx.impl.MatrixIterator;
import mikera.matrixx.impl.MatrixRowView;
import mikera.matrixx.impl.TransposedMatrix;
import mikera.matrixx.impl.VectorMatrixMN;
import mikera.randomz.Hash;
import mikera.transformz.AAffineTransform;
import mikera.transformz.ALinearTransform;
import mikera.transformz.ATransform;
import mikera.transformz.AffineMN;
import mikera.vectorz.AScalar;
import mikera.vectorz.AVector;
import mikera.vectorz.IOp;
import mikera.vectorz.Op;
import mikera.vectorz.Tools;
import mikera.vectorz.Vector;
import mikera.vectorz.Vectorz;
import mikera.vectorz.impl.AArrayVector;
import mikera.vectorz.impl.MatrixBandVector;
import mikera.vectorz.impl.Vector0;
import mikera.vectorz.util.DoubleArrays;
import mikera.vectorz.util.ErrorMessages;
import mikera.vectorz.util.IntArrays;
import mikera.vectorz.util.VectorzException;

public abstract class AMatrix
extends ALinearTransform
implements IMatrix,
Iterable<AVector> {
    @Override
    public abstract int rowCount();

    @Override
    public abstract int columnCount();

    @Override
    public abstract double get(int var1, int var2);

    @Override
    public abstract void set(int var1, int var2, double var3);

    @Override
    public final double get(int row) {
        throw new VectorzException("1D get not supported on matrix!");
    }

    @Override
    public final double get() {
        throw new VectorzException("0D get not supported on matrix!");
    }

    @Override
    public void set(int row, double value) {
        throw new VectorzException("1D get not supported on matrix!");
    }

    @Override
    public void set(double value) {
        throw new VectorzException("0D set not supported on matrix!");
    }

    @Override
    public void fill(double value) {
        this.asVector().fill(value);
    }

    public void unsafeSet(int row, int column, double value) {
        this.set(row, column, value);
    }

    public double unsafeGet(int row, int column) {
        return this.get(row, column);
    }

    @Override
    public void clamp(double min, double max) {
        int len = this.rowCount();
        for (int i = 0; i < len; ++i) {
            this.getRow(i).clamp(min, max);
        }
    }

    @Override
    public void pow(double exponent) {
        int len = this.rowCount();
        for (int i = 0; i < len; ++i) {
            this.getRow(i).pow(exponent);
        }
    }

    @Override
    public void square() {
        int len = this.rowCount();
        for (int i = 0; i < len; ++i) {
            this.getRow(i).square();
        }
    }

    @Override
    public void set(int[] indexes, double value) {
        if (indexes.length != 2) {
            throw new VectorzException("" + indexes.length + "D set not supported on AMatrix");
        }
        this.set(indexes[0], indexes[1], value);
    }

    @Override
    public int dimensionality() {
        return 2;
    }

    @Override
    public long elementCount() {
        return (long)this.rowCount() * (long)this.columnCount();
    }

    @Override
    public AVector slice(int rowNumber) {
        return this.getRow(rowNumber);
    }

    @Override
    public INDArray slice(int dimension, int index) {
        if (dimension < 0 || dimension >= 2) {
            throw new IllegalArgumentException("Dimension out of range!");
        }
        return dimension == 0 ? this.getRow(index) : this.getColumn(index);
    }

    @Override
    public int sliceCount() {
        return this.rowCount();
    }

    public List<AVector> getSlices() {
        ArrayList<AVector> al = new ArrayList<AVector>();
        int rc = this.rowCount();
        for (int i = 0; i < rc; ++i) {
            al.add(this.getRow(i));
        }
        return al;
    }

    @Override
    public List<INDArray> getSliceViews() {
        ArrayList<INDArray> al = new ArrayList<INDArray>();
        int rc = this.rowCount();
        for (int i = 0; i < rc; ++i) {
            al.add(this.getRow(i));
        }
        return al;
    }

    @Override
    public int[] getShape() {
        return new int[]{this.rowCount(), this.columnCount()};
    }

    @Override
    public int getShape(int dim) {
        if (dim == 0) {
            return this.rowCount();
        }
        if (dim == 1) {
            return this.columnCount();
        }
        throw new IndexOutOfBoundsException("Matrix does not have dimension: " + dim);
    }

    @Override
    public long[] getLongShape() {
        return new long[]{this.rowCount(), this.columnCount()};
    }

    @Override
    public double get(int ... indexes) {
        assert (indexes.length == 2);
        return this.get(indexes[0], indexes[1]);
    }

    public AVector getLeadingDiagonal() {
        return this.getBand(0);
    }

    @Override
    public double calculateElement(int i, AVector v) {
        return this.getRow(i).dotProduct(v);
    }

    public double calculateElement(int i, Vector v) {
        return this.getRow(i).dotProduct(v);
    }

    @Override
    public AAffineTransform toAffineTransform() {
        return new AffineMN((AMatrix)new VectorMatrixMN(this), this.getTranslationComponent());
    }

    @Override
    public AMatrix getMatrixComponent() {
        return this;
    }

    @Override
    public boolean isIdentity() {
        int cc;
        int rc = this.rowCount();
        if (rc != (cc = this.columnCount())) {
            return false;
        }
        for (int i = 0; i < rc; ++i) {
            for (int j = 0; j < cc; ++j) {
                double expected;
                double d = expected = i == j ? 1.0 : 0.0;
                if (this.unsafeGet(i, j) == expected) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isSquare() {
        return this.rowCount() == this.columnCount();
    }

    public boolean isOrthogonal() {
        return this.isSquare() && this.getTranspose().innerProduct(this).epsilonEquals(IdentityMatrix.create(this.columnCount()));
    }

    public boolean hasOrthonormalColumns() {
        return this.getTranspose().innerProduct(this).epsilonEquals(IdentityMatrix.create(this.columnCount()));
    }

    public boolean hassOrthonormalRows() {
        return this.innerProduct(this.getTranspose()).epsilonEquals(IdentityMatrix.create(this.columnCount()));
    }

    @Override
    public int inputDimensions() {
        return this.columnCount();
    }

    @Override
    public int outputDimensions() {
        return this.rowCount();
    }

    @Override
    public INDArray reshape(int ... dimensions) {
        int ndims = dimensions.length;
        if (ndims == 1) {
            return this.toVector().subVector(0, dimensions[0]);
        }
        if (ndims == 2) {
            return Matrixx.createFromVector(this.asVector(), dimensions[0], dimensions[1]);
        }
        return Arrayz.createFromVector(this.toVector(), dimensions);
    }

    public Matrix reshape(int rows, int cols) {
        return Matrixx.createFromVector(this.asVector(), rows, cols);
    }

    public AMatrix subMatrix(int rowStart, int rows, int colStart, int cols) {
        VectorMatrixMN vm = new VectorMatrixMN(0, cols);
        for (int i = 0; i < rows; ++i) {
            vm.appendRow(this.getRow(rowStart + i).subVector(colStart, cols));
        }
        return vm;
    }

    @Override
    public AVector transform(AVector source) {
        Vector v = Vector.createLength(this.outputDimensions());
        if (source instanceof Vector) {
            this.transform((Vector)source, v);
        } else {
            this.transform(source, (AVector)v);
        }
        return v;
    }

    @Override
    public Vector transform(Vector source) {
        Vector v = Vector.createLength(this.outputDimensions());
        this.transform(source, v);
        return v;
    }

    @Override
    public void transform(AVector source, AVector dest) {
        if (source instanceof Vector && dest instanceof Vector) {
            this.transform((Vector)source, (Vector)dest);
            return;
        }
        int rc = this.rowCount();
        int cc = this.columnCount();
        if (source.length() != cc) {
            throw new IllegalArgumentException(ErrorMessages.wrongSourceLength(source));
        }
        if (dest.length() != rc) {
            throw new IllegalArgumentException(ErrorMessages.wrongDestLength(dest));
        }
        for (int row = 0; row < rc; ++row) {
            double total = 0.0;
            for (int column = 0; column < cc; ++column) {
                total += this.unsafeGet(row, column) * source.unsafeGet(column);
            }
            dest.unsafeSet(row, total);
        }
    }

    public void transform(Vector source, Vector dest) {
        int rc = this.rowCount();
        int cc = this.columnCount();
        if (source.length() != cc) {
            throw new IllegalArgumentException(ErrorMessages.wrongSourceLength(source));
        }
        if (dest.length() != rc) {
            throw new IllegalArgumentException(ErrorMessages.wrongDestLength(dest));
        }
        for (int row = 0; row < rc; ++row) {
            double total = 0.0;
            for (int column = 0; column < cc; ++column) {
                total += this.unsafeGet(row, column) * source.unsafeGet(column);
            }
            dest.unsafeSet(row, total);
        }
    }

    @Override
    public void transformInPlace(AVector v) {
        if (v instanceof AArrayVector) {
            this.transformInPlace((AArrayVector)v);
            return;
        }
        double[] temp = new double[v.length()];
        int rc = this.rowCount();
        int cc = this.columnCount();
        if (v.length() != rc) {
            throw new IllegalArgumentException(ErrorMessages.incompatibleShapes(this, v));
        }
        if (rc != cc) {
            throw new UnsupportedOperationException("Cannot transform in place with a non-square transformation");
        }
        for (int row = 0; row < rc; ++row) {
            double total = 0.0;
            for (int column = 0; column < cc; ++column) {
                total += this.unsafeGet(row, column) * v.unsafeGet(column);
            }
            temp[row] = total;
        }
        v.setElements(temp);
    }

    public void transformInPlace(AArrayVector v) {
        double[] temp = new double[v.length()];
        int rc = this.rowCount();
        int cc = this.columnCount();
        if (v.length() != rc) {
            throw new IllegalArgumentException(ErrorMessages.incompatibleShapes(this, v));
        }
        if (rc != cc) {
            throw new UnsupportedOperationException("Cannot transform in place with a non-square transformation");
        }
        double[] data = v.getArray();
        int offset = v.getArrayOffset();
        for (int row = 0; row < rc; ++row) {
            double total = 0.0;
            for (int column = 0; column < cc; ++column) {
                total += this.unsafeGet(row, column) * data[offset + column];
            }
            temp[row] = total;
        }
        v.setElements(temp);
    }

    public AVector getRow(int row) {
        return new MatrixRowView(this, row);
    }

    public AVector getColumn(int column) {
        return new MatrixColumnView(this, column);
    }

    public AVector cloneRow(int row) {
        int cc = this.columnCount();
        Vector v = Vector.createLength(cc);
        this.copyRowTo(row, v.data, 0);
        return v;
    }

    public void set(AMatrix a) {
        int rc = this.rowCount();
        if (a.rowCount() != rc) {
            throw new IllegalArgumentException(ErrorMessages.incompatibleShapes(this, a));
        }
        int cc = this.columnCount();
        if (a.columnCount() != cc) {
            throw new IllegalArgumentException(ErrorMessages.incompatibleShapes(this, a));
        }
        for (int row = 0; row < rc; ++row) {
            for (int column = 0; column < cc; ++column) {
                this.set(row, column, a.get(row, column));
            }
        }
    }

    @Override
    public void set(INDArray a) {
        if (a instanceof AMatrix) {
            this.set((AMatrix)a);
            return;
        }
        if (a instanceof AVector) {
            for (AVector r : this) {
                r.set((AVector)a);
            }
            return;
        }
        if (a instanceof AScalar) {
            this.set(a.get());
            return;
        }
        throw new UnsupportedOperationException("Can't set matrix to array: " + a.getClass() + " with shape: " + a.getShape());
    }

    @Override
    public void set(Object o) {
        if (o instanceof INDArray) {
            this.set((INDArray)o);
            return;
        }
        if (o instanceof Number) {
            this.set(((Number)o).doubleValue());
            return;
        }
        throw new UnsupportedOperationException("Can't set to value for " + o.getClass().toString());
    }

    @Override
    public void setElements(double[] values, int offset, int length) {
        if ((long)length != this.elementCount()) {
            throw new IllegalArgumentException("Incorrect element count: " + length);
        }
        int rc = this.rowCount();
        int cc = this.columnCount();
        for (int i = 0; i < rc; ++i) {
            int iOffset = offset + i * cc;
            for (int j = 0; j < cc; ++j) {
                this.unsafeSet(i, j, values[iOffset + j]);
            }
        }
    }

    @Override
    public void getElements(double[] dest, int offset) {
        int rc = this.rowCount();
        int cc = this.columnCount();
        for (int i = 0; i < rc; ++i) {
            this.copyRowTo(i, dest, offset + i * cc);
        }
    }

    @Override
    public void copyTo(double[] arr) {
        this.getElements(arr, 0);
    }

    @Override
    public void setElements(double[] values) {
        this.setElements(values, 0, values.length);
    }

    @Override
    public boolean isFullyMutable() {
        return true;
    }

    @Override
    public boolean isMutable() {
        return this.isFullyMutable();
    }

    @Override
    public boolean isElementConstrained() {
        return false;
    }

    @Override
    public AMatrix clone() {
        return Matrixx.deepCopy(this);
    }

    @Override
    public INDArray ensureMutable() {
        if (this.isFullyMutable() && !this.isView()) {
            return this;
        }
        return this.clone();
    }

    public double determinant() {
        if (!this.isSquare()) {
            throw new UnsupportedOperationException("Cannot take determinant of non-square matrix!");
        }
        int rc = this.rowCount();
        int[] inds = new int[rc];
        for (int i = 0; i < rc; ++i) {
            inds[i] = i;
        }
        return this.calcDeterminant(inds, 0);
    }

    private double calcDeterminant(int[] inds, int offset) {
        int rc = this.rowCount();
        if (offset == rc - 1) {
            return this.unsafeGet(offset, inds[offset]);
        }
        double det = this.unsafeGet(offset, inds[offset]) * this.calcDeterminant(inds, offset + 1);
        for (int i = 1; i < rc - offset; ++i) {
            IntArrays.swap(inds, offset, offset + i);
            det -= this.unsafeGet(offset, inds[offset]) * this.calcDeterminant(inds, offset + 1);
            IntArrays.swap(inds, offset, offset + i);
        }
        return det;
    }

    public AMatrix toMutableMatrix() {
        return Matrixx.create(this);
    }

    public void transposeInPlace() {
        if (!this.isSquare()) {
            throw new UnsupportedOperationException(ErrorMessages.squareMatrixRequired(this));
        }
        int dims = this.rowCount();
        for (int i = 0; i < dims; ++i) {
            for (int j = i + 1; j < dims; ++j) {
                double temp = this.unsafeGet(i, j);
                this.unsafeSet(i, j, this.unsafeGet(j, i));
                this.unsafeSet(j, i, temp);
            }
        }
    }

    @Override
    public AMatrix getTranspose() {
        return TransposedMatrix.wrap(this);
    }

    @Override
    public AMatrix getTransposeView() {
        return TransposedMatrix.wrap(this);
    }

    @Override
    public Matrix getTransposeCopy() {
        int rc = this.rowCount();
        int cc = this.columnCount();
        Matrix m = Matrix.create(cc, rc);
        for (int j = 0; j < cc; ++j) {
            this.copyColumnTo(j, m.data, j * rc);
        }
        return m;
    }

    public void add(AMatrix m) {
        int rc = this.rowCount();
        int cc = this.columnCount();
        if (rc != m.rowCount() || cc != m.columnCount()) {
            throw new IllegalArgumentException(ErrorMessages.mismatch(this, m));
        }
        for (int i = 0; i < rc; ++i) {
            for (int j = 0; j < cc; ++j) {
                this.unsafeSet(i, j, this.unsafeGet(i, j) + m.unsafeGet(i, j));
            }
        }
    }

    public void add(AVector v) {
        int rc = this.rowCount();
        int cc = this.columnCount();
        if (cc != v.length()) {
            throw new IllegalArgumentException(ErrorMessages.mismatch(this, v));
        }
        for (int i = 0; i < rc; ++i) {
            for (int j = 0; j < cc; ++j) {
                this.unsafeSet(i, j, this.unsafeGet(i, j) + v.unsafeGet(j));
            }
        }
    }

    public void sub(AVector v) {
        int rc = this.rowCount();
        int cc = this.columnCount();
        if (cc != v.length()) {
            throw new IllegalArgumentException(ErrorMessages.incompatibleShapes(this, v));
        }
        for (int i = 0; i < rc; ++i) {
            for (int j = 0; j < cc; ++j) {
                this.addAt(i, j, -v.unsafeGet(j));
            }
        }
    }

    @Override
    public void sub(double d) {
        this.add(-d);
    }

    @Override
    public final void scale(double factor) {
        this.multiply(factor);
    }

    @Override
    public final void scaleAdd(double factor, double constant) {
        this.multiply(factor);
        this.add(constant);
    }

    @Override
    public void multiply(double factor) {
        int rc = this.rowCount();
        int cc = this.columnCount();
        for (int i = 0; i < rc; ++i) {
            for (int j = 0; j < cc; ++j) {
                this.unsafeSet(i, j, this.unsafeGet(i, j) * factor);
            }
        }
    }

    @Override
    public double elementSum() {
        int rc = this.rowCount();
        int cc = this.columnCount();
        double result = 0.0;
        for (int i = 0; i < rc; ++i) {
            for (int j = 0; j < cc; ++j) {
                result += this.unsafeGet(i, j);
            }
        }
        return result;
    }

    @Override
    public double elementSquaredSum() {
        int rc = this.rowCount();
        int cc = this.columnCount();
        double result = 0.0;
        for (int i = 0; i < rc; ++i) {
            for (int j = 0; j < cc; ++j) {
                double value = this.unsafeGet(i, j);
                result += value * value;
            }
        }
        return result;
    }

    @Override
    public Iterator<Double> elementIterator() {
        return new MatrixElementIterator(this);
    }

    @Override
    public boolean isBoolean() {
        double[] data = Tools.getElements(this);
        return DoubleArrays.isBoolean(data, 0, data.length);
    }

    @Override
    public long nonZeroCount() {
        long result = 0L;
        int rc = this.rowCount();
        int cc = this.columnCount();
        for (int i = 0; i < rc; ++i) {
            for (int j = 0; j < cc; ++j) {
                if (this.unsafeGet(i, j) == 0.0) continue;
                ++result;
            }
        }
        return result;
    }

    public void sub(AMatrix m) {
        this.addMultiple(m, -1.0);
    }

    public void sub(AScalar a) {
        this.add(-a.get());
    }

    public void add(AScalar a) {
        this.add(a.get());
    }

    @Override
    public void negate() {
        this.multiply(-1.0);
    }

    @Override
    public void reciprocal() {
        int sc = this.rowCount();
        for (int i = 0; i < sc; ++i) {
            this.getRow(i).reciprocal();
        }
    }

    @Override
    public void abs() {
        int sc = this.rowCount();
        for (int i = 0; i < sc; ++i) {
            this.getRow(i).abs();
        }
    }

    @Override
    public void sqrt() {
        int sc = this.rowCount();
        for (int i = 0; i < sc; ++i) {
            this.getRow(i).sqrt();
        }
    }

    @Override
    public void log() {
        int sc = this.rowCount();
        for (int i = 0; i < sc; ++i) {
            this.getRow(i).log();
        }
    }

    @Override
    public void exp() {
        int sc = this.rowCount();
        for (int i = 0; i < sc; ++i) {
            this.getRow(i).exp();
        }
    }

    @Override
    public void signum() {
        int sc = this.rowCount();
        for (int i = 0; i < sc; ++i) {
            this.getRow(i).signum();
        }
    }

    public void elementMul(AMatrix m) {
        int rc = this.rowCount();
        int cc = this.columnCount();
        if (rc != m.rowCount() || cc != m.columnCount()) {
            throw new IllegalArgumentException(ErrorMessages.mismatch(this, m));
        }
        for (int i = 0; i < rc; ++i) {
            for (int j = 0; j < cc; ++j) {
                this.unsafeSet(i, j, this.unsafeGet(i, j) * m.unsafeGet(i, j));
            }
        }
    }

    public void elementDiv(AMatrix m) {
        int rc = this.rowCount();
        int cc = this.columnCount();
        if (rc != m.rowCount() || cc != m.columnCount()) {
            throw new IllegalArgumentException(ErrorMessages.mismatch(this, m));
        }
        for (int i = 0; i < rc; ++i) {
            for (int j = 0; j < cc; ++j) {
                this.unsafeSet(i, j, this.unsafeGet(i, j) / m.unsafeGet(i, j));
            }
        }
    }

    public void mul(AMatrix a) {
        this.composeWith(a);
    }

    public void multiplyRow(int i, double factor) {
        this.getRow(i).multiply(factor);
    }

    public void addRowMultiple(int src, int dst, double factor) {
        this.getRow(dst).addMultiple(this.getRow(src), factor);
    }

    public void swapRows(int i, int j) {
        if (i == j) {
            return;
        }
        AVector a = this.getRow(i);
        AVector b = this.getRow(j);
        int cc = this.columnCount();
        for (int k = 0; k < cc; ++k) {
            double t = a.unsafeGet(k);
            a.unsafeSet(k, b.unsafeGet(k));
            b.unsafeSet(k, t);
        }
    }

    public void swapColumns(int i, int j) {
        if (i == j) {
            return;
        }
        AVector a = this.getColumn(i);
        AVector b = this.getColumn(j);
        int rc = this.rowCount();
        for (int k = 0; k < rc; ++k) {
            double t = a.unsafeGet(k);
            a.unsafeSet(k, b.unsafeGet(k));
            b.unsafeSet(k, t);
        }
    }

    @Override
    public void composeWith(ATransform a) {
        if (a instanceof AMatrix) {
            this.composeWith((AMatrix)a);
        }
        super.composeWith(a);
    }

    public void composeWith(AMatrix a) {
        AMatrix t = this.compose(a);
        this.set(t);
    }

    @Override
    public boolean isView() {
        return false;
    }

    @Override
    public AMatrix copyOfMatrix() {
        return this.clone();
    }

    @Override
    public AVector copyOfTranslationVector() {
        return Vectorz.createZeroVector(this.rowCount());
    }

    public void addMultiple(AMatrix m, double factor) {
        int rc = this.rowCount();
        int cc = this.columnCount();
        assert (rc == m.rowCount());
        assert (cc == m.columnCount());
        for (int i = 0; i < rc; ++i) {
            for (int j = 0; j < cc; ++j) {
                this.set(i, j, this.get(i, j) + m.get(i, j) * factor);
            }
        }
    }

    @Override
    public Iterator<AVector> iterator() {
        return new MatrixIterator(this);
    }

    @Override
    public boolean epsilonEquals(INDArray a) {
        return this.epsilonEquals(a, 1.0E-7);
    }

    @Override
    public boolean epsilonEquals(INDArray a, double epsilon) {
        if (a.dimensionality() != 2) {
            return false;
        }
        int sc = this.rowCount();
        if (a.sliceCount() != sc) {
            return false;
        }
        for (int i = 0; i < sc; ++i) {
            AVector s = this.getRow(i);
            if (s.epsilonEquals(a.slice(i), epsilon)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof AMatrix) {
            return this.equals((AMatrix)o);
        }
        if (o instanceof INDArray) {
            return this.equals((INDArray)o);
        }
        return false;
    }

    public boolean equals(AMatrix a) {
        int rc = this.rowCount();
        if (rc != a.rowCount()) {
            return false;
        }
        int cc = this.columnCount();
        if (cc != a.columnCount()) {
            return false;
        }
        for (int i = 0; i < rc; ++i) {
            for (int j = 0; j < cc; ++j) {
                if (this.unsafeGet(i, j) == a.unsafeGet(i, j)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean equals(INDArray v) {
        if (v instanceof AMatrix) {
            return this.equals((AMatrix)v);
        }
        if (v.dimensionality() != 2) {
            return false;
        }
        int[] vs = v.getShape();
        int rc = this.rowCount();
        if (rc != vs[0]) {
            return false;
        }
        int cc = this.columnCount();
        if (cc != vs[1]) {
            return false;
        }
        int[] ind = new int[2];
        for (int i = 0; i < rc; ++i) {
            ind[0] = i;
            for (int j = 0; j < cc; ++j) {
                ind[1] = j;
                if (this.unsafeGet(i, j) == v.get(ind)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean epsilonEquals(AMatrix a) {
        int rc = this.rowCount();
        int cc = this.columnCount();
        if (rc != a.rowCount() || cc != a.columnCount()) {
            throw new IllegalArgumentException(ErrorMessages.mismatch(this, a));
        }
        for (int i = 0; i < rc; ++i) {
            for (int j = 0; j < cc; ++j) {
                if (Tools.epsilonEquals(this.unsafeGet(i, j), a.unsafeGet(i, j))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean equals(AAffineTransform a) {
        return a.getTranslationComponent().isIdentity() && this.equals(a.getMatrixComponent());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int rc = this.rowCount();
        sb.append("[");
        for (int i = 0; i < rc; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(this.getRow(i).toString());
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        int rc = this.rowCount();
        int cc = this.columnCount();
        for (int i = 0; i < rc; ++i) {
            for (int j = 0; j < cc; ++j) {
                hashCode = 31 * hashCode + Hash.hashCode((double)this.unsafeGet(i, j));
            }
        }
        return hashCode;
    }

    @Override
    public AVector asVector() {
        int rc = this.rowCount();
        if (rc == 0) {
            return Vector0.INSTANCE;
        }
        AVector v = this.getRow(0);
        for (int i = 1; i < rc; ++i) {
            v = Vectorz.join(v, this.getRow(i));
        }
        return v;
    }

    @Override
    public List<Double> asElementList() {
        return this.asVector().asElementList();
    }

    @Override
    public ATransform compose(ATransform a) {
        if (!(a instanceof AMatrix)) {
            return super.compose(a);
        }
        return this.compose((AMatrix)a);
    }

    public final AMatrix compose(AMatrix a) {
        return this.innerProduct(a);
    }

    public AMatrix innerProduct(AMatrix a) {
        if (a instanceof Matrix) {
            return this.innerProduct((Matrix)a);
        }
        int rc = this.rowCount();
        int cc = a.columnCount();
        int ic = this.columnCount();
        if (ic != a.rowCount()) {
            throw new IllegalArgumentException(ErrorMessages.incompatibleShapes(this, a));
        }
        Matrix result = Matrix.create(rc, cc);
        for (int i = 0; i < rc; ++i) {
            for (int j = 0; j < cc; ++j) {
                double acc = 0.0;
                for (int k = 0; k < ic; ++k) {
                    acc += this.unsafeGet(i, k) * a.unsafeGet(k, j);
                }
                result.unsafeSet(i, j, acc);
            }
        }
        return result;
    }

    public final Vector innerProduct(Vector v) {
        return this.transform(v);
    }

    public Matrix innerProduct(Matrix a) {
        return Multiplications.multiply(this, (AMatrix)a);
    }

    public AVector innerProduct(AVector v) {
        if (v instanceof Vector) {
            return this.transform((Vector)v);
        }
        return this.transform(v);
    }

    public AMatrix innerProduct(AScalar s) {
        Matrix r = this.toMatrix();
        r.scale(s.get());
        return r;
    }

    public AMatrix transposeInnerProduct(AMatrix s) {
        Matrix r = this.toMatrixTranspose();
        return Multiplications.multiply(r, s);
    }

    public Matrix transposeInnerProduct(Matrix s) {
        Matrix r = this.toMatrixTranspose();
        return Multiplications.multiply(r, (AMatrix)s);
    }

    @Override
    public INDArray innerProduct(INDArray a) {
        if (a instanceof AVector) {
            return this.innerProduct((AVector)a);
        }
        if (a instanceof AMatrix) {
            return this.compose((AMatrix)a);
        }
        if (a instanceof AScalar) {
            return this.innerProduct((AScalar)a);
        }
        if (a.dimensionality() <= 2) {
            return this.innerProduct(Arrayz.create(a));
        }
        return Array.create(this).innerProduct(a);
    }

    @Override
    public INDArray outerProduct(INDArray a) {
        ArrayList<INDArray> al = new ArrayList<INDArray>();
        for (AVector s : this) {
            al.add(s.outerProduct(a));
        }
        return Arrayz.create(al);
    }

    @Override
    public AMatrix inverse() {
        Matrix result = Matrixx.createInverse(this);
        return result;
    }

    public double trace() {
        int rc = this.rowCount();
        assert (rc == this.columnCount());
        double result = 0.0;
        for (int i = 0; i < rc; ++i) {
            result += this.unsafeGet(i, i);
        }
        return result;
    }

    @Override
    public boolean isInvertible() {
        return this.isSquare() && this.determinant() != 0.0;
    }

    @Override
    public Vector toVector() {
        int rc = this.rowCount();
        int cc = this.columnCount();
        Vector v = Vector.createLength(rc * cc);
        this.getElements(v.data, 0);
        return v;
    }

    @Override
    public Array toArray() {
        return Array.create(this);
    }

    public Matrix toMatrix() {
        int rc = this.rowCount();
        int cc = this.columnCount();
        Matrix m = Matrix.create(rc, cc);
        this.getElements(m.data, 0);
        return m;
    }

    public Matrix toMatrixTranspose() {
        int rc = this.rowCount();
        int cc = this.columnCount();
        Matrix m = Matrix.create(cc, rc);
        this.getTransposeView().getElements(m.data, 0);
        return m;
    }

    @Override
    public void toDoubleBuffer(DoubleBuffer dest) {
        int n = this.rowCount();
        for (int i = 0; i < n; ++i) {
            this.getRow(i).toDoubleBuffer(dest);
        }
    }

    @Override
    public double[] toDoubleArray() {
        int n = (int)this.elementCount();
        double[] result = new double[n];
        this.getElements(result, 0);
        return result;
    }

    @Override
    public double[] asDoubleArray() {
        return null;
    }

    @Override
    public void applyOp(Op op) {
        int rc = this.rowCount();
        int cc = this.columnCount();
        for (int i = 0; i < rc; ++i) {
            for (int j = 0; j < cc; ++j) {
                this.unsafeSet(i, j, op.apply(this.unsafeGet(i, j)));
            }
        }
    }

    @Override
    public void applyOp(IOp op) {
        if (op instanceof Op) {
            this.applyOp((Op)op);
            return;
        }
        int rc = this.rowCount();
        int cc = this.columnCount();
        for (int i = 0; i < rc; ++i) {
            for (int j = 0; j < cc; ++j) {
                this.unsafeSet(i, j, op.apply(this.unsafeGet(i, j)));
            }
        }
    }

    @Override
    public void add(INDArray a) {
        block3: {
            int rc;
            int dims;
            block7: {
                block6: {
                    block5: {
                        block4: {
                            block2: {
                                if (!(a instanceof AMatrix)) break block2;
                                this.add((AMatrix)a);
                                break block3;
                            }
                            if (!(a instanceof AVector)) break block4;
                            this.add((AVector)a);
                            break block3;
                        }
                        if (!(a instanceof AScalar)) break block5;
                        this.add(a.get());
                        break block3;
                    }
                    dims = a.dimensionality();
                    rc = this.rowCount();
                    if (dims != 0) break block6;
                    this.add(a.get());
                    break block3;
                }
                if (dims != 1) break block7;
                for (int i = 0; i < rc; ++i) {
                    this.slice(i).add(a);
                }
                break block3;
            }
            if (dims != 2) break block3;
            for (int i = 0; i < rc; ++i) {
                this.slice(i).add(a.slice(i));
            }
        }
    }

    @Override
    public void multiply(INDArray a) {
        if (a instanceof AMatrix) {
            this.elementMul((AMatrix)a);
        } else if (a instanceof AScalar) {
            this.multiply(a.get());
        } else {
            int dims = a.dimensionality();
            int rc = this.rowCount();
            if (dims == 0) {
                this.multiply(a.get());
            } else if (dims == 1) {
                for (int i = 0; i < rc; ++i) {
                    this.slice(i).multiply(a);
                }
            } else if (dims == 2) {
                for (int i = 0; i < rc; ++i) {
                    this.slice(i).multiply(a.slice(i));
                }
            } else {
                throw new IllegalArgumentException(ErrorMessages.incompatibleShapes(this, a));
            }
        }
    }

    @Override
    public void divide(INDArray a) {
        if (a instanceof AMatrix) {
            this.elementDiv((AMatrix)a);
        } else if (a instanceof AScalar) {
            this.multiply(1.0 / a.get());
        } else {
            int dims = a.dimensionality();
            int rc = this.rowCount();
            if (dims == 0) {
                this.multiply(1.0 / a.get());
            } else if (dims == 1) {
                for (int i = 0; i < rc; ++i) {
                    this.slice(i).divide(a);
                }
            } else if (dims == 2) {
                for (int i = 0; i < rc; ++i) {
                    this.slice(i).divide(a.slice(i));
                }
            } else {
                throw new IllegalArgumentException(ErrorMessages.incompatibleShapes(this, a));
            }
        }
    }

    @Override
    public void divide(double factor) {
        this.multiply(1.0 / factor);
    }

    @Override
    public void sub(INDArray a) {
        block3: {
            int rc;
            int dims;
            block7: {
                block6: {
                    block5: {
                        block4: {
                            block2: {
                                if (!(a instanceof AMatrix)) break block2;
                                this.sub((AMatrix)a);
                                break block3;
                            }
                            if (!(a instanceof AVector)) break block4;
                            this.sub((AVector)a);
                            break block3;
                        }
                        if (!(a instanceof AScalar)) break block5;
                        this.sub(a.get());
                        break block3;
                    }
                    dims = a.dimensionality();
                    rc = this.rowCount();
                    if (dims != 0) break block6;
                    this.sub(a.get());
                    break block3;
                }
                if (dims != 1) break block7;
                for (int i = 0; i < rc; ++i) {
                    this.slice(i).sub(a);
                }
                break block3;
            }
            if (dims != 2) break block3;
            for (int i = 0; i < rc; ++i) {
                this.slice(i).sub(a.slice(i));
            }
        }
    }

    @Override
    public void add(double d) {
        int rc = this.rowCount();
        int cc = this.columnCount();
        for (int i = 0; i < rc; ++i) {
            for (int j = 0; j < cc; ++j) {
                this.addAt(i, j, d);
            }
        }
    }

    public void addAt(int i, int j, double d) {
        this.unsafeSet(i, j, this.unsafeGet(i, j) + d);
    }

    @Override
    public INDArray broadcast(int ... targetShape) {
        int tdims = targetShape.length;
        if (tdims < 2) {
            throw new IllegalArgumentException(ErrorMessages.incompatibleBroadcast(this, targetShape));
        }
        if (2 == tdims) {
            if (this.rowCount() == targetShape[0] && this.columnCount() == targetShape[1]) {
                return this;
            }
            throw new IllegalArgumentException(ErrorMessages.incompatibleBroadcast(this, targetShape));
        }
        if (this.rowCount() != targetShape[tdims - 2] || this.columnCount() != targetShape[tdims - 1]) {
            throw new IllegalArgumentException(ErrorMessages.incompatibleBroadcast(this, targetShape));
        }
        int n = targetShape[0];
        INDArray s = this.broadcast(Arrays.copyOfRange(targetShape, 1, tdims));
        return SliceArray.repeat(s, n);
    }

    @Override
    public INDArray broadcastLike(INDArray target) {
        if (target instanceof AMatrix) {
            return this.broadcastLike((AMatrix)target);
        }
        return this.broadcast(target.getShape());
    }

    public INDArray broadcastLike(AMatrix target) {
        if (this.rowCount() == target.rowCount() && this.columnCount() == target.columnCount()) {
            return this;
        }
        throw new IllegalArgumentException(ErrorMessages.incompatibleShapes(this, target));
    }

    @Override
    public INDArray broadcastCloneLike(INDArray target) {
        INDArray r = this;
        if (target.dimensionality() > 2) {
            r = r.broadcastLike(target);
        }
        return r.clone();
    }

    @Override
    public boolean isZero() {
        int rc = this.rowCount();
        int cc = this.columnCount();
        for (int i = 0; i < rc; ++i) {
            for (int j = 0; j < cc; ++j) {
                if (this.unsafeGet(i, j) == 0.0) continue;
                return false;
            }
        }
        return true;
    }

    public void isPositiveDefinite() {
        throw new UnsupportedOperationException();
    }

    public boolean isDiagonal() {
        int cc;
        int rc = this.rowCount();
        if (rc != (cc = this.columnCount())) {
            return false;
        }
        for (int i = 0; i < rc; ++i) {
            for (int j = 0; j < cc; ++j) {
                if (i == j || this.unsafeGet(i, j) == 0.0) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isSameShape(INDArray a) {
        if (a instanceof AMatrix) {
            return this.isSameShape((AMatrix)a);
        }
        if (a.dimensionality() != 2) {
            return false;
        }
        for (int i = 0; i < 2; ++i) {
            if (this.getShape(i) == a.getShape(i)) continue;
            return false;
        }
        return true;
    }

    public boolean isSameShape(AMatrix a) {
        return this.rowCount() == a.rowCount() && this.columnCount() == a.columnCount();
    }

    public boolean isRectangularDiagonal() {
        int rc = this.rowCount();
        int cc = this.columnCount();
        for (int i = 0; i < rc; ++i) {
            for (int j = 0; j < cc; ++j) {
                if (i == j || this.unsafeGet(i, j) == 0.0) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isSymmetric() {
        int cc;
        int rc = this.rowCount();
        if (rc != (cc = this.columnCount())) {
            return false;
        }
        for (int i = 0; i < rc; ++i) {
            for (int j = i + 1; j < cc; ++j) {
                if (this.unsafeGet(i, j) == this.unsafeGet(j, i)) continue;
                return false;
            }
        }
        return true;
    }

    public final boolean isHermitian() {
        return this.isSymmetric();
    }

    public boolean isUpperTriangular() {
        int rc = this.rowCount();
        int cc = this.columnCount();
        for (int j = 0; j < cc; ++j) {
            for (int i = j + 1; i < rc; ++i) {
                if (this.unsafeGet(i, j) == 0.0) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isLowerTriangular() {
        int rc = this.rowCount();
        int cc = this.columnCount();
        for (int i = 0; i < rc; ++i) {
            for (int j = i + 1; j < cc; ++j) {
                if (this.unsafeGet(i, j) == 0.0) continue;
                return false;
            }
        }
        return true;
    }

    public int upperBandwidthLimit() {
        return this.columnCount() - 1;
    }

    public int lowerBandwidthLimit() {
        return this.rowCount() - 1;
    }

    public int bandLength(int band) {
        return AMatrix.bandLength(this.rowCount(), this.columnCount(), band);
    }

    protected static final int bandLength(int rc, int cc, int band) {
        if (band > 0) {
            return band < cc ? Math.min(rc, cc - band) : 0;
        }
        return (band = -band) < rc ? Math.min(cc, rc - band) : 0;
    }

    public int bandIndex(int i, int j) {
        return j - i;
    }

    public int bandPosition(int i, int j) {
        return Math.min(i, j);
    }

    public int upperBandwidth() {
        for (int band = this.upperBandwidthLimit(); band > 0; --band) {
            int bandLen = this.bandLength(band);
            for (int i = 0; i < bandLen; ++i) {
                if (this.unsafeGet(band + i, i) == 0.0) continue;
                return band;
            }
        }
        return 0;
    }

    public int lowerBandwidth() {
        for (int band = this.lowerBandwidthLimit(); band > 0; --band) {
            int bandLen = this.bandLength(-band);
            for (int i = 0; i < bandLen; ++i) {
                if (this.unsafeGet(i, band + i) == 0.0) continue;
                return band;
            }
        }
        return 0;
    }

    public AVector getBand(int band) {
        return MatrixBandVector.create(this, band);
    }

    public AVector getBandWrapped(int band) {
        int cc;
        AVector result = Vector0.INSTANCE;
        int rc = this.rowCount();
        if (rc < (cc = this.columnCount())) {
            int si = band % rc;
            if (si > 0) {
                si -= rc;
            }
            while (si < cc) {
                result = ((AVector)result).join(this.getBand(si));
                si += rc;
            }
        } else {
            int si = band % cc;
            if (si < 0) {
                si += cc;
            }
            while (si > -rc) {
                result = ((AVector)result).join(this.getBand(si));
                si -= cc;
            }
        }
        return result;
    }

    public void setRow(int i, AVector row) {
        this.getRow(i).set(row);
    }

    public void setColumn(int i, AVector col) {
        this.getColumn(i).set(col);
    }

    @Override
    public abstract AMatrix exactClone();

    @Override
    public void validate() {
    }

    public void copyRowTo(int row, double[] dest, int destOffset) {
        int cc = this.columnCount();
        for (int i = 0; i < cc; ++i) {
            dest[i + destOffset] = this.unsafeGet(row, i);
        }
    }

    public void copyColumnTo(int col, double[] dest, int destOffset) {
        int rc = this.rowCount();
        for (int i = 0; i < rc; ++i) {
            dest[i + destOffset] = this.unsafeGet(i, col);
        }
    }
}

