/*
 * Decompiled with CFR 0.152.
 */
package mikera.indexz;

import java.util.Arrays;
import mikera.indexz.AIndex;
import mikera.vectorz.AVector;
import mikera.vectorz.util.IntArrays;

public final class Index
extends AIndex {
    private static final long serialVersionUID = 8698831088064498284L;
    public final int[] data;

    public Index(int length) {
        this.data = new int[length];
    }

    private Index(int[] indexes) {
        this.data = indexes;
    }

    @Override
    public void swap(int i, int j) {
        int t = this.data[i];
        this.data[i] = this.data[j];
        this.data[j] = t;
    }

    @Override
    public void reverse() {
        int len = this.length();
        int m = len / 2;
        for (int i = 0; i < m; ++i) {
            this.swap(i, len - 1 - i);
        }
    }

    @Override
    public boolean isDistinctSorted() {
        int len = this.length();
        for (int i = 1; i < len; ++i) {
            if (this.data[i - 1] < this.data[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isSorted() {
        int len = this.length();
        for (int i = 1; i < len; ++i) {
            if (this.data[i - 1] <= this.data[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isPermutation() {
        int i;
        int n = this.length();
        boolean[] chk = new boolean[n];
        for (i = 0; i < n; ++i) {
            int v = this.data[i];
            if (chk[v]) {
                return false;
            }
            chk[v] = true;
        }
        for (i = 0; i < n; ++i) {
            if (chk[i]) continue;
            return false;
        }
        return true;
    }

    public int swapCount() {
        int n = this.length();
        int swaps = 0;
        boolean[] seen = new boolean[n];
        for (int i = 0; i < n; ++i) {
            if (seen[i]) continue;
            seen[i] = true;
            int j = this.data[i];
            while (!seen[j]) {
                seen[j] = true;
                ++swaps;
                j = this.data[j];
            }
        }
        return swaps;
    }

    public boolean isOddPermutation() {
        return (this.swapCount() & 1) == 1;
    }

    public boolean isEvenPermutation() {
        return (this.swapCount() & 1) == 0;
    }

    public static Index wrap(int[] indexes) {
        return new Index(indexes);
    }

    public static Index of(int ... indexes) {
        return new Index((int[])indexes.clone());
    }

    public static Index createLength(int len) {
        return new Index(len);
    }

    public static Index create(AVector v) {
        int len = v.length();
        Index a = Index.createLength(len);
        for (int i = 0; i < len; ++i) {
            a.data[i] = (int)v.unsafeGet(i);
        }
        return a;
    }

    @Override
    public int get(int i) {
        return this.data[i];
    }

    public int unsafeGet(int i) {
        return this.data[i];
    }

    @Override
    public void set(int i, int value) {
        this.data[i] = value;
    }

    @Override
    public int length() {
        return this.data.length;
    }

    @Override
    public Index clone() {
        return new Index(IntArrays.copyOf(this.data));
    }

    public void permute(Index permutationIndex) {
        int len = this.length();
        assert (len == permutationIndex.length());
        int[] temp = (int[])this.data.clone();
        for (int i = 0; i < len; ++i) {
            this.data[i] = temp[permutationIndex.get(i)];
        }
    }

    @Override
    public void sort() {
        Arrays.sort(this.data);
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof Index) {
            return this.equals((Index)o);
        }
        return super.equals(o);
    }

    public boolean equals(Index o) {
        int len = this.length();
        if (len != o.length()) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (this.data[i] == o.data[i]) continue;
            return false;
        }
        return true;
    }

    public int[] getData() {
        return this.data;
    }

    @Override
    public int[] toArray() {
        return (int[])this.getData().clone();
    }

    @Override
    public boolean isFullyMutable() {
        return true;
    }

    public void lookupWith(Index source) {
        int len = this.length();
        for (int i = 0; i < len; ++i) {
            this.data[i] = source.data[this.data[i]];
        }
    }

    @Override
    public Index compose(AIndex a) {
        if (a instanceof Index) {
            return this.compose((Index)a);
        }
        return super.compose(a);
    }

    public Index compose(Index a) {
        int len = this.length();
        Index r = new Index(len);
        for (int i = 0; i < len; ++i) {
            r.data[i] = a.data[this.data[i]];
        }
        return r;
    }

    public int indexPosition(int i) {
        int min = 0;
        int max = this.data.length;
        while (min < max) {
            int mid = min + max >> 1;
            int mi = this.data[mid];
            if (i == mi) {
                return mid;
            }
            if (i < mi) {
                max = mid;
                continue;
            }
            min = mid + 1;
        }
        return -1;
    }

    public int seekPosition(int i) {
        int min = 0;
        int max = this.data.length;
        while (min < max) {
            int mid = min + max >> 1;
            int mi = this.data[mid];
            if (i == mi) {
                return mid;
            }
            if (i < mi) {
                max = mid;
                continue;
            }
            min = mid + 1;
        }
        return min;
    }

    public int find(int value) {
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i] != value) continue;
            return i;
        }
        return -1;
    }

    public Index invert() {
        int n = this.length();
        Index ni = new Index(n);
        for (int i = 0; i < n; ++i) {
            ni.set(this.get(i), i);
        }
        return ni;
    }

    public boolean allInRange(int start, int end) {
        for (int i = 0; i < this.data.length; ++i) {
            int a = this.data[i];
            if (a >= start && a < end) continue;
            return false;
        }
        return true;
    }
}

