/*
 * Decompiled with CFR 0.152.
 */
package mikera.matrixx.impl;

import mikera.arrayz.ISparse;
import mikera.matrixx.AMatrix;
import mikera.vectorz.AVector;
import mikera.vectorz.util.ErrorMessages;

public class QuadtreeMatrix
extends AMatrix
implements ISparse {
    private final AMatrix c00;
    private final AMatrix c01;
    private final AMatrix c10;
    private final AMatrix c11;
    private final int rowSplit;
    private final int columnSplit;
    private final int rows;
    private final int columns;

    private QuadtreeMatrix(AMatrix c00, AMatrix c01, AMatrix c10, AMatrix c11) {
        this.c00 = c00;
        this.c01 = c01;
        this.c10 = c10;
        this.c11 = c11;
        this.rowSplit = c00.rowCount();
        this.columnSplit = c00.columnCount();
        this.rows = this.rowSplit + c10.rowCount();
        this.columns = this.rowSplit + c01.columnCount();
    }

    public static QuadtreeMatrix create(AMatrix c00, AMatrix c01, AMatrix c10, AMatrix c11) {
        if (c00.rowCount() != c01.rowCount()) {
            throw new IllegalArgumentException("Mismtached submatrix size");
        }
        if (c10.rowCount() != c11.rowCount()) {
            throw new IllegalArgumentException("Mismtached submatrix size");
        }
        if (c00.columnCount() != c10.columnCount()) {
            throw new IllegalArgumentException("Mismtached submatrix size");
        }
        if (c01.columnCount() != c11.columnCount()) {
            throw new IllegalArgumentException("Mismtached submatrix size");
        }
        return new QuadtreeMatrix(c00, c01, c10, c11);
    }

    @Override
    public boolean isFullyMutable() {
        return this.c00.isFullyMutable() && this.c01.isFullyMutable() && this.c10.isFullyMutable() && this.c11.isFullyMutable();
    }

    @Override
    public int rowCount() {
        return this.rows;
    }

    @Override
    public int columnCount() {
        return this.columns;
    }

    @Override
    public double get(int row, int column) {
        if (row < 0 || row >= this.rows || column < 0 || column >= this.columns) {
            throw new IndexOutOfBoundsException(ErrorMessages.invalidIndex(this, row, column));
        }
        return this.unsafeGet(row, column);
    }

    @Override
    public void set(int row, int column, double value) {
        if (row < 0 || row >= this.rows || column < 0 || column >= this.columns) {
            throw new IndexOutOfBoundsException(ErrorMessages.invalidIndex(this, row, column));
        }
        this.unsafeSet(row, column, value);
    }

    @Override
    public double unsafeGet(int row, int column) {
        if (row < this.rowSplit) {
            if (column < this.columnSplit) {
                return this.c00.unsafeGet(row, column);
            }
            return this.c01.unsafeGet(row, column - this.columnSplit);
        }
        if (column < this.columnSplit) {
            return this.c10.unsafeGet(row - this.rowSplit, column);
        }
        return this.c11.unsafeGet(row - this.rowSplit, column - this.columnSplit);
    }

    @Override
    public void unsafeSet(int row, int column, double value) {
        if (row < this.rowSplit) {
            if (column < this.columnSplit) {
                this.c00.unsafeSet(row, column, value);
            } else {
                this.c01.unsafeSet(row, column - this.columnSplit, value);
            }
        } else if (column < this.columnSplit) {
            this.c10.unsafeSet(row - this.rowSplit, column, value);
        } else {
            this.c11.unsafeSet(row - this.rowSplit, column - this.columnSplit, value);
        }
    }

    @Override
    public void addAt(int row, int column, double value) {
        if (row < this.rowSplit) {
            if (column < this.columnSplit) {
                this.c00.addAt(row, column, value);
            } else {
                this.c01.addAt(row, column - this.columnSplit, value);
            }
        } else if (column < this.columnSplit) {
            this.c10.addAt(row - this.rowSplit, column, value);
        } else {
            this.c11.addAt(row - this.rowSplit, column - this.columnSplit, value);
        }
    }

    @Override
    public long nonZeroCount() {
        return this.c00.nonZeroCount() + this.c01.nonZeroCount() + this.c10.nonZeroCount() + this.c11.nonZeroCount();
    }

    @Override
    public double elementSum() {
        return this.c00.elementSum() + this.c01.elementSum() + this.c10.elementSum() + this.c11.elementSum();
    }

    @Override
    public void fill(double v) {
        this.c00.fill(v);
        this.c01.fill(v);
        this.c10.fill(v);
        this.c11.fill(v);
    }

    @Override
    public void add(double v) {
        this.c00.add(v);
        this.c01.add(v);
        this.c10.add(v);
        this.c11.add(v);
    }

    @Override
    public AVector getRow(int row) {
        if (row < this.rowSplit) {
            return this.c00.getRow(row).join(this.c01.getRow(row));
        }
        return this.c10.getRow(row -= this.rowSplit).join(this.c11.getRow(row));
    }

    @Override
    public AVector getColumn(int col) {
        if (col < this.columnSplit) {
            return this.c00.getColumn(col).join(this.c10.getColumn(col));
        }
        return this.c01.getColumn(col -= this.columnSplit).join(this.c11.getColumn(col));
    }

    @Override
    public AMatrix exactClone() {
        return new QuadtreeMatrix(this.c00.exactClone(), this.c01.exactClone(), this.c10.exactClone(), this.c11.exactClone());
    }

    @Override
    public double density() {
        return (double)this.nonZeroCount() / (double)((long)this.rows * (long)this.columns);
    }
}

