/*
 * Decompiled with CFR 0.152.
 */
package mikera.vectorz;

import java.io.Serializable;
import java.nio.DoubleBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import mikera.arrayz.Arrayz;
import mikera.arrayz.INDArray;
import mikera.arrayz.SliceArray;
import mikera.arrayz.impl.AbstractArray;
import mikera.indexz.Index;
import mikera.matrixx.AMatrix;
import mikera.matrixx.Matrix;
import mikera.matrixx.Matrixx;
import mikera.matrixx.impl.BroadcastVectorMatrix;
import mikera.randomz.Hash;
import mikera.vectorz.AScalar;
import mikera.vectorz.IOp;
import mikera.vectorz.IVector;
import mikera.vectorz.Op;
import mikera.vectorz.Scalar;
import mikera.vectorz.Tools;
import mikera.vectorz.Vector;
import mikera.vectorz.Vectorz;
import mikera.vectorz.impl.AArrayVector;
import mikera.vectorz.impl.JoinedVector;
import mikera.vectorz.impl.ListWrapper;
import mikera.vectorz.impl.VectorIndexScalar;
import mikera.vectorz.impl.VectorIterator;
import mikera.vectorz.impl.WrappedSubVector;
import mikera.vectorz.ops.Logistic;
import mikera.vectorz.util.ErrorMessages;
import mikera.vectorz.util.VectorzException;

public abstract class AVector
extends AbstractArray<Double>
implements IVector,
Comparable<AVector>,
Serializable {
    @Override
    public abstract int length();

    @Override
    public abstract double get(int var1);

    @Override
    public abstract void set(int var1, double var2);

    @Override
    public void set(int[] indexes, double value) {
        if (indexes.length == 1) {
            this.set(indexes[0], value);
        }
        if (indexes.length != 0) {
            throw new UnsupportedOperationException("" + indexes.length + "D set not supported on AVector");
        }
        this.fill(value);
    }

    public void unsafeSet(int i, double value) {
        this.set(i, value);
    }

    public double unsafeGet(int i) {
        return this.get(i);
    }

    @Override
    public final int dimensionality() {
        return 1;
    }

    @Override
    public double get(int ... indexes) {
        assert (indexes.length == 1);
        return this.get(indexes[0]);
    }

    @Override
    public double get() {
        throw new UnsupportedOperationException("Can't do 0-d get on a vector!");
    }

    @Override
    public AScalar slice(int position) {
        return new VectorIndexScalar(this, position);
    }

    @Override
    public AScalar slice(int dimension, int index) {
        if (dimension != 0) {
            throw new IllegalArgumentException("Dimension out of range!");
        }
        return this.slice(index);
    }

    @Override
    public int sliceCount() {
        return this.length();
    }

    @Override
    public List<Double> getSlices() {
        ArrayList<Double> al = new ArrayList<Double>();
        int l = this.length();
        for (int i = 0; i < l; ++i) {
            al.add(this.get(i));
        }
        return al;
    }

    @Override
    public int[] getShape() {
        return new int[]{this.length()};
    }

    @Override
    public int getShape(int dim) {
        if (dim == 0) {
            return this.length();
        }
        throw new IndexOutOfBoundsException("Vector does not have dimension: " + dim);
    }

    @Override
    public long[] getLongShape() {
        return new long[]{this.length()};
    }

    @Override
    public final long elementCount() {
        return this.length();
    }

    @Override
    public long nonZeroCount() {
        int n = this.length();
        long result = 0L;
        for (int i = 0; i < n; ++i) {
            if (this.unsafeGet(i) == 0.0) continue;
            ++result;
        }
        return result;
    }

    public AVector subVector(int offset, int length) {
        return new WrappedSubVector(this, offset, length);
    }

    public AVector join(AVector second) {
        return JoinedVector.joinVectors(this, second);
    }

    @Override
    public int compareTo(AVector a) {
        int len = this.length();
        if (len != a.length()) {
            throw new IllegalArgumentException("Vectors must be same length for comparison");
        }
        for (int i = 0; i < len; ++i) {
            double diff = this.get(i) - a.get(i);
            if (diff < 0.0) {
                return -1;
            }
            if (!(diff > 0.0)) continue;
            return 1;
        }
        return 0;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof AVector) {
            return this.equals((AVector)o);
        }
        if (o instanceof INDArray) {
            return this.equals((INDArray)o);
        }
        return false;
    }

    public boolean equals(AVector v) {
        if (this == v) {
            return true;
        }
        int len = this.length();
        if (len != v.length()) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (this.unsafeGet(i) == v.unsafeGet(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(INDArray v) {
        if (v instanceof AVector) {
            return this.equals((AVector)v);
        }
        if (v.dimensionality() != 1) {
            return false;
        }
        int len = this.length();
        if (len != v.getShape()[0]) {
            return false;
        }
        int[] ind = new int[1];
        for (int i = 0; i < len; ++i) {
            ind[0] = i;
            if (this.unsafeGet(i) == v.get(ind)) continue;
            return false;
        }
        return true;
    }

    public List<Double> toList() {
        ArrayList<Double> al = new ArrayList<Double>();
        int len = this.length();
        for (int i = 0; i < len; ++i) {
            al.add(this.unsafeGet(i));
        }
        return al;
    }

    @Override
    public boolean epsilonEquals(INDArray a, double tolerance) {
        if (a instanceof AVector) {
            return this.epsilonEquals((AVector)a);
        }
        if (a.dimensionality() != 1) {
            throw new IllegalArgumentException(ErrorMessages.incompatibleShapes(this, a));
        }
        int len = this.length();
        if (len != a.getShape(0)) {
            throw new IllegalArgumentException(ErrorMessages.incompatibleShapes(this, a));
        }
        for (int i = 0; i < len; ++i) {
            if (Tools.epsilonEquals(this.unsafeGet(i), a.get(i), tolerance)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean epsilonEquals(INDArray a) {
        return this.epsilonEquals(a, 1.0E-7);
    }

    public boolean epsilonEquals(AVector v) {
        return this.epsilonEquals(v, 1.0E-7);
    }

    public boolean epsilonEquals(AVector v, double tolerance) {
        if (this == v) {
            return true;
        }
        int len = this.length();
        if (len != v.length()) {
            throw new IllegalArgumentException(ErrorMessages.incompatibleShapes(this, v));
        }
        for (int i = 0; i < len; ++i) {
            if (Tools.epsilonEquals(this.unsafeGet(i), v.unsafeGet(i), tolerance)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        int len = this.length();
        for (int i = 0; i < len; ++i) {
            hashCode = 31 * hashCode + Hash.hashCode((double)this.unsafeGet(i));
        }
        return hashCode;
    }

    @Override
    public void copyTo(double[] arr) {
        this.copyTo(arr, 0);
    }

    public void copyTo(double[] data, int offset) {
        this.copyTo(0, data, offset, this.length());
    }

    public void copyTo(int offset, double[] dest, int destOffset, int length) {
        for (int i = 0; i < length; ++i) {
            dest[i + destOffset] = this.get(i + offset);
        }
    }

    @Override
    public double[] toDoubleArray() {
        double[] result = new double[this.length()];
        this.copyTo(result, 0);
        return result;
    }

    @Override
    public double[] asDoubleArray() {
        return null;
    }

    @Override
    public void toDoubleBuffer(DoubleBuffer dest) {
        int len = this.length();
        for (int i = 0; i < len; ++i) {
            dest.put(this.unsafeGet(i));
        }
    }

    public void copyTo(AVector dest, int destOffset) {
        if (dest instanceof AArrayVector) {
            this.copyTo((AArrayVector)dest, destOffset);
            return;
        }
        int len = this.length();
        if (destOffset + len > dest.length()) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < len; ++i) {
            dest.unsafeSet(destOffset + i, this.unsafeGet(i));
        }
    }

    public void copyTo(AArrayVector dest, int destOffset) {
        this.copyTo(dest.getArray(), dest.getArrayOffset() + destOffset);
    }

    public void copyTo(int offset, AVector dest, int destOffset, int length) {
        for (int i = 0; i < length; ++i) {
            dest.set(destOffset + i, this.get(offset + i));
        }
    }

    @Override
    public void fill(double value) {
        this.fillRange(0, this.length(), value);
    }

    public void fillRange(int offset, int length, double value) {
        if (offset < 0 || offset + length > this.length()) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < length; ++i) {
            this.unsafeSet(i + offset, value);
        }
    }

    @Override
    public void clamp(double min, double max) {
        int len = this.length();
        for (int i = 0; i < len; ++i) {
            double v = this.unsafeGet(i);
            if (v < min) {
                this.unsafeSet(i, min);
                continue;
            }
            if (!(v > max)) continue;
            this.unsafeSet(i, max);
        }
    }

    public void clampMax(double max) {
        int len = this.length();
        for (int i = 0; i < len; ++i) {
            double v = this.unsafeGet(i);
            if (!(v > max)) continue;
            this.unsafeSet(i, max);
        }
    }

    public void clampMin(double min) {
        int len = this.length();
        for (int i = 0; i < len; ++i) {
            double v = this.unsafeGet(i);
            if (!(v < min)) continue;
            this.unsafeSet(i, min);
        }
    }

    @Override
    public void multiply(double factor) {
        int len = this.length();
        for (int i = 0; i < len; ++i) {
            this.unsafeSet(i, this.unsafeGet(i) * factor);
        }
    }

    @Override
    public void multiply(INDArray a) {
        if (a instanceof AVector) {
            this.multiply((AVector)a);
        } else if (a instanceof AScalar) {
            this.multiply(((AScalar)a).get());
        } else {
            int dims = a.dimensionality();
            switch (dims) {
                case 0: {
                    this.multiply(a.get());
                    return;
                }
                case 1: {
                    this.multiply(a.asVector());
                    return;
                }
            }
            throw new VectorzException("Can't multiply vector with array of dimensionality: " + dims);
        }
    }

    public void multiply(AVector v) {
        int len = this.length();
        if (len != v.length()) {
            throw new IllegalArgumentException("Wrong vector sizes");
        }
        for (int i = 0; i < len; ++i) {
            this.unsafeSet(i, this.unsafeGet(i) * v.unsafeGet(i));
        }
    }

    public void multiply(double[] data, int offset) {
        int len = this.length();
        for (int i = 0; i < len; ++i) {
            this.set(i, this.get(i) * data[i + offset]);
        }
    }

    public void multiplyTo(double[] data, int offset) {
        int len = this.length();
        for (int i = 0; i < len; ++i) {
            int n = i + offset;
            data[n] = data[n] * this.get(i);
        }
    }

    @Override
    public void divide(double factor) {
        this.multiply(1.0 / factor);
    }

    @Override
    public void divide(INDArray a) {
        if (a instanceof AVector) {
            this.divide((AVector)a);
        } else {
            super.divide(a);
        }
    }

    public void divide(AVector v) {
        int len = this.length();
        assert (len == v.length());
        for (int i = 0; i < len; ++i) {
            this.set(i, this.get(i) / v.get(i));
        }
    }

    public void divide(double[] data, int offset) {
        int len = this.length();
        for (int i = 0; i < len; ++i) {
            this.unsafeSet(i, this.unsafeGet(i) / data[i + offset]);
        }
    }

    public void divideTo(double[] data, int offset) {
        int len = this.length();
        for (int i = 0; i < len; ++i) {
            int n = i + offset;
            data[n] = data[n] / this.unsafeGet(i);
        }
    }

    @Override
    public void abs() {
        int len = this.length();
        for (int i = 0; i < len; ++i) {
            double val = this.unsafeGet(i);
            if (!(val < 0.0)) continue;
            this.unsafeSet(i, -val);
        }
    }

    @Override
    public void log() {
        int len = this.length();
        for (int i = 0; i < len; ++i) {
            double val = this.unsafeGet(i);
            this.unsafeSet(i, Math.log(val));
        }
    }

    @Override
    public void signum() {
        int len = this.length();
        for (int i = 0; i < len; ++i) {
            this.unsafeSet(i, Math.signum(this.unsafeGet(i)));
        }
    }

    @Override
    public void square() {
        int len = this.length();
        for (int i = 0; i < len; ++i) {
            double x = this.unsafeGet(i);
            this.unsafeSet(i, x * x);
        }
    }

    public void tanh() {
        int len = this.length();
        for (int i = 0; i < len; ++i) {
            double x = this.unsafeGet(i);
            this.unsafeSet(i, Math.tanh(x));
        }
    }

    public void logistic() {
        int len = this.length();
        for (int i = 0; i < len; ++i) {
            double x = this.unsafeGet(i);
            this.unsafeSet(i, Logistic.logisticFunction(x));
        }
    }

    public final void scale(AVector v) {
        this.multiply(v);
    }

    public double scaleToMagnitude(double targetMagnitude) {
        double oldMagnitude = this.magnitude();
        this.multiply(targetMagnitude / oldMagnitude);
        return oldMagnitude;
    }

    public void scaleAdd(double factor, AVector v) {
        this.multiply(factor);
        this.add(v);
    }

    public void interpolate(AVector v, double alpha) {
        this.multiply(1.0 - alpha);
        this.addMultiple(v, alpha);
    }

    public void interpolate(AVector a, AVector b, double alpha) {
        this.set(a);
        this.interpolate(b, alpha);
    }

    public double magnitudeSquared() {
        int len = this.length();
        double total = 0.0;
        for (int i = 0; i < len; ++i) {
            double x = this.unsafeGet(i);
            total += x * x;
        }
        return total;
    }

    @Override
    public AVector getTranspose() {
        return this;
    }

    @Override
    public Vector getTransposeCopy() {
        return Vector.create(this);
    }

    @Override
    public final AVector getTransposeView() {
        return this;
    }

    public AMatrix outerProduct(AVector a) {
        int rc = this.length();
        int cc = a.length();
        Matrix m = Matrix.create(rc, cc);
        int di = 0;
        for (int i = 0; i < rc; ++i) {
            for (int j = 0; j < cc; ++j) {
                m.data[di++] = this.unsafeGet(i) * a.unsafeGet(j);
            }
        }
        return m;
    }

    @Override
    public INDArray outerProduct(INDArray a) {
        if (a instanceof AVector) {
            return this.outerProduct((AVector)a);
        }
        return super.outerProduct(a);
    }

    public Scalar innerProduct(AVector v) {
        return Scalar.create(this.dotProduct(v));
    }

    public Scalar innerProduct(Vector v) {
        int vl = v.data.length;
        if (this.length() != vl) {
            throw new IllegalArgumentException(ErrorMessages.incompatibleShapes(this, v));
        }
        return Scalar.create(this.dotProduct(v.data, 0));
    }

    public AVector innerProduct(AMatrix m) {
        int cc = m.columnCount();
        int rc = m.rowCount();
        if (rc != this.length()) {
            throw new VectorzException("Incompatible sizes for inner product: [" + this.length() + "] x [" + rc + "," + cc + "]");
        }
        Vector r = Vector.createLength(cc);
        for (int i = 0; i < cc; ++i) {
            double y = 0.0;
            for (int j = 0; j < rc; ++j) {
                y += this.unsafeGet(j) * m.unsafeGet(j, i);
            }
            r.unsafeSet(i, y);
        }
        return r;
    }

    public AVector innerProduct(AScalar s) {
        Vector v = this.toVector();
        v.scale(s.get());
        return v;
    }

    @Override
    public INDArray innerProduct(INDArray a) {
        if (a instanceof AVector) {
            return Scalar.create(this.dotProduct((AVector)a));
        }
        if (a instanceof AScalar) {
            return this.innerProduct((AScalar)a);
        }
        if (a instanceof AMatrix) {
            return this.innerProduct((AMatrix)a);
        }
        return super.innerProduct(a);
    }

    public double dotProduct(AVector v) {
        if (v instanceof Vector) {
            return this.dotProduct((Vector)v);
        }
        int len = this.length();
        if (v.length() != len) {
            throw new IllegalArgumentException("Vector size mismatch");
        }
        double total = 0.0;
        for (int i = 0; i < len; ++i) {
            total += this.unsafeGet(i) * v.unsafeGet(i);
        }
        return total;
    }

    public double dotProduct(Vector v) {
        if (v.length() != this.length()) {
            throw new IllegalArgumentException("Vector size mismatch");
        }
        return this.dotProduct(v.data, 0);
    }

    public double dotProduct(AVector v, Index ix) {
        int vl = v.length();
        if (v.length() != ix.length()) {
            throw new IllegalArgumentException("Mismtached source vector and index sizes");
        }
        double result = 0.0;
        for (int i = 0; i < vl; ++i) {
            result += this.unsafeGet(ix.get(i)) * v.unsafeGet(i);
        }
        return result;
    }

    public double dotProduct(double[] data, int offset) {
        int len = this.length();
        double result = 0.0;
        for (int i = 0; i < len; ++i) {
            result += this.unsafeGet(i) * data[offset + i];
        }
        return result;
    }

    public void crossProduct(AVector a) {
        if (this.length() != 3 || a.length() != 3) {
            throw new IllegalArgumentException("Cross product requires length 3 vectors");
        }
        double x = this.unsafeGet(0);
        double y = this.unsafeGet(1);
        double z = this.unsafeGet(2);
        double x2 = a.unsafeGet(0);
        double y2 = a.unsafeGet(1);
        double z2 = a.unsafeGet(2);
        double tx = y * z2 - z * y2;
        double ty = z * x2 - x * z2;
        double tz = x * y2 - y * x2;
        this.set(0, tx);
        this.set(1, ty);
        this.set(2, tz);
    }

    public double magnitude() {
        return Math.sqrt(this.magnitudeSquared());
    }

    public double distanceSquared(AVector v) {
        int len = this.length();
        double total = 0.0;
        for (int i = 0; i < len; ++i) {
            double d = this.unsafeGet(i) - v.unsafeGet(i);
            total += d * d;
        }
        return total;
    }

    public double distance(AVector v) {
        return Math.sqrt(this.distanceSquared(v));
    }

    public double distanceL1(AVector v) {
        int len = this.length();
        double total = 0.0;
        for (int i = 0; i < len; ++i) {
            double d = this.unsafeGet(i) - v.unsafeGet(i);
            total += Math.abs(d);
        }
        return total;
    }

    public double distanceLinf(AVector v) {
        int len = this.length();
        double result = 0.0;
        for (int i = 0; i < len; ++i) {
            double d = Math.abs(this.unsafeGet(i) - v.unsafeGet(i));
            result = Math.max(result, d);
        }
        return result;
    }

    public double maxAbsElement() {
        int len = this.length();
        double result = 0.0;
        for (int i = 0; i < len; ++i) {
            double comp = this.unsafeGet(i);
            if (comp > result) {
                result = comp;
                continue;
            }
            if (!(-comp > result)) continue;
            result = -comp;
        }
        return result;
    }

    public double normaliseMaxAbsElement() {
        double scale = this.maxAbsElement();
        this.scale(1.0 / scale);
        return scale;
    }

    @Override
    public double elementSum() {
        int len = this.length();
        double result = 0.0;
        for (int i = 0; i < len; ++i) {
            result += this.unsafeGet(i);
        }
        return result;
    }

    @Override
    public final double elementSquaredSum() {
        return this.magnitudeSquared();
    }

    public double angle(AVector v) {
        return Math.acos(this.dotProduct(v) / (v.magnitude() * this.magnitude()));
    }

    public double normalise() {
        double d = this.magnitude();
        if (d > 0.0) {
            this.multiply(1.0 / d);
        }
        return d;
    }

    @Override
    public void negate() {
        this.multiply(-1.0);
    }

    @Override
    public void pow(double exponent) {
        int len = this.length();
        for (int i = 0; i < len; ++i) {
            this.unsafeSet(i, Math.pow(this.unsafeGet(i), exponent));
        }
    }

    public void set(AVector src) {
        int len = this.length();
        if (src.length() != len) {
            throw new IllegalArgumentException("Source Vector of wrong size: " + src.length());
        }
        for (int i = 0; i < len; ++i) {
            this.unsafeSet(i, src.unsafeGet(i));
        }
    }

    @Override
    public final void set(double a) {
        throw new UnsupportedOperationException("0d set not supported for vectors - use fill instead?");
    }

    @Deprecated
    public void set(double[] data) {
        this.setElements(data, 0, this.length());
    }

    @Override
    public void setElements(double[] data) {
        this.setElements(data, 0, this.length());
    }

    @Override
    public void set(INDArray a) {
        if (a instanceof AVector) {
            this.set((AVector)a);
            return;
        }
        if (a.dimensionality() == 1) {
            int len = this.length();
            for (int i = 0; i < len; ++i) {
                this.unsafeSet(i, a.get(i));
            }
        } else {
            throw new IllegalArgumentException("Cannot set vector using array of dimensonality: " + a.dimensionality());
        }
    }

    @Override
    public void setElements(double[] values, int offset, int length) {
        if (length != this.length()) {
            throw new IllegalArgumentException("Incorrect length: " + length);
        }
        for (int i = 0; i < length; ++i) {
            this.unsafeSet(i, values[offset + i]);
        }
    }

    @Override
    public void getElements(double[] dest, int offset) {
        this.copyTo(dest, offset);
    }

    public void set(AVector src, int srcOffset) {
        int len = this.length();
        if (srcOffset < 0 || len + srcOffset > src.length()) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < len; ++i) {
            this.unsafeSet(i, src.unsafeGet(srcOffset + i));
        }
    }

    public void setValues(double ... values) {
        int len = this.length();
        if (values.length != len) {
            throw new VectorzException("Trying to set vectors with incorrect number of doubles: " + values.length);
        }
        for (int i = 0; i < len; ++i) {
            this.unsafeSet(i, values[i]);
        }
    }

    public long zeroCount() {
        return this.elementCount() - this.nonZeroCount();
    }

    @Override
    public AVector clone() {
        return Vectorz.create(this);
    }

    @Override
    public final AVector asVector() {
        return this;
    }

    @Override
    public INDArray reshape(int ... dimensions) {
        int ndims = dimensions.length;
        if (ndims == 1) {
            return Vector.createFromVector(this, dimensions[0]);
        }
        if (ndims == 2) {
            return Matrixx.createFromVector(this, dimensions[0], dimensions[1]);
        }
        return Arrayz.createFromVector(this, dimensions);
    }

    @Override
    public boolean isView() {
        return true;
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    @Override
    public boolean isElementConstrained() {
        return false;
    }

    @Override
    public boolean isFullyMutable() {
        return this.isMutable();
    }

    public void add(AVector v) {
        int length;
        int vlength = v.length();
        if (vlength != (length = this.length())) {
            throw new IllegalArgumentException("Source vector has different size: " + vlength);
        }
        for (int i = 0; i < length; ++i) {
            this.addAt(i, v.unsafeGet(i));
        }
    }

    @Override
    public void add(INDArray a) {
        if (a instanceof AVector) {
            this.add((AVector)a);
        } else if (a instanceof AScalar) {
            this.add(a.get());
        } else {
            super.add(a);
        }
    }

    @Override
    public void sub(INDArray a) {
        if (a instanceof AVector) {
            this.sub((AVector)a);
        } else if (a instanceof AScalar) {
            this.sub(a.get());
        } else {
            super.sub(a);
        }
    }

    public void add(AVector src, int srcOffset) {
        int length = this.length();
        if (srcOffset < 0 || srcOffset + length > src.length()) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < length; ++i) {
            this.addAt(i, src.get(srcOffset + i));
        }
    }

    public void add(int offset, AVector a) {
        this.add(offset, a, 0, a.length());
    }

    public void add(int offset, AVector a, int aOffset, int length) {
        for (int i = 0; i < length; ++i) {
            this.addAt(offset + i, a.get(i + aOffset));
        }
    }

    public void addProduct(AVector a, AVector b) {
        this.addProduct(a, b, 1.0);
    }

    public void addProduct(AVector a, AVector b, double factor) {
        int length = this.length();
        if (a.length() != length || b.length() != length) {
            throw new IllegalArgumentException("Unequal vector sizes for addProduct");
        }
        for (int i = 0; i < length; ++i) {
            this.addAt(i, a.unsafeGet(i) * b.unsafeGet(i) * factor);
        }
    }

    public void addMultiple(AVector src, double factor) {
        if (src.length() != this.length()) {
            throw new RuntimeException("Source vector has different size!" + src.length());
        }
        this.addMultiple(src, 0, factor);
    }

    public void addMultiple(AVector src, int srcOffset, double factor) {
        this.addMultiple(0, src, srcOffset, this.length(), factor);
    }

    public void addMultiple(int offset, AVector src, int srcOffset, int length, double factor) {
        if (offset + length > this.length()) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < length; ++i) {
            this.addAt(i + offset, src.get(i + srcOffset) * factor);
        }
    }

    public void addMultiple(int offset, AVector v, double factor) {
        this.addMultiple(offset, v, 0, v.length(), factor);
    }

    public void addWeighted(AVector v, double factor) {
        this.multiply(1.0 - factor);
        this.addMultiple(v, factor);
    }

    public void sub(AVector v) {
        this.addMultiple(v, -1.0);
    }

    @Override
    public void sub(double d) {
        this.add(-d);
    }

    @Override
    public boolean isZero() {
        int len = this.length();
        for (int i = 0; i < len; ++i) {
            if (this.unsafeGet(i) == 0.0) continue;
            return false;
        }
        return true;
    }

    public boolean isUnitLengthVector() {
        double mag = this.magnitudeSquared();
        return Math.abs(mag - 1.0) < 1.0E-7;
    }

    public void projectToPlane(AVector normal, double distance) {
        assert (Tools.epsilonEquals(normal.magnitude(), 1.0));
        double d = this.dotProduct(normal);
        this.addMultiple(normal, distance - d);
    }

    public void subMultiple(AVector v, double factor) {
        this.addMultiple(v, -factor);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        int length = this.length();
        sb.append('[');
        if (length > 0) {
            sb.append(this.unsafeGet(0));
            for (int i = 1; i < length; ++i) {
                sb.append(',');
                sb.append(this.unsafeGet(i));
            }
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    public Vector toVector() {
        return Vector.create(this);
    }

    @Override
    public List<Double> asElementList() {
        return new ListWrapper(this);
    }

    @Override
    public Iterator<Double> iterator() {
        return new VectorIterator(this);
    }

    @Override
    public Iterator<Double> elementIterator() {
        return this.iterator();
    }

    public void set(IVector vector) {
        int len = this.length();
        assert (len == vector.length());
        for (int i = 0; i < len; ++i) {
            this.unsafeSet(i, vector.get(i));
        }
    }

    public void addMultiple(Vector source, Index sourceToDest, double factor) {
        if (sourceToDest.length() != source.length()) {
            throw new VectorzException("Index must match source vector");
        }
        int len = source.length();
        assert (len == sourceToDest.length());
        for (int i = 0; i < len; ++i) {
            int j = sourceToDest.data[i];
            this.addAt(j, source.data[i] * factor);
        }
    }

    public void addMultiple(AVector source, Index sourceToDest, double factor) {
        if (sourceToDest.length() != source.length()) {
            throw new VectorzException("Index must match source vector");
        }
        int len = source.length();
        assert (len == sourceToDest.length());
        for (int i = 0; i < len; ++i) {
            int j = sourceToDest.data[i];
            this.addAt(j, source.unsafeGet(i) * factor);
        }
    }

    public void addMultiple(Index destToSource, Vector source, double factor) {
        if (destToSource.length() != this.length()) {
            throw new VectorzException("Index must match this vector");
        }
        int len = this.length();
        assert (len == destToSource.length());
        for (int i = 0; i < len; ++i) {
            int j = destToSource.data[i];
            this.addAt(i, source.data[j] * factor);
        }
    }

    public void addMultiple(Index destToSource, AVector source, double factor) {
        int len = this.length();
        if (destToSource.length() != len) {
            throw new VectorzException("Index must match this vector");
        }
        for (int i = 0; i < len; ++i) {
            int j = destToSource.data[i];
            this.addAt(i, source.get(j) * factor);
        }
    }

    public void set(AVector v, Index indexes) {
        int len = this.length();
        assert (indexes.length() == len);
        for (int i = 0; i < len; ++i) {
            this.unsafeSet(i, v.get(indexes.get(i)));
        }
    }

    public void addToArray(double[] array, int offset) {
        this.addToArray(0, array, offset, this.length());
    }

    public void addToArray(int offset, double[] array, int arrayOffset, int length) {
        if (offset < 0 || offset + length > this.length()) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < length; ++i) {
            int n = i + arrayOffset;
            array[n] = array[n] + this.unsafeGet(i + offset);
        }
    }

    public void addMultipleToArray(double factor, int offset, double[] array, int arrayOffset, int length) {
        if (offset < 0 || offset + length > this.length()) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < length; ++i) {
            int n = i + arrayOffset;
            array[n] = array[n] + factor * this.unsafeGet(i + offset);
        }
    }

    public void addProductToArray(double factor, int offset, AVector other, int otherOffset, double[] array, int arrayOffset, int length) {
        if (other instanceof AArrayVector) {
            this.addProductToArray(factor, offset, (AArrayVector)other, otherOffset, array, arrayOffset, length);
            return;
        }
        if (offset < 0 || offset + length > this.length()) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < length; ++i) {
            int n = i + arrayOffset;
            array[n] = array[n] + factor * this.unsafeGet(i + offset) * other.get(i + otherOffset);
        }
    }

    public void addProductToArray(double factor, int offset, AArrayVector other, int otherOffset, double[] array, int arrayOffset, int length) {
        if (offset < 0 || offset + length > this.length()) {
            throw new IndexOutOfBoundsException();
        }
        double[] otherArray = other.getArray();
        otherOffset += other.getArrayOffset();
        for (int i = 0; i < length; ++i) {
            int n = i + arrayOffset;
            array[n] = array[n] + factor * this.unsafeGet(i + offset) * otherArray[i + otherOffset];
        }
    }

    public void addProduct(AVector a, int aOffset, AVector b, int bOffset, double factor) {
        int length = this.length();
        if (aOffset < 0 || aOffset + length > a.length()) {
            throw new IndexOutOfBoundsException();
        }
        if (bOffset < 0 || bOffset + length > b.length()) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < length; ++i) {
            this.addAt(i, a.unsafeGet(i + aOffset) * b.unsafeGet(i + bOffset) * factor);
        }
    }

    @Override
    public void applyOp(IOp op) {
        if (op instanceof Op) {
            this.applyOp((Op)op);
        }
        int len = this.length();
        for (int i = 0; i < len; ++i) {
            this.unsafeSet(i, op.apply(this.unsafeGet(i)));
        }
    }

    @Override
    public void applyOp(Op op) {
        int len = this.length();
        for (int i = 0; i < len; ++i) {
            this.unsafeSet(i, op.apply(this.unsafeGet(i)));
        }
    }

    public void addAt(int i, double v) {
        this.unsafeSet(i, this.unsafeGet(i) + v);
    }

    @Override
    public void scaleAdd(double factor, double constant) {
        this.scale(factor);
        this.add(constant);
    }

    @Override
    public void add(double constant) {
        int len = this.length();
        for (int i = 0; i < len; ++i) {
            this.addAt(i, constant);
        }
    }

    @Override
    public abstract AVector exactClone();

    public boolean equalsArray(double[] data) {
        int len = this.length();
        if (len != data.length) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (this.unsafeGet(i) == data[i]) continue;
            return false;
        }
        return true;
    }

    public void setRange(int offset, double[] data, int dataOffset, int length) {
        if (offset < 0 || offset + length > this.length()) {
            throw new IndexOutOfBoundsException("Offset: " + offset + " , Length: " + length + " on vector with total length " + this.length());
        }
        for (int i = 0; i < length; ++i) {
            this.unsafeSet(offset + i, data[dataOffset + i]);
        }
    }

    @Override
    public INDArray broadcast(int ... targetShape) {
        int tdims = targetShape.length;
        int len = this.length();
        if (tdims < 1) {
            throw new IllegalArgumentException("Can't broadcast to a smaller shape!");
        }
        if (tdims == 1) {
            if (targetShape[0] != len) {
                throw new IllegalArgumentException("Can't broadcast to different length: " + targetShape[0]);
            }
            return this;
        }
        if (tdims == 2) {
            int n = targetShape[0];
            if (len != targetShape[1]) {
                throw new IllegalArgumentException("Can't broadcast to matrix with different length rows");
            }
            AVector[] vs = new AVector[n];
            for (int i = 0; i < n; ++i) {
                vs[i] = this;
            }
            return Matrixx.createFromVectors(vs);
        }
        int n = targetShape[0];
        if (len != targetShape[tdims - 1]) {
            throw new IllegalArgumentException("Can't broadcast to matrix with different length rows");
        }
        INDArray s = this.broadcast(Arrays.copyOfRange(targetShape, 1, tdims));
        return SliceArray.repeat(s, n);
    }

    @Override
    public INDArray broadcastLike(INDArray target) {
        if (target instanceof AMatrix) {
            return this.broadcastLike((AMatrix)target);
        }
        return this.broadcast(target.getShape());
    }

    public INDArray broadcastLike(AMatrix target) {
        if (this.length() == target.columnCount()) {
            return BroadcastVectorMatrix.wrap(this, target.rowCount());
        }
        throw new IllegalArgumentException(ErrorMessages.incompatibleShapes(this, target));
    }

    @Override
    public void validate() {
        super.validate();
    }
}

