/*
 * Decompiled with CFR 0.152.
 */
package mikera.vectorz;

import java.util.Arrays;
import mikera.indexz.Index;
import mikera.vectorz.AVector;
import mikera.vectorz.ArrayVector;

public final class Vector
extends ArrayVector {
    private static final long serialVersionUID = 6283741614665875877L;
    public final double[] data;

    Vector(double ... values) {
        this.data = values;
    }

    Vector(int length) {
        this.data = new double[length];
    }

    public Vector(AVector source) {
        int length = source.length();
        this.data = new double[length];
        source.copyTo(this.data, 0);
    }

    public static Vector wrap(double[] source) {
        return new Vector(source);
    }

    public static Vector of(double ... values) {
        int length = values.length;
        double[] data = new double[length];
        System.arraycopy(values, 0, data, 0, length);
        return new Vector(data);
    }

    public static Vector createLength(int length) {
        return new Vector(length);
    }

    @Override
    public int length() {
        return this.data.length;
    }

    @Override
    public double get(int i) {
        return this.data[i];
    }

    @Override
    public void set(int i, double value) {
        this.data[i] = value;
    }

    @Override
    public double[] getArray() {
        return this.data;
    }

    @Override
    public int getArrayOffset() {
        return 0;
    }

    @Override
    public void fill(double value) {
        Arrays.fill(this.data, value);
    }

    @Override
    public void add(ArrayVector v, int offset) {
        int vlength = v.length();
        int length = this.length();
        assert (offset >= 0);
        assert (offset + length <= vlength);
        double[] vdata = v.getArray();
        int voffset = v.getArrayOffset() + offset;
        for (int i = 0; i < length; ++i) {
            int n = i;
            this.data[n] = this.data[n] + vdata[voffset + i];
        }
    }

    @Override
    public void addMultiple(ArrayVector v, double factor) {
        int length = this.length();
        assert (length == v.length());
        double[] vdata = v.getArray();
        int voffset = v.getArrayOffset();
        for (int i = 0; i < length; ++i) {
            int n = i;
            this.data[n] = this.data[n] + vdata[voffset + i] * factor;
        }
    }

    @Override
    public void add(AVector v) {
        if (v instanceof ArrayVector) {
            this.add((ArrayVector)v, 0);
            return;
        }
        int vlength = v.length();
        int length = this.length();
        assert (length == vlength);
        for (int i = 0; i < length; ++i) {
            int n = i;
            this.data[n] = this.data[n] + v.get(i);
        }
    }

    @Override
    public void addProduct(AVector a, AVector b) {
        if (a instanceof Vector && b instanceof Vector) {
            this.addProduct((Vector)a, (Vector)b);
            return;
        }
        super.addProduct(a, b);
    }

    public void addProduct(Vector a, Vector b) {
        int length = this.length();
        assert (a.length() == length && b.length() == length);
        for (int i = 0; i < length; ++i) {
            int n = i;
            this.data[n] = this.data[n] + a.data[i] * b.data[i];
        }
    }

    @Override
    public void sub(AVector v) {
        if (v instanceof ArrayVector) {
            this.sub((ArrayVector)v);
            return;
        }
        int length = this.length();
        assert (length == v.length());
        for (int i = 0; i < length; ++i) {
            int n = i;
            this.data[n] = this.data[n] - v.get(i);
        }
    }

    @Override
    public double dotProduct(AVector v, Index ix) {
        if (v instanceof Vector) {
            return this.dotProduct((Vector)v, ix);
        }
        int vl = v.length();
        assert (v.length() == ix.length());
        double result = 0.0;
        int[] idata = ix.getData();
        for (int i = 0; i < vl; ++i) {
            result += this.data[idata[i]] * v.get(i);
        }
        return result;
    }

    public double dotProduct(Vector v, Index ix) {
        int vl = v.length();
        assert (v.length() == ix.length());
        double result = 0.0;
        int[] idata = ix.getData();
        for (int i = 0; i < vl; ++i) {
            result += this.data[idata[i]] * v.data[i];
        }
        return result;
    }

    @Override
    public double dotProduct(AVector v) {
        if (v instanceof Vector) {
            return this.dotProduct((Vector)v);
        }
        int len = this.length();
        assert (v.length() == len);
        double result = 0.0;
        for (int i = 0; i < len; ++i) {
            result += this.data[i] * v.get(i);
        }
        return result;
    }

    public double dotProduct(Vector v) {
        int len = this.length();
        assert (v.length() == len);
        double result = 0.0;
        for (int i = 0; i < len; ++i) {
            result += this.data[i] * v.data[i];
        }
        return result;
    }

    public void sub(ArrayVector v) {
        this.sub(v, 0);
    }

    public void sub(ArrayVector v, int offset) {
        int length = this.length();
        assert (length == v.length());
        double[] vdata = v.getArray();
        int voffset = v.getArrayOffset() + offset;
        for (int i = 0; i < length; ++i) {
            int n = i;
            this.data[n] = this.data[n] - vdata[voffset + i];
        }
    }

    @Override
    public void addMultiple(AVector v, double factor) {
        if (v instanceof ArrayVector) {
            this.addMultiple((ArrayVector)v, factor);
            return;
        }
        int length = this.length();
        assert (length == v.length());
        for (int i = 0; i < length; ++i) {
            int n = i;
            this.data[n] = this.data[n] + v.get(i) * factor;
        }
    }

    @Override
    public void multiply(double factor) {
        int len = this.length();
        int i = 0;
        while (i < len) {
            int n = i++;
            this.data[n] = this.data[n] * factor;
        }
    }

    @Override
    public boolean isReference() {
        return false;
    }

    @Override
    public AVector clone() {
        return new Vector(this);
    }
}

