/*
 * Decompiled with CFR 0.152.
 */
package mikera.matrixx.impl;

import mikera.indexz.Index;
import mikera.indexz.Indexz;
import mikera.matrixx.AMatrix;
import mikera.vectorz.AVector;
import mikera.vectorz.util.VectorzException;

public class PermutedMatrix
extends AMatrix {
    private final AMatrix source;
    private final Index rowPermutations;
    private final Index columnPermutations;

    public PermutedMatrix(AMatrix source, Index rowPermutations) {
        this(source, rowPermutations, Indexz.createSequence(source.columnCount()));
    }

    public PermutedMatrix(AMatrix source, Index rowPermutations, Index columnPermutations) {
        if (source instanceof PermutedMatrix) {
            PermutedMatrix pm = (PermutedMatrix)source;
            Index rp = pm.rowPermutations.clone();
            rp.permute(rowPermutations);
            rowPermutations = rp;
            Index cp = pm.columnPermutations.clone();
            rp.permute(columnPermutations);
            columnPermutations = cp;
            source = pm.source;
        }
        if (source.rowCount() != rowPermutations.length()) {
            throw new VectorzException("Incorrect row permutation count: " + rowPermutations.length());
        }
        if (source.columnCount() != columnPermutations.length()) {
            throw new VectorzException("Incorrect column permutation count: " + columnPermutations.length());
        }
        this.rowPermutations = rowPermutations;
        this.columnPermutations = columnPermutations;
        this.source = source;
    }

    @Override
    public int rowCount() {
        return this.source.rowCount();
    }

    @Override
    public int columnCount() {
        return this.source.columnCount();
    }

    @Override
    public double get(int row, int column) {
        row = this.rowPermutations.get(row);
        column = this.columnPermutations.get(row);
        return this.source.get(row, column);
    }

    @Override
    public void set(int row, int column, double value) {
        row = this.rowPermutations.get(row);
        column = this.columnPermutations.get(row);
        this.source.set(row, column, value);
    }

    @Override
    public AVector getRow(int row) {
        return this.source.getRow(this.rowPermutations.get(row));
    }

    @Override
    public AVector getColumn(int column) {
        return this.source.getColumn(this.columnPermutations.get(column));
    }
}

