/*
 * Decompiled with CFR 0.152.
 */
package mikera.indexz;

import java.util.Arrays;
import mikera.indexz.AIndex;

public final class Index
extends AIndex {
    private static final long serialVersionUID = 8698831088064498284L;
    final int[] data;

    public Index(int length) {
        this.data = new int[length];
    }

    private Index(int[] indexes) {
        this.data = indexes;
    }

    @Override
    public void swap(int i, int j) {
        int t = this.data[i];
        this.data[i] = this.data[j];
        this.data[j] = t;
    }

    @Override
    public void reverse() {
        int len = this.length();
        int m = len / 2;
        for (int i = 0; i < m; ++i) {
            this.swap(i, len - 1 - i);
        }
    }

    public static Index wrap(int[] indexes) {
        return new Index(indexes);
    }

    public static Index of(int ... indexes) {
        return new Index((int[])indexes.clone());
    }

    @Override
    public int get(int i) {
        return this.data[i];
    }

    @Override
    public void set(int i, int value) {
        this.data[i] = value;
    }

    @Override
    public int length() {
        return this.data.length;
    }

    @Override
    public Index clone() {
        return new Index((int[])this.data.clone());
    }

    public void permute(Index permutationIndex) {
        int len = this.length();
        assert (len == permutationIndex.length());
        int[] temp = (int[])this.data.clone();
        for (int i = 0; i < len; ++i) {
            this.data[i] = temp[permutationIndex.get(i)];
        }
    }

    public void sort() {
        Arrays.sort(this.data);
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof Index) {
            return this.equals((Index)o);
        }
        return super.equals(o);
    }

    public boolean equals(Index o) {
        int len = this.length();
        if (len != o.length()) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (this.data[i] == o.data[i]) continue;
            return false;
        }
        return true;
    }

    public int[] getData() {
        return this.data;
    }

    @Override
    public int[] toArray() {
        return (int[])this.getData().clone();
    }

    @Override
    public boolean isFullyMutable() {
        return true;
    }

    public void lookupWith(Index source) {
        int len = this.length();
        for (int i = 0; i < len; ++i) {
            this.data[i] = source.data[this.data[i]];
        }
    }
}

