/*
 * Decompiled with CFR 0.152.
 */
package mikera.vectorz.impl;

import mikera.vectorz.AVector;

public final class JoinedVector
extends AVector {
    private static final long serialVersionUID = -5535850407701653222L;
    private final AVector left;
    private final AVector right;
    private final int split;
    private final int length;

    public JoinedVector(AVector left, AVector right) {
        if (left.length() * 2 < right.length() && right instanceof JoinedVector) {
            JoinedVector v = new JoinedVector(left, ((JoinedVector)right).left);
            left = v;
            right = ((JoinedVector)right).right;
        } else if (left.length() > right.length() * 2 && left instanceof JoinedVector) {
            JoinedVector v = new JoinedVector(((JoinedVector)left).right, right);
            left = ((JoinedVector)left).left;
            right = v;
        }
        this.left = left;
        this.right = right;
        this.split = left.length();
        this.length = this.split + right.length();
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public boolean isReference() {
        return true;
    }

    @Override
    public AVector subVector(int start, int length) {
        if (start >= this.split) {
            return this.right.subVector(start - this.split, length);
        }
        if (start + length <= this.split) {
            return this.left.subVector(start, length);
        }
        AVector v1 = this.left.subVector(start, this.split - start);
        AVector v2 = this.right.subVector(0, length - (this.split - start));
        return new JoinedVector(v1, v2);
    }

    @Override
    public double get(int i) {
        if (i < this.split) {
            return this.left.get(i);
        }
        return this.right.get(i - this.split);
    }

    @Override
    public void set(int i, double value) {
        if (i < this.split) {
            this.left.set(i, value);
        } else {
            this.right.set(i - this.split, value);
        }
    }

    @Override
    public void fill(double value) {
        this.left.fill(value);
        this.right.fill(value);
    }

    @Override
    public void multiply(double value) {
        this.left.multiply(value);
        this.right.multiply(value);
    }
}

