/*
 * Decompiled with CFR 0.152.
 */
package mikera.vectorz;

import bpsm.edn.parser.CollectionBuilder;
import bpsm.edn.parser.Parser;
import bpsm.edn.parser.Parsers;
import java.io.StringReader;
import java.util.List;
import mikera.util.Rand;
import mikera.vectorz.AVector;
import mikera.vectorz.Tools;
import mikera.vectorz.Vector;
import mikera.vectorz.Vector1;
import mikera.vectorz.Vector2;
import mikera.vectorz.Vector3;
import mikera.vectorz.Vector4;
import mikera.vectorz.impl.ZeroLengthVector;
import mikera.vectorz.impl.ZeroVector;
import mikera.vectorz.util.VectorBuilder;
import mikera.vectorz.util.VectorzException;

public class Vectorz {
    public static final double TEST_EPSILON = 1.0E-7;
    private static final AVector[] ZERO_VECTORS = new AVector[]{ZeroLengthVector.INSTANCE, new ZeroVector(1), new ZeroVector(2), new ZeroVector(3), new ZeroVector(4)};

    public static AVector create(double ... data) {
        switch (data.length) {
            case 0: {
                return ZeroLengthVector.INSTANCE;
            }
            case 1: {
                return Vector1.of(data);
            }
            case 2: {
                return Vector2.of(data);
            }
            case 3: {
                return Vector3.of(data);
            }
            case 4: {
                return Vector4.of(data);
            }
        }
        return Vector.of(data);
    }

    public static AVector join(AVector first, AVector second) {
        return first.join(second);
    }

    public static AVector join(List<AVector> vectors) {
        int count = vectors.size();
        AVector v = vectors.get(0);
        for (int i = 1; i < count; ++i) {
            v = v.join(vectors.get(i));
        }
        return v;
    }

    public static AVector createZeroVector(int length) {
        return Vectorz.createLength(length);
    }

    public static AVector wrap(double[] data) {
        return Vector.wrap(data);
    }

    public static AVector wrap(double[][] data) {
        if (data.length == 0) {
            return ZeroLengthVector.INSTANCE;
        }
        AVector v = Vectorz.wrap(data[0]);
        for (int i = 1; i < data.length; ++i) {
            v = Vectorz.join(v, Vectorz.wrap(data[i]));
        }
        return v;
    }

    public static AVector createLength(int length) {
        switch (length) {
            case 0: {
                return ZeroLengthVector.INSTANCE;
            }
            case 1: {
                return new Vector1();
            }
            case 2: {
                return new Vector2();
            }
            case 3: {
                return new Vector3();
            }
            case 4: {
                return new Vector4();
            }
        }
        return new Vector(length);
    }

    public static AVector createSameSize(AVector v) {
        return Vectorz.createLength(v.length());
    }

    public static AVector deepCopy(AVector vector) {
        if (!vector.isReference()) {
            return vector.clone();
        }
        AVector nv = Vectorz.createLength(vector.length());
        vector.copyTo(nv, 0);
        return nv;
    }

    public static void copy(AVector source, int srcOffset, AVector dest, int destOffset, int length) {
        source.copy(srcOffset, length, dest, destOffset);
    }

    public static AVector createUniformRandomVector(int dimensions) {
        AVector v = Vectorz.createLength(dimensions);
        for (int i = 0; i < dimensions; ++i) {
            v.set(i, Rand.nextDouble());
        }
        return v;
    }

    public static AVector createMutableVector(AVector t) {
        AVector v = Vectorz.createLength(t.length());
        v.set(t);
        return v;
    }

    public static AVector immutableZeroVector(int dimensions) {
        if (dimensions >= ZERO_VECTORS.length) {
            return new ZeroVector(dimensions);
        }
        return ZERO_VECTORS[dimensions];
    }

    private static Parser.Config getVectorParserConfig() {
        return ParserConfigHolder.parserConfig;
    }

    public static AVector parse(String ednString) {
        Parser p = Parsers.newParser((Parser.Config)Vectorz.getVectorParserConfig(), (Readable)new StringReader(ednString));
        return (AVector)p.nextValue();
    }

    public static AVector create(List<Object> d) {
        int length = d.size();
        double[] data = new double[length];
        for (int i = 0; i < length; ++i) {
            data[i] = Tools.toDouble(d.get(i));
        }
        AVector v = Vectorz.createLength(length);
        v.setValues(data);
        return v;
    }

    public static double minValue(AVector v) {
        int len = v.length();
        double min = Double.MAX_VALUE;
        for (int i = 0; i < len; ++i) {
            double d = v.get(i);
            if (!(d < min)) continue;
            min = d;
        }
        return min;
    }

    public static double maxValue(AVector v) {
        int len = v.length();
        double max = -1.7976931348623157E308;
        for (int i = 0; i < len; ++i) {
            double d = v.get(i);
            if (!(d > max)) continue;
            max = d;
        }
        return max;
    }

    public static double totalValue(AVector v) {
        int len = v.length();
        double result = 0.0;
        for (int i = 0; i < len; ++i) {
            result += v.get(i);
        }
        return result;
    }

    public static double averageValue(AVector v) {
        int len = v.length();
        double result = 0.0;
        for (int i = 0; i < len; ++i) {
            result += v.get(i);
        }
        return result / (double)len;
    }

    private static class ParserConfigHolder {
        static final Parser.Config parserConfig;

        private ParserConfigHolder() {
        }

        static {
            Parser.Config.Builder b = Parsers.newParserConfigBuilder();
            b.setVectorFactory(new CollectionBuilder.Factory(){

                public CollectionBuilder builder() {
                    return new CollectionBuilder(){
                        VectorBuilder b = new VectorBuilder();

                        public void add(Object o) {
                            double d;
                            if (o instanceof Double) {
                                d = (Double)o;
                            } else if (o instanceof Number) {
                                d = ((Number)o).doubleValue();
                            } else {
                                throw new VectorzException("Cannot parse double value from class: " + o.getClass());
                            }
                            this.b.add(d);
                        }

                        public Object build() {
                            return this.b.toVector();
                        }
                    };
                }
            });
            parserConfig = b.build();
        }
    }
}

