/*
 * Decompiled with CFR 0.152.
 */
package mikera.matrixx.impl;

import mikera.matrixx.AMatrix;
import mikera.matrixx.impl.AVectorMatrix;
import mikera.vectorz.AVector;
import mikera.vectorz.Vectorz;

public final class VectorMatrixMN
extends AVectorMatrix {
    private final int rowCount;
    private final int columnCount;
    private final AVector[] rows;

    public VectorMatrixMN(int rowCount, int columnCount) {
        this.rows = new AVector[rowCount];
        this.rowCount = rowCount;
        this.columnCount = columnCount;
        for (int i = 0; i < rowCount; ++i) {
            this.rows[i] = Vectorz.createLength(columnCount);
        }
    }

    public VectorMatrixMN(AMatrix source) {
        this(source.rowCount(), source.columnCount());
        for (int i = 0; i < this.rowCount; ++i) {
            for (int j = 0; j < this.columnCount; ++j) {
                this.set(i, j, source.get(i, j));
            }
        }
    }

    @Override
    public AVector getRow(int row) {
        return this.rows[row];
    }

    @Override
    public int rowCount() {
        return this.rowCount;
    }

    @Override
    public int columnCount() {
        return this.columnCount;
    }

    @Override
    public double get(int row, int column) {
        return this.rows[row].get(column);
    }

    @Override
    public void set(int row, int column, double value) {
        this.rows[row].set(column, value);
    }

    @Override
    public void transform(AVector source, AVector dest) {
        for (int i = 0; i < this.rowCount; ++i) {
            dest.set(i, this.getRow(i).dotProduct(source));
        }
    }

    @Override
    public boolean isSquare() {
        return this.rowCount == this.columnCount;
    }

    @Override
    public VectorMatrixMN clone() {
        VectorMatrixMN m = new VectorMatrixMN(this.rowCount, this.columnCount);
        for (int i = 0; i < this.rowCount; ++i) {
            m.rows[i].set(this.rows[i]);
        }
        return m;
    }
}

