/*
 * Decompiled with CFR 0.152.
 */
package mikera.matrixx;

import mikera.matrixx.AMatrix;
import mikera.transformz.Affine34;
import mikera.transformz.marker.ISpecialisedTransform;
import mikera.vectorz.AVector;
import mikera.vectorz.Vector3;

public final class Matrix33
extends AMatrix
implements ISpecialisedTransform {
    public double m00;
    public double m01;
    public double m02;
    public double m10;
    public double m11;
    public double m12;
    public double m20;
    public double m21;
    public double m22;

    public Matrix33() {
    }

    public Matrix33(Matrix33 source) {
        Matrix33 s = source;
        this.m00 = s.m00;
        this.m01 = s.m01;
        this.m02 = s.m02;
        this.m10 = s.m10;
        this.m11 = s.m11;
        this.m12 = s.m12;
        this.m20 = s.m20;
        this.m21 = s.m21;
        this.m22 = s.m22;
    }

    public Matrix33(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22) {
        this.m00 = m00;
        this.m01 = m01;
        this.m02 = m02;
        this.m10 = m10;
        this.m11 = m11;
        this.m12 = m12;
        this.m20 = m20;
        this.m21 = m21;
        this.m22 = m22;
    }

    public Matrix33(AMatrix m) {
        assert (m.rowCount() == 3);
        assert (m.columnCount() == 3);
        this.m00 = m.get(0, 0);
        this.m01 = m.get(0, 1);
        this.m02 = m.get(0, 2);
        this.m10 = m.get(1, 0);
        this.m11 = m.get(1, 1);
        this.m12 = m.get(1, 2);
        this.m20 = m.get(2, 0);
        this.m21 = m.get(2, 1);
        this.m22 = m.get(2, 2);
    }

    @Override
    public double determinant() {
        return this.m00 * this.m11 * this.m22 + this.m01 * this.m12 * this.m20 + this.m02 * this.m10 * this.m21 - this.m00 * this.m12 * this.m21 - this.m01 * this.m10 * this.m22 - this.m02 * this.m11 * this.m20;
    }

    @Override
    public int rowCount() {
        return 3;
    }

    @Override
    public int columnCount() {
        return 3;
    }

    @Override
    public double get(int row, int column) {
        switch (row) {
            case 0: {
                switch (column) {
                    case 0: {
                        return this.m00;
                    }
                    case 1: {
                        return this.m01;
                    }
                    case 2: {
                        return this.m02;
                    }
                }
                throw new IndexOutOfBoundsException("Column: " + row);
            }
            case 1: {
                switch (column) {
                    case 0: {
                        return this.m10;
                    }
                    case 1: {
                        return this.m11;
                    }
                    case 2: {
                        return this.m12;
                    }
                }
                throw new IndexOutOfBoundsException("Column: " + row);
            }
            case 2: {
                switch (column) {
                    case 0: {
                        return this.m20;
                    }
                    case 1: {
                        return this.m21;
                    }
                    case 2: {
                        return this.m22;
                    }
                }
                throw new IndexOutOfBoundsException("Column: " + row);
            }
        }
        throw new IndexOutOfBoundsException("Row: " + row);
    }

    @Override
    public void set(int row, int column, double value) {
        switch (row) {
            case 0: {
                switch (column) {
                    case 0: {
                        this.m00 = value;
                        return;
                    }
                    case 1: {
                        this.m01 = value;
                        return;
                    }
                    case 2: {
                        this.m02 = value;
                        return;
                    }
                }
                throw new IndexOutOfBoundsException("Column: " + row);
            }
            case 1: {
                switch (column) {
                    case 0: {
                        this.m10 = value;
                        return;
                    }
                    case 1: {
                        this.m11 = value;
                        return;
                    }
                    case 2: {
                        this.m12 = value;
                        return;
                    }
                }
                throw new IndexOutOfBoundsException("Column: " + row);
            }
            case 2: {
                switch (column) {
                    case 0: {
                        this.m20 = value;
                        return;
                    }
                    case 1: {
                        this.m21 = value;
                        return;
                    }
                    case 2: {
                        this.m22 = value;
                        return;
                    }
                }
                throw new IndexOutOfBoundsException("Column: " + row);
            }
        }
        throw new IndexOutOfBoundsException("Row: " + row);
    }

    @Override
    public void transform(AVector source, AVector dest) {
        if (source instanceof Vector3) {
            this.transform((Vector3)source, dest);
            return;
        }
        super.transform(source, dest);
    }

    public void transform(Vector3 source, AVector dest) {
        if (dest instanceof Vector3) {
            this.transform(source, (Vector3)dest);
            return;
        }
        Vector3 s = source;
        dest.set(0, this.m00 * s.x + this.m01 * s.y + this.m02 * s.z);
        dest.set(1, this.m10 * s.x + this.m11 * s.y + this.m12 * s.z);
        dest.set(2, this.m20 * s.x + this.m21 * s.y + this.m22 * s.z);
    }

    public void transform(Vector3 source, Vector3 dest) {
        Vector3 s = source;
        dest.x = this.m00 * s.x + this.m01 * s.y + this.m02 * s.z;
        dest.y = this.m10 * s.x + this.m11 * s.y + this.m12 * s.z;
        dest.z = this.m20 * s.x + this.m21 * s.y + this.m22 * s.z;
    }

    public Vector3 transform(Vector3 source) {
        Vector3 s = source;
        Vector3 result = new Vector3(this.m00 * s.x + this.m01 * s.y + this.m02 * s.z, this.m10 * s.x + this.m11 * s.y + this.m12 * s.z, this.m20 * s.x + this.m21 * s.y + this.m22 * s.z);
        return result;
    }

    @Override
    public void transformInPlace(AVector dest) {
        if (dest instanceof Vector3) {
            this.transformInPlace((Vector3)dest);
            return;
        }
        double sx = dest.get(0);
        double sy = dest.get(1);
        double sz = dest.get(2);
        double tx = this.m00 * sx + this.m01 * sy + this.m02 * sz;
        double ty = this.m10 * sx + this.m11 * sy + this.m12 * sz;
        double tz = this.m20 * sx + this.m21 * sy + this.m22 * sz;
        dest.set(0, tx);
        dest.set(1, ty);
        dest.set(2, tz);
    }

    public void transformInPlace(Vector3 dest) {
        Vector3 s = dest;
        double tx = this.m00 * s.x + this.m01 * s.y + this.m02 * s.z;
        double ty = this.m10 * s.x + this.m11 * s.y + this.m12 * s.z;
        double tz = this.m20 * s.x + this.m21 * s.y + this.m22 * s.z;
        s.x = tx;
        s.y = ty;
        s.z = tz;
    }

    @Override
    public boolean isSquare() {
        return true;
    }

    @Override
    public Affine34 toAffineTransform() {
        return new Affine34(this.m00, this.m01, this.m02, 0.0, this.m10, this.m11, this.m12, 0.0, this.m20, this.m21, this.m22, 0.0);
    }

    @Override
    public Matrix33 transpose() {
        return new Matrix33(this.m00, this.m10, this.m20, this.m01, this.m11, this.m21, this.m02, this.m12, this.m22);
    }

    @Override
    public Matrix33 inverse() {
        double det = this.determinant();
        if (det == 0.0) {
            throw new IllegalArgumentException("Matrix has zero determinant: not invertible");
        }
        double invDet = 1.0 / det;
        return new Matrix33(invDet * (this.m11 * this.m22 - this.m12 * this.m21), invDet * (this.m02 * this.m21 - this.m01 * this.m22), invDet * (this.m01 * this.m12 - this.m02 * this.m11), invDet * (this.m12 * this.m20 - this.m10 * this.m22), invDet * (this.m00 * this.m22 - this.m02 * this.m20), invDet * (this.m02 * this.m10 - this.m00 * this.m12), invDet * (this.m10 * this.m21 - this.m11 * this.m20), invDet * (this.m01 * this.m20 - this.m00 * this.m21), invDet * (this.m00 * this.m11 - this.m01 * this.m10));
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof Matrix33) {
            return this.equals((Matrix33)o);
        }
        return super.equals(o);
    }

    public boolean equals(Matrix33 m) {
        return this.m00 == m.m00 && this.m01 == m.m01 && this.m02 == m.m02 && this.m10 == m.m10 && this.m11 == m.m11 && this.m12 == m.m12 && this.m20 == m.m20 && this.m21 == m.m21 && this.m22 == m.m22;
    }
}

