/*
 * Decompiled with CFR 0.152.
 */
package mikera.indexz;

import java.io.Serializable;
import java.util.Arrays;
import mikera.vectorz.Tools;

public final class Index
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 8698831088064498284L;
    final int[] data;

    public Index(int length) {
        this.data = new int[length];
    }

    private Index(int[] indexes) {
        this.data = indexes;
    }

    public void swap(int i, int j) {
        int t = this.data[i];
        this.data[i] = this.data[j];
        this.data[j] = t;
    }

    public void reverse() {
        int len = this.length();
        int m = len / 2;
        for (int i = 0; i < m; ++i) {
            this.swap(i, len - 1 - i);
        }
    }

    public static Index wrap(int[] indexes) {
        return new Index(indexes);
    }

    public static Index of(int ... indexes) {
        return new Index((int[])indexes.clone());
    }

    public int get(int i) {
        return this.data[i];
    }

    public void set(int i, int value) {
        this.data[i] = value;
    }

    public int length() {
        return this.data.length;
    }

    public Index clone() {
        return new Index((int[])this.data.clone());
    }

    public boolean equals(Object o) {
        if (o instanceof Index) {
            return this.equals((Index)o);
        }
        return false;
    }

    public void permute(Index permutationIndex) {
        int len = this.length();
        int[] temp = (int[])this.data.clone();
        for (int i = 0; i < len; ++i) {
            this.data[i] = temp[permutationIndex.get(i)];
        }
    }

    public void sort() {
        Arrays.sort(this.data);
    }

    public int[] toArray() {
        return (int[])this.data.clone();
    }

    public boolean equals(Index o) {
        int len = this.length();
        if (len != o.length()) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (this.data[i] == o.data[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        int len = this.length();
        for (int i = 0; i < len; ++i) {
            hashCode = 31 * hashCode + Tools.hashCode(this.get(i));
        }
        return hashCode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int length = this.length();
        sb.append('[');
        if (length > 0) {
            sb.append(this.get(0));
            for (int i = 1; i < length; ++i) {
                sb.append(',');
                sb.append(this.get(i));
            }
        }
        sb.append(']');
        return sb.toString();
    }
}

