/*
 * Decompiled with CFR 0.152.
 */
package mikera.vectorz.impl;

import mikera.indexz.Index;
import mikera.vectorz.AVector;
import mikera.vectorz.impl.AConstrainedVector;
import mikera.vectorz.util.IntArrays;

public class IndexVector
extends AConstrainedVector {
    private final Index index;
    private final int length;

    private IndexVector(Index index) {
        this.index = index;
        this.length = index.length();
    }

    public static IndexVector of(int ... values) {
        return new IndexVector(Index.of(values));
    }

    public IndexVector ofDoubles(double ... values) {
        return new IndexVector(Index.wrap(IntArrays.create(values)));
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public double get(int i) {
        return this.index.get(i);
    }

    @Override
    public void set(int i, double value) {
        int v = (int)value;
        if ((double)v != value) {
            throw new IllegalArgumentException("Can't convert to an integer index value: " + value);
        }
        this.index.set(i, v);
    }

    @Override
    public AVector exactClone() {
        return new IndexVector(this.index.clone());
    }
}

