/*
 * Decompiled with CFR 0.152.
 */
package mikera.matrixx.impl;

import java.util.Arrays;
import mikera.arrayz.ISparse;
import mikera.matrixx.AMatrix;
import mikera.matrixx.Matrix;
import mikera.matrixx.impl.DiagonalMatrix;
import mikera.vectorz.AVector;
import mikera.vectorz.Tools;
import mikera.vectorz.impl.AArrayVector;
import mikera.vectorz.util.ErrorMessages;
import mikera.vectorz.util.VectorzException;

public abstract class ADiagonalMatrix
extends AMatrix
implements ISparse {
    protected final int dimensions;

    public ADiagonalMatrix(int dimensions) {
        this.dimensions = dimensions;
    }

    @Override
    public boolean isSquare() {
        return true;
    }

    @Override
    public boolean isSymmetric() {
        return true;
    }

    @Override
    public boolean isDiagonal() {
        return true;
    }

    @Override
    public boolean isRectangularDiagonal() {
        return true;
    }

    @Override
    public boolean isUpperTriangular() {
        return true;
    }

    @Override
    public boolean isLowerTriangular() {
        return true;
    }

    @Override
    public abstract boolean isMutable();

    @Override
    public boolean isFullyMutable() {
        return false;
    }

    @Override
    public double determinant() {
        double det = 1.0;
        for (int i = 0; i < this.dimensions; ++i) {
            det *= this.getDiagonalValue(i);
        }
        return det;
    }

    public int dimensions() {
        return this.dimensions;
    }

    @Override
    public void copyRowTo(int row, double[] dest, int destOffset) {
        Arrays.fill(dest, destOffset, destOffset + this.dimensions, 0.0);
        dest[destOffset + row] = this.getDiagonalValue(row);
    }

    @Override
    public void copyColumnTo(int col, double[] dest, int destOffset) {
        this.copyRowTo(col, dest, destOffset);
    }

    public AMatrix innerProduct(ADiagonalMatrix a) {
        int dims = this.dimensions;
        if (dims != a.dimensions) {
            throw new IllegalArgumentException(ErrorMessages.incompatibleShapes(this, a));
        }
        DiagonalMatrix result = DiagonalMatrix.createDimensions(dims);
        for (int i = 0; i < dims; ++i) {
            result.data[i] = this.getDiagonalValue(i) * a.getDiagonalValue(i);
        }
        return result;
    }

    @Override
    public AMatrix innerProduct(AMatrix a) {
        if (a instanceof ADiagonalMatrix) {
            return this.innerProduct((ADiagonalMatrix)a);
        }
        if (a instanceof Matrix) {
            return this.innerProduct((Matrix)a);
        }
        if (this.dimensions != a.rowCount()) {
            throw new IllegalArgumentException(ErrorMessages.incompatibleShapes(this, a));
        }
        int acc = a.columnCount();
        Matrix m = Matrix.create(this.dimensions, acc);
        for (int i = 0; i < this.dimensions; ++i) {
            double dv = this.getDiagonalValue(i);
            for (int j = 0; j < acc; ++j) {
                m.unsafeSet(i, j, dv * a.unsafeGet(i, j));
            }
        }
        return m;
    }

    @Override
    public Matrix innerProduct(Matrix a) {
        if (this.dimensions != a.rowCount()) {
            throw new IllegalArgumentException(ErrorMessages.incompatibleShapes(this, a));
        }
        int acc = a.columnCount();
        Matrix m = Matrix.create(this.dimensions, acc);
        for (int i = 0; i < this.dimensions; ++i) {
            double dv = this.getDiagonalValue(i);
            for (int j = 0; j < acc; ++j) {
                m.unsafeSet(i, j, dv * a.unsafeGet(i, j));
            }
        }
        return m;
    }

    @Override
    public Matrix transposeInnerProduct(Matrix s) {
        return this.innerProduct(s);
    }

    @Override
    public void transformInPlace(AVector v) {
        if (v instanceof AArrayVector) {
            this.transformInPlace((AArrayVector)v);
            return;
        }
        if (v.length() != this.dimensions) {
            throw new IllegalArgumentException(ErrorMessages.incompatibleShapes(this, v));
        }
        for (int i = 0; i < this.dimensions; ++i) {
            v.unsafeSet(i, v.unsafeGet(i) * this.getDiagonalValue(i));
        }
    }

    @Override
    public void transformInPlace(AArrayVector v) {
        double[] data = v.getArray();
        int offset = v.getArrayOffset();
        for (int i = 0; i < this.dimensions; ++i) {
            int n = i + offset;
            data[n] = data[n] * this.getDiagonalValue(i);
        }
    }

    @Override
    public int rowCount() {
        return this.dimensions;
    }

    @Override
    public int columnCount() {
        return this.dimensions;
    }

    @Override
    public boolean isIdentity() {
        for (int i = 0; i < this.dimensions; ++i) {
            if (this.unsafeGet(i, i) == 1.0) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isBoolean() {
        for (int i = 0; i < this.dimensions; ++i) {
            if (Tools.isBoolean(this.unsafeGet(i, i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void transposeInPlace() {
    }

    @Override
    public double calculateElement(int i, AVector v) {
        return v.unsafeGet(i) * this.getDiagonalValue(i);
    }

    @Override
    public void set(int row, int column, double value) {
        throw new UnsupportedOperationException(ErrorMessages.notFullyMutable(this, row, column));
    }

    public double getDiagonalValue(int i) {
        if (i < 0 || i >= this.dimensions) {
            throw new IndexOutOfBoundsException();
        }
        return this.unsafeGet(i, i);
    }

    @Override
    public ADiagonalMatrix getTranspose() {
        return this;
    }

    @Override
    public ADiagonalMatrix getTransposeView() {
        return this;
    }

    @Override
    public double density() {
        return 1.0 / (double)this.dimensions;
    }

    @Override
    public Matrix toMatrix() {
        Matrix m = Matrix.create(this.dimensions, this.dimensions);
        for (int i = 0; i < this.dimensions; ++i) {
            m.data[i * (this.dimensions + 1)] = this.getDiagonalValue(i);
        }
        return m;
    }

    @Override
    public void validate() {
        if (this.dimensions != this.getLeadingDiagonal().length()) {
            throw new VectorzException("dimension mismatch: " + this.dimensions);
        }
        super.validate();
    }
}

