/*
 * Decompiled with CFR 0.152.
 */
package mikera.arrayz.impl;

import java.nio.DoubleBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import mikera.arrayz.Array;
import mikera.arrayz.Arrayz;
import mikera.arrayz.INDArray;
import mikera.arrayz.NDArray;
import mikera.arrayz.SliceArray;
import mikera.arrayz.impl.SliceElementIterator;
import mikera.arrayz.impl.SliceIterator;
import mikera.matrixx.Matrix;
import mikera.util.Maths;
import mikera.vectorz.Ops;
import mikera.vectorz.Tools;
import mikera.vectorz.Vector;
import mikera.vectorz.impl.SingleDoubleIterator;
import mikera.vectorz.util.ErrorMessages;
import mikera.vectorz.util.IntArrays;

public abstract class AbstractArray<T>
implements INDArray,
Iterable<T> {
    @Override
    public double get() {
        return this.get(IntArrays.EMPTY_INT_ARRAY);
    }

    @Override
    public double get(int x) {
        return this.get(new int[]{x});
    }

    @Override
    public double get(int x, int y) {
        return this.get(new int[]{x, y});
    }

    @Override
    public int getShape(int dim) {
        return this.getShape()[dim];
    }

    @Override
    public boolean epsilonEquals(INDArray a) {
        return this.epsilonEquals(a, 1.0E-7);
    }

    @Override
    public boolean epsilonEquals(INDArray a, double epsilon) {
        if (this.dimensionality() == 0) {
            double d = this.get() - a.get();
            return Math.abs(d) <= epsilon;
        }
        int sc = this.sliceCount();
        if (a.sliceCount() != sc) {
            return false;
        }
        for (int i = 0; i < sc; ++i) {
            INDArray s = this.slice(i);
            if (s.epsilonEquals(a.slice(i), epsilon)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isBoolean() {
        if (this.dimensionality() == 0) {
            return Tools.isBoolean(this.get());
        }
        int sc = this.sliceCount();
        for (int i = 0; i < sc; ++i) {
            INDArray s = this.slice(i);
            if (s.isBoolean()) continue;
            return false;
        }
        return true;
    }

    @Override
    public INDArray ensureMutable() {
        if (this.isFullyMutable() && !this.isView()) {
            return this;
        }
        return this.clone();
    }

    @Override
    public void fill(double value) {
        if (this.dimensionality() == 0) {
            this.set(value);
        } else {
            int sc = this.sliceCount();
            for (int i = 0; i < sc; ++i) {
                INDArray s = this.slice(i);
                s.fill(value);
            }
        }
    }

    @Override
    public INDArray innerProduct(INDArray a) {
        int dims = this.dimensionality();
        switch (dims) {
            case 0: {
                a = a.clone();
                a.scale(this.get());
                return a;
            }
            case 1: {
                return this.toVector().innerProduct(a);
            }
            case 2: {
                return Matrix.create(this).innerProduct(a);
            }
        }
        int sc = this.sliceCount();
        ArrayList<INDArray> sips = new ArrayList<INDArray>();
        for (int i = 0; i < sc; ++i) {
            sips.add(this.slice(i).innerProduct(a));
        }
        return SliceArray.create(sips);
    }

    @Override
    public INDArray outerProduct(INDArray a) {
        ArrayList<INDArray> al = new ArrayList<INDArray>();
        for (T s : this) {
            if (s instanceof INDArray) {
                al.add(((INDArray)s).outerProduct(a));
                continue;
            }
            double x = Tools.toDouble(s);
            INDArray sa = a.clone();
            sa.scale(x);
            al.add(sa);
        }
        return Arrayz.create(al);
    }

    @Override
    public INDArray getTranspose() {
        NDArray nd = NDArray.newArray(this.getShape());
        nd.set(this);
        return nd.getTransposeView();
    }

    @Override
    public INDArray getTransposeView() {
        throw new UnsupportedOperationException();
    }

    @Override
    public INDArray getTransposeCopy() {
        return this.getTranspose().clone();
    }

    @Override
    public final void scale(double d) {
        this.multiply(d);
    }

    @Override
    public void scaleAdd(double factor, double constant) {
        this.multiply(factor);
        this.add(constant);
    }

    @Override
    public void set(double value) {
        this.set(new int[0], value);
    }

    @Override
    public void set(int x, double value) {
        this.set(new int[]{x}, value);
    }

    @Override
    public void set(int x, int y, double value) {
        this.set(new int[]{x, y}, value);
    }

    @Override
    public void set(INDArray a) {
        int tdims = this.dimensionality();
        int adims = a.dimensionality();
        if (adims < tdims) {
            int sc = this.sliceCount();
            for (int i = 0; i < sc; ++i) {
                INDArray s = this.slice(i);
                s.set(a);
            }
        } else if (adims == tdims) {
            if (tdims == 0) {
                this.set(a.get());
                return;
            }
            int sc = this.sliceCount();
            for (int i = 0; i < sc; ++i) {
                INDArray s = this.slice(i);
                s.set(a.slice(i));
            }
        } else {
            throw new IllegalArgumentException(ErrorMessages.incompatibleShapes(this, a));
        }
    }

    @Override
    public void clamp(double min, double max) {
        if (this.dimensionality() == 0) {
            this.set(Maths.bound((double)this.get(), (double)min, (double)max));
            return;
        }
        int len = this.sliceCount();
        for (int i = 0; i < len; ++i) {
            this.slice(i).clamp(min, max);
        }
    }

    @Override
    public void set(Object o) {
        if (o instanceof INDArray) {
            this.set((INDArray)o);
            return;
        }
        if (o instanceof Number) {
            this.set(((Number)o).doubleValue());
            return;
        }
        if (o instanceof Iterable) {
            int i = 0;
            for (Object ob : (Iterable)o) {
                this.slice(i).set(ob);
            }
            return;
        }
        if (o instanceof double[]) {
            this.setElements((double[])o);
            return;
        }
        throw new UnsupportedOperationException("Can't set to value for " + o.getClass().toString());
    }

    @Override
    public void setElements(double[] values) {
        this.setElements(values, 0, values.length);
    }

    @Override
    public void square() {
        this.applyOp(Ops.SQUARE);
    }

    @Override
    public Iterator<T> iterator() {
        return new SliceIterator(this);
    }

    @Override
    public Iterator<Double> elementIterator() {
        if (this.dimensionality() == 0) {
            return new SingleDoubleIterator(this.get());
        }
        return new SliceElementIterator(this);
    }

    public boolean equals(Object o) {
        if (!(o instanceof INDArray)) {
            return false;
        }
        return this.equals((INDArray)o);
    }

    public int hashCode() {
        return this.asVector().hashCode();
    }

    public String toString() {
        if (this.dimensionality() == 0) {
            return Double.toString(this.get());
        }
        StringBuilder sb = new StringBuilder();
        int length = this.sliceCount();
        sb.append('[');
        if (length > 0) {
            sb.append(this.slice(0).toString());
            for (int i = 1; i < length; ++i) {
                sb.append(',');
                sb.append(this.slice(i).toString());
            }
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    public INDArray clone() {
        return Arrayz.create(this);
    }

    @Override
    public boolean equals(INDArray a) {
        int dims = this.dimensionality();
        if (a.dimensionality() != dims) {
            return false;
        }
        if (dims == 0) {
            return this.get() == a.get();
        }
        int sc = this.sliceCount();
        for (int i = 0; i < sc; ++i) {
            if (this.slice(i).equals(a.slice(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void add(INDArray a) {
        int adims;
        int n = this.sliceCount();
        int na = a.sliceCount();
        int dims = this.dimensionality();
        if (dims == (adims = a.dimensionality())) {
            if (n != na) {
                throw new IllegalArgumentException(ErrorMessages.incompatibleShapes(this, a));
            }
            for (int i = 0; i < n; ++i) {
                this.slice(i).add(a.slice(i));
            }
        } else if (adims < dims) {
            for (int i = 0; i < n; ++i) {
                this.slice(i).add(a);
            }
        } else {
            throw new IllegalArgumentException(ErrorMessages.incompatibleShapes(this, a));
        }
    }

    @Override
    public void add(double a) {
        int dims = this.dimensionality();
        if (dims == 0) {
            this.set(a + this.get());
        } else {
            int n = this.sliceCount();
            for (int i = 0; i < n; ++i) {
                this.slice(i).add(a);
            }
        }
    }

    @Override
    public void pow(double exponent) {
        int dims = this.dimensionality();
        if (dims == 0) {
            this.set(Math.pow(this.get(), exponent));
        } else {
            int n = this.sliceCount();
            for (int i = 0; i < n; ++i) {
                this.slice(i).pow(exponent);
            }
        }
    }

    @Override
    public void sub(double a) {
        this.add(-a);
    }

    @Override
    public void multiply(INDArray a) {
        int dims = this.dimensionality();
        if (dims == 0) {
            this.set(this.get() * a.get());
            return;
        }
        int adims = a.dimensionality();
        if (adims == 0) {
            this.multiply(a.get());
            return;
        }
        int n = this.sliceCount();
        int na = a.sliceCount();
        if (dims == adims) {
            if (n != na) {
                throw new IllegalArgumentException(ErrorMessages.incompatibleShapes(this, a));
            }
            for (int i = 0; i < n; ++i) {
                this.slice(i).multiply(a.slice(i));
            }
        } else if (adims < dims) {
            for (int i = 0; i < n; ++i) {
                this.slice(i).multiply(a);
            }
        } else {
            throw new IllegalArgumentException(ErrorMessages.incompatibleShapes(this, a));
        }
    }

    @Override
    public long nonZeroCount() {
        if (this.dimensionality() == 0) {
            return this.get() == 0.0 ? 0L : 1L;
        }
        long result = 0L;
        int n = this.sliceCount();
        for (int i = 0; i < n; ++i) {
            result += this.slice(i).nonZeroCount();
        }
        return result;
    }

    @Override
    public double elementSum() {
        if (this.dimensionality() == 0) {
            return this.get();
        }
        double result = 0.0;
        int n = this.sliceCount();
        for (int i = 0; i < n; ++i) {
            result += this.slice(i).elementSum();
        }
        return result;
    }

    @Override
    public double elementSquaredSum() {
        if (this.dimensionality() == 0) {
            double value = this.get();
            return value * value;
        }
        double result = 0.0;
        int n = this.sliceCount();
        for (int i = 0; i < n; ++i) {
            result += this.slice(i).elementSquaredSum();
        }
        return result;
    }

    @Override
    public void sub(INDArray a) {
        int adims;
        int n = this.sliceCount();
        int na = a.sliceCount();
        int dims = this.dimensionality();
        if (dims == (adims = a.dimensionality())) {
            if (n != na) {
                throw new IllegalArgumentException(ErrorMessages.incompatibleShapes(this, a));
            }
            for (int i = 0; i < n; ++i) {
                this.slice(i).sub(a.slice(i));
            }
        } else if (adims < dims) {
            for (int i = 0; i < n; ++i) {
                this.slice(i).sub(a);
            }
        } else {
            throw new IllegalArgumentException(ErrorMessages.incompatibleShapes(this, a));
        }
    }

    @Override
    public void negate() {
        this.multiply(-1.0);
    }

    @Override
    public void reciprocal() {
        if (this.dimensionality() == 0) {
            this.set(1.0 / this.get());
        } else {
            int sc = this.sliceCount();
            for (int i = 0; i < sc; ++i) {
                this.slice(i).reciprocal();
            }
        }
    }

    @Override
    public void abs() {
        if (this.dimensionality() == 0) {
            this.set(Math.abs(this.get()));
        } else {
            int sc = this.sliceCount();
            for (int i = 0; i < sc; ++i) {
                this.slice(i).abs();
            }
        }
    }

    @Override
    public void sqrt() {
        if (this.dimensionality() == 0) {
            this.set(Math.sqrt(this.get()));
        } else {
            int sc = this.sliceCount();
            for (int i = 0; i < sc; ++i) {
                this.slice(i).sqrt();
            }
        }
    }

    @Override
    public void log() {
        if (this.dimensionality() == 0) {
            this.set(Math.log(this.get()));
        } else {
            int sc = this.sliceCount();
            for (int i = 0; i < sc; ++i) {
                this.slice(i).log();
            }
        }
    }

    @Override
    public void exp() {
        if (this.dimensionality() == 0) {
            this.set(Math.exp(this.get()));
        } else {
            int sc = this.sliceCount();
            for (int i = 0; i < sc; ++i) {
                this.slice(i).exp();
            }
        }
    }

    @Override
    public void signum() {
        if (this.dimensionality() == 0) {
            this.set(Math.signum(this.get()));
        } else {
            int sc = this.sliceCount();
            for (int i = 0; i < sc; ++i) {
                this.slice(i).signum();
            }
        }
    }

    @Override
    public INDArray reshape(int ... targetShape) {
        return Arrayz.createFromVector(this.asVector(), targetShape);
    }

    public abstract List<T> getSlices();

    @Override
    public List<INDArray> getSliceViews() {
        int l = this.sliceCount();
        ArrayList<INDArray> al = new ArrayList<INDArray>(l);
        for (int i = 0; i < l; ++i) {
            al.add(this.slice(i));
        }
        return al;
    }

    @Override
    public Vector toVector() {
        int n = (int)this.elementCount();
        double[] data = new double[n];
        this.getElements(data, 0);
        return Vector.wrap(data);
    }

    @Override
    public Array toArray() {
        return Array.create(this);
    }

    @Override
    public List<Double> asElementList() {
        return this.asVector().asElementList();
    }

    @Override
    public void getElements(double[] dest, int offset) {
        if (this.dimensionality() == 0) {
            dest[offset] = this.get();
            return;
        }
        int sc = this.sliceCount();
        for (int i = 0; i < sc; ++i) {
            INDArray s = this.slice(i);
            s.getElements(dest, offset);
            offset = (int)((long)offset + s.elementCount());
        }
    }

    @Override
    public void copyTo(double[] arr) {
        this.getElements(arr, 0);
    }

    @Override
    public void toDoubleBuffer(DoubleBuffer dest) {
        int sc = this.sliceCount();
        for (int i = 0; i < sc; ++i) {
            INDArray s = this.slice(i);
            s.toDoubleBuffer(dest);
        }
    }

    @Override
    public double[] toDoubleArray() {
        int n = (int)this.elementCount();
        double[] result = new double[n];
        this.getElements(result, 0);
        return result;
    }

    @Override
    public double[] asDoubleArray() {
        return null;
    }

    @Override
    public INDArray broadcast(int ... targetShape) {
        int tdims = targetShape.length;
        int dims = this.dimensionality();
        if (tdims < dims) {
            throw new IllegalArgumentException(ErrorMessages.incompatibleBroadcast(this, targetShape));
        }
        if (dims == tdims) {
            if (IntArrays.equals(targetShape, this.getShape())) {
                return this;
            }
            throw new IllegalArgumentException(ErrorMessages.incompatibleBroadcast(this, targetShape));
        }
        int n = targetShape[0];
        INDArray s = this.broadcast(Arrays.copyOfRange(targetShape, 1, tdims));
        return SliceArray.repeat(s, n);
    }

    @Override
    public INDArray broadcastLike(INDArray target) {
        return this.broadcast(target.getShape());
    }

    @Override
    public void validate() {
    }
}

