/*
 * Decompiled with CFR 0.152.
 */
package mikera.vectorz.impl;

import mikera.arrayz.impl.IStridedArray;
import mikera.vectorz.AVector;
import mikera.vectorz.Vector;
import mikera.vectorz.util.ErrorMessages;

public abstract class AStridedVector
extends AVector
implements IStridedArray {
    private static final long serialVersionUID = -7239429584755803950L;

    @Override
    public abstract double[] getArray();

    @Override
    public abstract int getArrayOffset();

    public abstract int getStride();

    @Override
    public AStridedVector ensureMutable() {
        return this.clone();
    }

    @Override
    public double dotProduct(double[] data, int offset) {
        double[] array = this.getArray();
        int thisOffset = this.getArrayOffset();
        int stride = this.getStride();
        int length = this.length();
        double result = 0.0;
        for (int i = 0; i < length; ++i) {
            result += array[i * stride + thisOffset] * data[i + offset];
        }
        return result;
    }

    @Override
    public AStridedVector clone() {
        return Vector.create(this);
    }

    public void add(Vector v) {
        int length = this.length();
        if (length != v.length()) {
            throw new IllegalArgumentException("Mismatched vector sizes");
        }
        for (int i = 0; i < length; ++i) {
            this.addAt(i, v.data[i]);
        }
    }

    @Override
    public int[] getStrides() {
        return new int[]{this.getStride()};
    }

    @Override
    public int getStride(int dimension) {
        switch (dimension) {
            case 0: {
                return this.getStride();
            }
        }
        throw new IllegalArgumentException(ErrorMessages.invalidDimension(this, dimension));
    }
}

