/*
 * Decompiled with CFR 0.152.
 */
package mikera.matrixx;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mikera.indexz.Index;
import mikera.matrixx.AMatrix;
import mikera.matrixx.IMatrix;
import mikera.matrixx.Matrix;
import mikera.matrixx.Matrix22;
import mikera.matrixx.Matrix33;
import mikera.matrixx.impl.ADiagonalMatrix;
import mikera.matrixx.impl.ColumnMatrix;
import mikera.matrixx.impl.DiagonalMatrix;
import mikera.matrixx.impl.IdentityMatrix;
import mikera.matrixx.impl.ScalarMatrix;
import mikera.matrixx.impl.VectorMatrixMN;
import mikera.matrixx.impl.ZeroMatrix;
import mikera.util.Rand;
import mikera.vectorz.AVector;
import mikera.vectorz.Tools;
import mikera.vectorz.Vector3;
import mikera.vectorz.Vectorz;
import mikera.vectorz.impl.SparseIndexedVector;
import mikera.vectorz.util.VectorzException;
import us.bpsm.edn.parser.Parseable;
import us.bpsm.edn.parser.Parser;
import us.bpsm.edn.parser.Parsers;

public class Matrixx {
    public static AMatrix createIdentityMatrix(int dimensions) {
        AMatrix m = Matrixx.newMatrix(dimensions, dimensions);
        for (int i = 0; i < dimensions; ++i) {
            m.set(i, i, 1.0);
        }
        return m;
    }

    public static IdentityMatrix createImmutableIdentityMatrix(int dimensions) {
        return IdentityMatrix.create(dimensions);
    }

    public static AMatrix toMatrix(Object o) {
        if (o instanceof AMatrix) {
            return (AMatrix)o;
        }
        if (o instanceof AVector) {
            return ColumnMatrix.wrap((AVector)o);
        }
        if (o instanceof Iterable) {
            ArrayList<AVector> al = new ArrayList<AVector>();
            for (Object obj : (Iterable)o) {
                al.add(Vectorz.toVector(obj));
            }
            return Matrixx.createFromVectors(al);
        }
        throw new UnsupportedOperationException("Can't convert to matrix: " + o.getClass());
    }

    public static AMatrix createSparse(AMatrix m) {
        int rc = m.rowCount();
        AVector[] rows = new AVector[rc];
        for (int i = 0; i < rc; ++i) {
            rows[i] = SparseIndexedVector.createFromRow(m, i);
        }
        return VectorMatrixMN.wrap(rows);
    }

    public static ZeroMatrix createImmutableZeroMatrix(int rows, int columns) {
        return ZeroMatrix.create(rows, columns);
    }

    public static ADiagonalMatrix createScaleMatrix(int dimensions, double factor) {
        DiagonalMatrix im = new DiagonalMatrix(dimensions);
        for (int i = 0; i < dimensions; ++i) {
            im.set(i, i, factor);
        }
        return im;
    }

    public static ADiagonalMatrix createScalarMatrix(int dimensions, double factor) {
        return (ADiagonalMatrix)ScalarMatrix.create(dimensions, factor);
    }

    public static DiagonalMatrix createScaleMatrix(double ... scalingFactors) {
        int dimensions = scalingFactors.length;
        DiagonalMatrix im = new DiagonalMatrix(dimensions);
        for (int i = 0; i < dimensions; ++i) {
            im.set(i, i, scalingFactors[i]);
        }
        return im;
    }

    public static Matrix33 createRotationMatrix(Vector3 axis, double angle) {
        return Matrixx.createRotationMatrix(axis.x, axis.y, axis.z, angle);
    }

    public static Matrix33 createRotationMatrix(double x, double y, double z, double angle) {
        double d = Math.sqrt(x * x + y * y + z * z);
        double u = x / d;
        double v = y / d;
        double w = z / d;
        double ca = Math.cos(angle);
        double sa = Math.sin(angle);
        return new Matrix33(u * u + (1.0 - u * u) * ca, u * v * (1.0 - ca) - w * sa, u * w * (1.0 - ca) + v * sa, u * v * (1.0 - ca) + w * sa, v * v + (1.0 - v * v) * ca, v * w * (1.0 - ca) - u * sa, u * w * (1.0 - ca) - v * sa, v * w * (1.0 - ca) + u * sa, w * w + (1.0 - w * w) * ca);
    }

    public static Matrix33 createRotationMatrix(AVector v, double angle) {
        if (v.length() != 3) {
            throw new VectorzException("Rotation matrix requires a 3d axis vector");
        }
        return Matrixx.createRotationMatrix(v.unsafeGet(0), v.unsafeGet(1), v.unsafeGet(2), angle);
    }

    public static Matrix33 createXAxisRotationMatrix(double angle) {
        return Matrixx.createRotationMatrix(1.0, 0.0, 0.0, angle);
    }

    public static Matrix33 createYAxisRotationMatrix(double angle) {
        return Matrixx.createRotationMatrix(0.0, 1.0, 0.0, angle);
    }

    public static Matrix33 createZAxisRotationMatrix(double angle) {
        return Matrixx.createRotationMatrix(0.0, 0.0, 1.0, angle);
    }

    public static Matrix22 create2DRotationMatrix(double angle) {
        return Matrix22.createRotationMatrix(angle);
    }

    public static Matrix createRandomSquareMatrix(int dimensions) {
        Matrix m = Matrixx.createSquareMatrix(dimensions);
        Matrixx.fillRandomValues(m);
        return m;
    }

    public static AMatrix createRandomMatrix(int rows, int columns) {
        AMatrix m = Matrixx.newMatrix(rows, columns);
        Matrixx.fillRandomValues(m);
        return m;
    }

    static Matrix createInverse(AMatrix m) {
        if (!m.isSquare()) {
            throw new IllegalArgumentException("Matrix must be square for inverse!");
        }
        int dims = m.rowCount();
        Matrix am = new Matrix(m);
        int[] rowPermutations = new int[dims];
        Matrixx.decomposeLU(am, rowPermutations);
        return Matrixx.backSubstituteLU(am, rowPermutations);
    }

    private static void decomposeLU(Matrix am, int[] permutations) {
        int dims = permutations.length;
        double[] data = am.data;
        double[] rowFactors = new double[dims];
        Matrixx.calcRowFactors(data, rowFactors);
        for (int col = 0; col < dims; ++col) {
            for (int row = 0; row < col; ++row) {
                int dataIndex = dims * row + col;
                double acc = data[dataIndex];
                for (int i = 0; i < row; ++i) {
                    acc -= data[dims * row + i] * data[dims * i + col];
                }
                data[dataIndex] = acc;
            }
            int maxIndex = 0;
            double maxValue = Double.NEGATIVE_INFINITY;
            for (int row = col; row < dims; ++row) {
                int dataIndex = dims * row + col;
                double acc = data[dataIndex];
                for (int i = 0; i < col; ++i) {
                    acc -= data[dims * row + i] * data[dims * i + col];
                }
                data[dataIndex] = acc;
                double value = rowFactors[row] * Math.abs(acc);
                if (!(value > maxValue)) continue;
                maxValue = value;
                maxIndex = row;
            }
            if (col != maxIndex) {
                am.swapRows(col, maxIndex);
                rowFactors[maxIndex] = rowFactors[col];
            }
            permutations[col] = maxIndex;
            if (data[dims * col + col] == 0.0) {
                throw new VectorzException("Matrix is singular, cannot compute inverse!");
            }
            double diagonalValue = data[dims * col + col];
            double factor = 1.0 / diagonalValue;
            int offset = dims * (col + 1) + col;
            for (int i = 0; i < dims - 1 - col; ++i) {
                int n = dims * i + offset;
                data[n] = data[n] * factor;
            }
        }
    }

    private static void calcRowFactors(double[] data, double[] factorsOut) {
        int dims = factorsOut.length;
        for (int row = 0; row < dims; ++row) {
            double maxValue = 0.0;
            for (int col = 0; col < dims; ++col) {
                maxValue = Math.max(maxValue, Math.abs(data[row * dims + col]));
            }
            if (maxValue == 0.0) {
                throw new VectorzException("Matrix is singular!");
            }
            factorsOut[row] = 1.0 / maxValue;
        }
    }

    private static Matrix backSubstituteLU(Matrix am, int[] permutations) {
        int dims = permutations.length;
        double[] dataIn = am.data;
        Matrix result = new Matrix(Matrixx.createImmutableIdentityMatrix(dims));
        double[] dataOut = result.data;
        for (int col = 0; col < dims; ++col) {
            int row;
            int rowIndex = -1;
            for (row = 0; row < dims; ++row) {
                int pRow = permutations[row];
                double acc = dataOut[dims * pRow + col];
                dataOut[dims * pRow + col] = dataOut[dims * row + col];
                if (rowIndex >= 0) {
                    for (int i = rowIndex; i <= row - 1; ++i) {
                        acc -= dataIn[row * dims + i] * dataOut[dims * i + col];
                    }
                } else if (acc != 0.0) {
                    rowIndex = row;
                }
                dataOut[dims * row + col] = acc;
            }
            for (row = 0; row < dims; ++row) {
                int irow = dims - 1 - row;
                int offset = dims * irow;
                double total = 0.0;
                for (int i = 0; i < row; ++i) {
                    total += dataIn[offset + (dims - 1 - i)] * dataOut[dims * (dims - 1 - i) + col];
                }
                double diagonalValue = dataIn[offset + irow];
                dataOut[dims * irow + col] = (dataOut[dims * irow + col] - total) / diagonalValue;
            }
        }
        return result;
    }

    public static AMatrix newMatrix(int rows, int columns) {
        if (rows == 2 && columns == 2) {
            return new Matrix22();
        }
        if (rows == 3 && columns == 3) {
            return new Matrix33();
        }
        return Matrix.create(rows, columns);
    }

    public static Matrix createFromVector(AVector data, int rows, int columns) {
        Matrix m = Matrix.create(rows, columns);
        int n = Math.min(rows * columns, data.length());
        data.copyTo(0, m.data, 0, n);
        return m;
    }

    private static Matrix createSquareMatrix(int dimensions) {
        return Matrix.create(dimensions, dimensions);
    }

    public static Matrix create(AMatrix m) {
        return new Matrix(m);
    }

    public static Matrix create(List<Object> rows) {
        int rc = rows.size();
        AVector firstRow = Vectorz.create(rows.get(0));
        int cc = firstRow.length();
        Matrix m = Matrix.create(rc, cc);
        m.setRow(0, firstRow);
        for (int i = 1; i < rc; ++i) {
            m.setRow(i, Vectorz.create(rows.get(i)));
        }
        return m;
    }

    public static AMatrix create(IMatrix m) {
        int rows = m.rowCount();
        int columns = m.columnCount();
        AMatrix result = Matrixx.newMatrix(rows, columns);
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                result.set(i, j, m.get(i, j));
            }
        }
        return result;
    }

    public static void fillRandomValues(AMatrix m) {
        int rows = m.rowCount();
        int columns = m.columnCount();
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                m.unsafeSet(i, j, Rand.nextDouble());
            }
        }
    }

    public static AMatrix createFromVectors(AVector ... data) {
        int rc = data.length;
        int cc = rc == 0 ? 0 : data[0].length();
        AMatrix m = Matrixx.newMatrix(rc, cc);
        for (int i = 0; i < rc; ++i) {
            m.getRow(i).set(data[i]);
        }
        return m;
    }

    public static AMatrix createFromVectors(List<AVector> data) {
        int rc = data.size();
        int cc = rc == 0 ? 0 : data.get(0).length();
        AMatrix m = Matrixx.newMatrix(rc, cc);
        for (int i = 0; i < rc; ++i) {
            m.getRow(i).set(data.get(i));
        }
        return m;
    }

    private static Parser.Config getMatrixParserConfig() {
        return Parsers.defaultConfiguration();
    }

    public static AMatrix parse(String ednString) {
        Parseable ps;
        Parser p = Parsers.newParser((Parser.Config)Matrixx.getMatrixParserConfig());
        List data = (List)p.nextValue(ps = Parsers.newParseable((CharSequence)ednString));
        int rc = data.size();
        int cc = rc == 0 ? 0 : ((List)data.get(0)).size();
        AMatrix m = Matrixx.newMatrix(rc, cc);
        for (int i = 0; i < rc; ++i) {
            for (int j = 0; j < cc; ++j) {
                m.set(i, j, Tools.toDouble(((List)data.get(i)).get(j)));
            }
        }
        return m;
    }

    public static Matrix deepCopy(AMatrix m) {
        return Matrixx.create(m);
    }

    public static AMatrix createSparse(int inputDims, Index[] indexes, AVector[] weights) {
        int len = indexes.length;
        if (len != weights.length) {
            throw new VectorzException("Length mismatch!" + len + " vs. " + weights.length);
        }
        AVector[] svs = new AVector[len];
        for (int i = 0; i < len; ++i) {
            svs[i] = SparseIndexedVector.create(inputDims, indexes[i], weights[i]);
        }
        return VectorMatrixMN.wrap(svs);
    }

    public static AMatrix create(Object ... vs) {
        return Matrixx.create(Arrays.asList(vs));
    }

    public static Matrix create(double[][] data) {
        int rows = data.length;
        int cols = data[0].length;
        Matrix m = Matrix.create(rows, cols);
        for (int i = 0; i < rows; ++i) {
            double[] ds = data[i];
            if (ds.length != cols) {
                throw new IllegalArgumentException("Array shape is not rectangular!");
            }
            System.arraycopy(ds, 0, m.data, i * cols, cols);
        }
        return m;
    }
}

