/*
 * Decompiled with CFR 0.152.
 */
package mikera.matrixx.impl;

import java.util.Arrays;
import java.util.List;
import mikera.matrixx.AMatrix;
import mikera.matrixx.impl.AVectorMatrix;
import mikera.vectorz.AVector;
import mikera.vectorz.Op;
import mikera.vectorz.Vectorz;

public final class VectorMatrixMN
extends AVectorMatrix<AVector> {
    private int rowCount;
    private final int columnCount;
    private AVector[] rows;

    public VectorMatrixMN(int rowCount, int columnCount) {
        this.rows = new AVector[rowCount];
        this.rowCount = rowCount;
        this.columnCount = columnCount;
        for (int i = 0; i < rowCount; ++i) {
            this.rows[i] = Vectorz.newVector(columnCount);
        }
    }

    private VectorMatrixMN(AVector[] rows, int rowCount, int columnCount) {
        if (rows.length < rowCount) {
            throw new IllegalArgumentException("Insufficient rows provided!");
        }
        this.rows = rows;
        this.rowCount = rowCount;
        this.columnCount = columnCount;
    }

    public static VectorMatrixMN create(List<Object> rows) {
        int rc = rows.size();
        AVector[] vs = new AVector[rc];
        for (int i = 0; i < rc; ++i) {
            vs[i] = Vectorz.create(rows.get(i));
        }
        return VectorMatrixMN.wrap(vs);
    }

    public static VectorMatrixMN create(Object ... vs) {
        return VectorMatrixMN.create(Arrays.asList(vs));
    }

    public static VectorMatrixMN wrap(AVector[] rows) {
        int rc = rows.length;
        int cc = rc == 0 ? 0 : rows[0].length();
        return new VectorMatrixMN(rows, rc, cc);
    }

    @Override
    public void multiply(double factor) {
        for (int i = 0; i < this.rowCount; ++i) {
            this.rows[i].scale(factor);
        }
    }

    @Override
    public void applyOp(Op op) {
        for (int i = 0; i < this.rowCount; ++i) {
            this.rows[i].applyOp(op);
        }
    }

    public VectorMatrixMN(AMatrix source) {
        this(source.rowCount(), source.columnCount());
        for (int i = 0; i < this.rowCount; ++i) {
            for (int j = 0; j < this.columnCount; ++j) {
                this.set(i, j, source.get(i, j));
            }
        }
    }

    private void ensureRowCapacity(int size) {
        if (size <= this.rows.length) {
            return;
        }
        int newSize = Math.max(size, this.rows.length * 2);
        AVector[] newRows = new AVector[newSize];
        System.arraycopy(this.rows, 0, newRows, 0, this.rowCount);
        this.rows = newRows;
    }

    @Override
    public void appendRow(AVector row) {
        this.ensureRowCapacity(this.rowCount + 1);
        this.rows[this.rowCount++] = row;
    }

    @Override
    public void swapRows(int i, int j) {
        if (i != j) {
            AVector t = this.rows[i];
            this.rows[i] = this.rows[j];
            this.rows[j] = t;
        }
    }

    @Override
    public AVector getRow(int row) {
        assert (row < this.rowCount);
        return this.rows[row];
    }

    @Override
    public int rowCount() {
        return this.rowCount;
    }

    @Override
    public int columnCount() {
        return this.columnCount;
    }

    @Override
    public double get(int row, int column) {
        assert (row < this.rowCount);
        return this.rows[row].get(column);
    }

    @Override
    public void set(int row, int column, double value) {
        assert (row < this.rowCount);
        this.rows[row].set(column, value);
    }

    @Override
    public void transform(AVector source, AVector dest) {
        for (int i = 0; i < this.rowCount; ++i) {
            dest.set(i, this.getRow(i).dotProduct(source));
        }
    }

    @Override
    public double calculateElement(int i, AVector inputVector) {
        assert (i < this.rowCount);
        AVector row = this.rows[i];
        return row.dotProduct(inputVector);
    }

    @Override
    public boolean isSquare() {
        return this.rowCount == this.columnCount;
    }

    @Override
    public VectorMatrixMN clone() {
        AVector[] newRows = (AVector[])this.rows.clone();
        for (int i = 0; i < this.rowCount; ++i) {
            newRows[i] = newRows[i].clone();
        }
        return new VectorMatrixMN(newRows, this.rowCount, this.columnCount);
    }

    @Override
    public VectorMatrixMN exactClone() {
        AVector[] newRows = (AVector[])this.rows.clone();
        for (int i = 0; i < this.rowCount; ++i) {
            newRows[i] = newRows[i].exactClone();
        }
        return new VectorMatrixMN(newRows, this.rowCount, this.columnCount);
    }
}

