/*
 * Decompiled with CFR 0.152.
 */
package mikera.matrixx;

import java.nio.DoubleBuffer;
import java.util.Arrays;
import mikera.matrixx.AMatrix;
import mikera.matrixx.impl.ArrayMatrix;
import mikera.matrixx.impl.StridedMatrix;
import mikera.matrixx.impl.VectorMatrixMN;
import mikera.vectorz.AVector;
import mikera.vectorz.Op;
import mikera.vectorz.Vector;
import mikera.vectorz.impl.ArraySubVector;
import mikera.vectorz.impl.StridedVector;
import mikera.vectorz.util.DoubleArrays;
import mikera.vectorz.util.VectorzException;

public final class Matrix
extends ArrayMatrix {
    public Matrix(int rowCount, int columnCount) {
        this(rowCount, columnCount, new double[rowCount * columnCount]);
    }

    public static Matrix create(int rowCount, int columnCount) {
        return new Matrix(rowCount, columnCount);
    }

    public static Matrix create(AMatrix m) {
        Matrix nm = new Matrix(m.rowCount(), m.columnCount());
        nm.set(m);
        return nm;
    }

    public Matrix(AMatrix m) {
        this(m.rowCount(), m.columnCount());
        this.set(m);
    }

    public Matrix create(Object ... rowVectors) {
        VectorMatrixMN m = VectorMatrixMN.create(rowVectors);
        Matrix r = new Matrix(((AMatrix)m).rowCount(), ((AMatrix)m).columnCount(), new double[this.rows * this.cols]);
        r.set(m);
        return r;
    }

    @Override
    public boolean isView() {
        return false;
    }

    @Override
    public boolean isPackedArray() {
        return true;
    }

    private Matrix(int rowCount, int columnCount, double[] data) {
        super(data, rowCount, columnCount);
    }

    public static Matrix wrap(int rowCount, int columnCount, double[] data) {
        if (data.length != rowCount * columnCount) {
            throw new VectorzException("data array is of wrong size: " + data.length);
        }
        return new Matrix(rowCount, columnCount, data);
    }

    @Override
    public AVector innerProduct(AVector a) {
        if (a instanceof Vector) {
            return this.innerProduct((Vector)a);
        }
        return super.innerProduct(a);
    }

    public Vector innerProduct(Vector a) {
        int rc = this.rowCount();
        int cc = this.columnCount();
        if (cc != a.length()) {
            throw new VectorzException("Matrix sizes not compatible!");
        }
        Vector result = Vector.createLength(this.rows);
        for (int i = 0; i < rc; ++i) {
            int di = i * cc;
            double acc = 0.0;
            for (int j = 0; j < cc; ++j) {
                acc += this.data[di + j] * a.data[j];
            }
            result.set(i, acc);
        }
        return result;
    }

    @Override
    public Matrix innerProduct(Matrix a) {
        if (this.columnCount() != a.rowCount()) {
            throw new VectorzException("Matrix sizes not compatible!");
        }
        int rc = this.rowCount();
        int cc = a.columnCount();
        int ic = this.columnCount();
        Matrix result = Matrix.create(rc, cc);
        for (int i = 0; i < rc; ++i) {
            for (int j = 0; j < cc; ++j) {
                double acc = 0.0;
                for (int k = 0; k < ic; ++k) {
                    acc += this.get(i, k) * a.get(k, j);
                }
                result.set(i, j, acc);
            }
        }
        return result;
    }

    @Override
    public Matrix innerProduct(AMatrix a) {
        if (a instanceof Matrix) {
            return this.innerProduct((Matrix)a);
        }
        if (this.columnCount() != a.rowCount()) {
            throw new VectorzException("Matrix sizes not compatible!");
        }
        int rc = this.rowCount();
        int cc = a.columnCount();
        int ic = this.columnCount();
        Matrix result = Matrix.create(rc, cc);
        for (int i = 0; i < rc; ++i) {
            for (int j = 0; j < cc; ++j) {
                double acc = 0.0;
                for (int k = 0; k < ic; ++k) {
                    acc += this.get(i, k) * a.get(k, j);
                }
                result.set(i, j, acc);
            }
        }
        return result;
    }

    @Override
    public double elementSum() {
        return DoubleArrays.elementSum(this.data, 0, this.data.length);
    }

    @Override
    public long nonZeroCount() {
        return DoubleArrays.nonZeroCount(this.data, 0, this.data.length);
    }

    @Override
    public Matrix clone() {
        return new Matrix(this.rows, this.cols, (double[])this.data.clone());
    }

    @Override
    public void transform(AVector source, AVector dest) {
        assert (this.rowCount() == dest.length());
        assert (this.columnCount() == source.length());
        int index = 0;
        for (int i = 0; i < this.rows; ++i) {
            double acc = 0.0;
            for (int j = 0; j < this.cols; ++j) {
                acc += this.data[index++] * source.get(j);
            }
            dest.set(i, acc);
        }
    }

    @Override
    public ArraySubVector getRow(int row) {
        return ArraySubVector.wrap(this.data, row * this.cols, this.cols);
    }

    @Override
    public StridedVector getColumn(int row) {
        return StridedVector.wrap(this.data, row, this.rows, this.cols);
    }

    @Override
    public int rowCount() {
        return this.rows;
    }

    @Override
    public int columnCount() {
        return this.cols;
    }

    @Override
    public void swapRows(int i, int j) {
        if (i == j) {
            return;
        }
        int a = i * this.cols;
        int b = j * this.cols;
        int cc = this.columnCount();
        for (int k = 0; k < cc; ++k) {
            double t = this.data[a + k];
            this.data[a + k] = this.data[b + k];
            this.data[b + k] = t;
        }
    }

    @Override
    public void swapColumns(int i, int j) {
        if (i == j) {
            return;
        }
        int rc = this.rowCount();
        int cc = this.columnCount();
        for (int k = 0; k < rc; ++k) {
            int x = k * cc;
            double t = this.data[i + x];
            this.data[i + x] = this.data[j + x];
            this.data[j + x] = t;
        }
    }

    @Override
    public void multiplyRow(int i, double factor) {
        int offset = i * this.cols;
        for (int j = 0; j < this.cols; ++j) {
            int n = offset + j;
            this.data[n] = this.data[n] * factor;
        }
    }

    @Override
    public void addRowMultiple(int src, int dst, double factor) {
        int soffset = src * this.cols;
        int doffset = dst * this.cols;
        for (int j = 0; j < this.cols; ++j) {
            int n = doffset + j;
            this.data[n] = this.data[n] + factor * this.data[soffset + j];
        }
    }

    @Override
    public Vector asVector() {
        return Vector.wrap(this.data);
    }

    @Override
    public void toDoubleBuffer(DoubleBuffer dest) {
        dest.put(this.data, 0, this.data.length);
    }

    @Override
    public double get(int row, int column) {
        return this.data[row * this.cols + column];
    }

    @Override
    public void set(int row, int column, double value) {
        this.data[row * this.cols + column] = value;
    }

    @Override
    public void applyOp(Op op) {
        op.applyTo(this.data);
    }

    public void addMultiple(Matrix m, double factor) {
        assert (this.rowCount() == m.rowCount());
        assert (this.columnCount() == m.columnCount());
        for (int i = 0; i < this.data.length; ++i) {
            int n = i;
            this.data[n] = this.data[n] + m.data[i] * factor;
        }
    }

    public void add(Matrix m) {
        assert (this.rowCount() == m.rowCount());
        assert (this.columnCount() == m.columnCount());
        for (int i = 0; i < this.data.length; ++i) {
            int n = i;
            this.data[n] = this.data[n] + m.data[i];
        }
    }

    @Override
    public void addMultiple(AMatrix m, double factor) {
        if (m instanceof Matrix) {
            this.addMultiple((Matrix)m, factor);
            return;
        }
        int rc = this.rowCount();
        int cc = this.columnCount();
        assert (rc == m.rowCount());
        assert (cc == m.columnCount());
        int di = 0;
        for (int i = 0; i < rc; ++i) {
            for (int j = 0; j < cc; ++j) {
                int n = di++;
                this.data[n] = this.data[n] + m.get(i, j) * factor;
            }
        }
    }

    @Override
    public void add(AMatrix m) {
        if (m instanceof Matrix) {
            this.add((Matrix)m);
            return;
        }
        int rc = this.rowCount();
        int cc = this.columnCount();
        assert (rc == m.rowCount());
        assert (cc == m.columnCount());
        int di = 0;
        for (int i = 0; i < rc; ++i) {
            for (int j = 0; j < cc; ++j) {
                int n = di++;
                this.data[n] = this.data[n] + m.get(i, j);
            }
        }
    }

    @Override
    public void multiply(double factor) {
        int i = 0;
        while (i < this.data.length) {
            int n = i++;
            this.data[n] = this.data[n] * factor;
        }
    }

    @Override
    public void set(AMatrix a) {
        int rc = this.rowCount();
        if (rc != a.rowCount()) {
            throw new IllegalArgumentException("Non-matching row count");
        }
        int cc = this.columnCount();
        if (cc != a.columnCount()) {
            throw new IllegalArgumentException("Non-matching column count");
        }
        a.getElements(this.data, 0);
    }

    @Override
    public void getElements(double[] dest, int offset) {
        System.arraycopy(this.data, 0, dest, offset, this.data.length);
    }

    @Override
    public StridedMatrix getTranspose() {
        return StridedMatrix.wrap(this.data, this.cols, this.rows, 0, 1, this.cols);
    }

    @Override
    public StridedMatrix getTransposeView() {
        return StridedMatrix.wrap(this.data, this.cols, this.rows, 0, 1, this.cols);
    }

    @Override
    public void set(double value) {
        Arrays.fill(this.data, value);
    }

    @Override
    public void reciprocal() {
        DoubleArrays.reciprocal(this.data, 0, this.data.length);
    }

    @Override
    public void clamp(double min, double max) {
        DoubleArrays.clamp(this.data, 0, this.data.length, min, max);
    }

    @Override
    public Matrix exactClone() {
        return new Matrix(this);
    }

    @Override
    public void setRow(int i, AVector row) {
        int cc = this.columnCount();
        if (row.length() != cc) {
            throw new IllegalArgumentException("Row has wrong length: " + row.length());
        }
        row.getElements(this.data, i * cc);
    }

    @Override
    public void setColumn(int j, AVector col) {
        int rc = this.rowCount();
        if (col.length() != rc) {
            throw new IllegalArgumentException("Column has wrong length: " + col.length());
        }
        for (int i = 0; i < rc; ++i) {
            this.data[i * this.cols + j] = col.get(j);
        }
    }
}

