/*
 * Decompiled with CFR 0.152.
 */
package mikera.vectorz.impl;

import java.util.Arrays;
import mikera.randomz.Hash;
import mikera.vectorz.AVector;
import mikera.vectorz.ArrayVector;
import mikera.vectorz.Vectorz;

public final class ArraySubVector
extends ArrayVector {
    private static final long serialVersionUID = 1262951505515197105L;
    private final double[] data;
    private final int offset;
    private final int length;

    public static ArraySubVector wrap(double[] values) {
        return new ArraySubVector(values);
    }

    private ArraySubVector(double[] values) {
        this(values, 0, values.length);
    }

    private ArraySubVector(double[] data, int offset, int length) {
        this.data = data;
        this.offset = offset;
        this.length = length;
    }

    public ArraySubVector(int length) {
        this.length = length;
        this.offset = 0;
        this.data = new double[length];
    }

    public ArraySubVector(ArraySubVector source) {
        this.length = source.length;
        this.offset = 0;
        this.data = new double[this.length];
        System.arraycopy(source.data, source.offset, this.data, 0, this.length);
    }

    public static ArraySubVector wrap(double[] data, int offset, int length) {
        return new ArraySubVector(data, offset, length);
    }

    public ArraySubVector(ArrayVector source, int offset, int length) {
        int len = source.length();
        if (offset < 0) {
            throw new IndexOutOfBoundsException("Negative offset for Vector: " + offset);
        }
        if (offset + length > len) {
            throw new IndexOutOfBoundsException("Beyond bounds of parent vector with offset: " + offset + " and length: " + length);
        }
        this.length = length;
        this.offset = source.getArrayOffset() + offset;
        this.data = source.getArray();
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public double get(int i) {
        if (i < 0 || i >= this.length) {
            throw new IndexOutOfBoundsException("Index: " + i);
        }
        return this.data[this.offset + i];
    }

    @Override
    public void set(int i, double value) {
        if (i < 0 || i >= this.length) {
            throw new IndexOutOfBoundsException("Index: " + i);
        }
        this.data[this.offset + i] = value;
    }

    @Override
    public void add(ArrayVector v) {
        int vlength = v.length();
        if (vlength != this.length) {
            throw new Error("Source vector has different size: " + vlength);
        }
        double[] vdata = v.getArray();
        int voffset = v.getArrayOffset();
        for (int i = 0; i < this.length; ++i) {
            int n = this.offset + i;
            this.data[n] = this.data[n] + vdata[voffset + i];
        }
    }

    @Override
    public void addMultiple(ArrayVector v, double factor) {
        assert (v.length() == this.length);
        double[] vdata = v.getArray();
        int voffset = v.getArrayOffset();
        for (int i = 0; i < this.length; ++i) {
            int n = this.offset + i;
            this.data[n] = this.data[n] + vdata[voffset + i] * factor;
        }
    }

    @Override
    public void addAt(int i, double v) {
        assert (i >= 0 && i < this.length);
        int n = i + this.offset;
        this.data[n] = this.data[n] + v;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        for (int i = 0; i < this.length; ++i) {
            hashCode = 31 * hashCode + Hash.hashCode((double)this.data[this.offset + i]);
        }
        return hashCode;
    }

    @Override
    public double[] getArray() {
        return this.data;
    }

    @Override
    public int getArrayOffset() {
        return this.offset;
    }

    @Override
    public boolean isView() {
        return true;
    }

    @Override
    public AVector clone() {
        return Vectorz.create(this);
    }

    @Override
    public ArraySubVector exactClone() {
        return new ArraySubVector(Arrays.copyOfRange(this.data, this.offset, this.offset + this.length), 0, this.length);
    }
}

