/*
 * Decompiled with CFR 0.152.
 */
package mikera.matrixx;

import java.nio.DoubleBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import mikera.arrayz.Arrayz;
import mikera.arrayz.INDArray;
import mikera.arrayz.SliceArray;
import mikera.matrixx.IMatrix;
import mikera.matrixx.Matrix;
import mikera.matrixx.Matrixx;
import mikera.matrixx.impl.MatrixIterator;
import mikera.matrixx.impl.MatrixSubVector;
import mikera.matrixx.impl.TransposedMatrix;
import mikera.matrixx.impl.VectorMatrixMN;
import mikera.randomz.Hash;
import mikera.transformz.AAffineTransform;
import mikera.transformz.ALinearTransform;
import mikera.transformz.ATransform;
import mikera.transformz.AffineMN;
import mikera.vectorz.AScalar;
import mikera.vectorz.AVector;
import mikera.vectorz.ArrayVector;
import mikera.vectorz.IOp;
import mikera.vectorz.Op;
import mikera.vectorz.Tools;
import mikera.vectorz.Vectorz;
import mikera.vectorz.impl.Vector0;
import mikera.vectorz.util.VectorzException;

public abstract class AMatrix
extends ALinearTransform
implements IMatrix,
Iterable<AVector> {
    @Override
    public abstract int rowCount();

    @Override
    public abstract int columnCount();

    @Override
    public abstract double get(int var1, int var2);

    @Override
    public abstract void set(int var1, int var2, double var3);

    @Override
    public double get(int row) {
        throw new VectorzException("1D get not supported on matrix!");
    }

    @Override
    public double get() {
        throw new VectorzException("0D get not supported on matrix!");
    }

    @Override
    public void set(int row, double value) {
        throw new VectorzException("1D get not supported on matrix!");
    }

    @Override
    public void set(double value) {
        this.asVector().fill(value);
    }

    @Override
    public void set(int[] indexes, double value) {
        if (indexes.length != 2) {
            throw new VectorzException("" + indexes.length + "D set not supported on AMatrix");
        }
        this.set(indexes[0], indexes[1], value);
    }

    @Override
    public int dimensionality() {
        return 2;
    }

    @Override
    public long elementCount() {
        return this.rowCount() * this.columnCount();
    }

    @Override
    public AVector slice(int rowNumber) {
        return this.getRow(rowNumber);
    }

    @Override
    public INDArray slice(int dimension, int index) {
        if (dimension < 0 || dimension >= 2) {
            throw new IllegalArgumentException("Dimension out of range!");
        }
        return dimension == 0 ? this.getRow(index) : this.getColumn(index);
    }

    @Override
    public int sliceCount() {
        return this.rowCount();
    }

    public List<AVector> getSlices() {
        ArrayList<AVector> al = new ArrayList<AVector>();
        int rc = this.rowCount();
        for (int i = 0; i < rc; ++i) {
            al.add(this.getRow(i));
        }
        return al;
    }

    @Override
    public List<INDArray> getSliceViews() {
        ArrayList<INDArray> al = new ArrayList<INDArray>();
        int rc = this.rowCount();
        for (int i = 0; i < rc; ++i) {
            al.add(this.getRow(i));
        }
        return al;
    }

    @Override
    public int[] getShape() {
        return new int[]{this.rowCount(), this.columnCount()};
    }

    @Override
    public int getShape(int dim) {
        if (dim == 0) {
            return this.rowCount();
        }
        if (dim == 1) {
            return this.columnCount();
        }
        throw new IndexOutOfBoundsException("Matrix does not have dimension: " + dim);
    }

    @Override
    public long[] getLongShape() {
        return new long[]{this.rowCount(), this.columnCount()};
    }

    @Override
    public double get(int ... indexes) {
        assert (indexes.length == 2);
        return this.get(indexes[0], indexes[1]);
    }

    public AVector getLeadingDiagonal() {
        if (!this.isSquare()) {
            throw new UnsupportedOperationException("Not a square matrix!");
        }
        int dims = this.rowCount();
        AVector v = Vectorz.newVector(dims);
        for (int i = 0; i < dims; ++i) {
            v.set(i, this.get(i, i));
        }
        return v;
    }

    @Override
    public double calculateElement(int i, AVector v) {
        return this.getRow(i).dotProduct(v);
    }

    @Override
    public AAffineTransform toAffineTransform() {
        return new AffineMN((AMatrix)new VectorMatrixMN(this), this.getTranslationComponent());
    }

    @Override
    public AMatrix getMatrixComponent() {
        return this;
    }

    @Override
    public boolean isIdentity() {
        int rc = this.rowCount();
        int cc = this.columnCount();
        for (int i = 0; i < rc; ++i) {
            for (int j = 0; j < cc; ++j) {
                double expected;
                double d = expected = i == j ? 1.0 : 0.0;
                if (this.get(i, j) == expected) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isSquare() {
        return this.rowCount() == this.columnCount();
    }

    @Override
    public int inputDimensions() {
        return this.columnCount();
    }

    @Override
    public int outputDimensions() {
        return this.rowCount();
    }

    @Override
    public INDArray reshape(int ... dimensions) {
        int ndims = dimensions.length;
        if (ndims == 1) {
            return this.toVector().subVector(0, dimensions[0]);
        }
        if (ndims == 2) {
            return Matrixx.createFromVector(this.asVector(), dimensions[0], dimensions[1]);
        }
        return Arrayz.createFromVector(this.toVector(), dimensions);
    }

    @Override
    public void transform(AVector source, AVector dest) {
        int rc = this.rowCount();
        int cc = this.columnCount();
        for (int row = 0; row < rc; ++row) {
            double total = 0.0;
            for (int column = 0; column < cc; ++column) {
                total += this.get(row, column) * source.get(column);
            }
            dest.set(row, total);
        }
    }

    @Override
    public void transformInPlace(AVector v) {
        int cc;
        if (v instanceof ArrayVector) {
            this.transformInPlace((ArrayVector)v);
            return;
        }
        double[] temp = new double[v.length()];
        int rc = this.rowCount();
        if (rc != (cc = this.columnCount())) {
            throw new UnsupportedOperationException("Cannot transform in place with a non-square transformation");
        }
        for (int row = 0; row < rc; ++row) {
            double total = 0.0;
            for (int column = 0; column < cc; ++column) {
                total += this.get(row, column) * v.get(column);
            }
            temp[row] = total;
        }
        v.set(temp);
    }

    public void transformInPlace(ArrayVector v) {
        int cc;
        double[] temp = new double[v.length()];
        int rc = this.rowCount();
        if (rc != (cc = this.columnCount())) {
            throw new UnsupportedOperationException("Cannot transform in place with a non-square transformation");
        }
        double[] data = v.getArray();
        int offset = v.getArrayOffset();
        for (int row = 0; row < rc; ++row) {
            double total = 0.0;
            for (int column = 0; column < cc; ++column) {
                total += this.get(row, column) * data[offset + column];
            }
            temp[row] = total;
        }
        v.set(temp);
    }

    public AVector getRow(int row) {
        return new MatrixRow(row);
    }

    public AVector getColumn(int column) {
        return new MatrixColumn(column);
    }

    public AVector cloneRow(int row) {
        int cc = this.columnCount();
        AVector v = Vectorz.newVector(cc);
        for (int i = 0; i < cc; ++i) {
            v.set(i, this.get(row, i));
        }
        return v;
    }

    public void set(AMatrix a) {
        int rc = this.rowCount();
        if (a.rowCount() != rc) {
            throw new IllegalArgumentException("Source matrix has wrog number of rows: " + a.rowCount());
        }
        int cc = this.columnCount();
        if (a.columnCount() != cc) {
            throw new IllegalArgumentException("Source matrix has wrong number of columns: " + a.columnCount());
        }
        for (int row = 0; row < rc; ++row) {
            for (int column = 0; column < cc; ++column) {
                this.set(row, column, a.get(row, column));
            }
        }
    }

    @Override
    public void set(INDArray a) {
        if (a instanceof AMatrix) {
            this.set((AMatrix)a);
            return;
        }
        if (a instanceof AVector) {
            for (AVector r : this) {
                r.set((AVector)a);
            }
            return;
        }
        if (a instanceof AScalar) {
            this.set(a.get());
            return;
        }
        throw new UnsupportedOperationException("Can't set matrix to array: " + a.getClass() + " with shape: " + a.getShape());
    }

    @Override
    public void set(Object o) {
        if (o instanceof INDArray) {
            this.set((INDArray)o);
            return;
        }
        if (o instanceof Number) {
            this.set(((Number)o).doubleValue());
            return;
        }
        throw new UnsupportedOperationException("Can't set to value for " + o.getClass().toString());
    }

    @Override
    public void setElements(double[] values, int offset, int length) {
        if ((long)length != this.elementCount()) {
            throw new IllegalArgumentException("Incorrect element count: " + length);
        }
        int rc = this.rowCount();
        int cc = this.columnCount();
        int di = offset;
        for (int i = 0; i < rc; ++i) {
            for (int j = 0; j < cc; ++j) {
                this.set(i, j, values[di++]);
            }
        }
    }

    @Override
    public void getElements(double[] dest, int offset) {
        this.asVector().getElements(dest, offset);
    }

    @Override
    public void copyTo(double[] arr) {
        this.getElements(arr, 0);
    }

    @Override
    public void setElements(double[] values) {
        this.setElements(values, 0, values.length);
    }

    @Override
    public boolean isFullyMutable() {
        return true;
    }

    @Override
    public boolean isMutable() {
        return this.isFullyMutable();
    }

    @Override
    public boolean isElementConstrained() {
        return false;
    }

    @Override
    public AMatrix clone() {
        return Matrixx.deepCopy(this);
    }

    public double determinant() {
        if (!this.isSquare()) {
            throw new UnsupportedOperationException("Cannot take determinant of non-square matrix!");
        }
        int rc = this.rowCount();
        int[] inds = new int[rc];
        for (int i = 0; i < rc; ++i) {
            inds[i] = i;
        }
        return this.calcDeterminant(inds, 0);
    }

    private static void swap(int[] inds, int a, int b) {
        int temp = inds[a];
        inds[a] = inds[b];
        inds[b] = temp;
    }

    private double calcDeterminant(int[] inds, int offset) {
        int rc = this.rowCount();
        if (offset == rc - 1) {
            return this.get(offset, inds[offset]);
        }
        double det = this.get(offset, inds[offset]) * this.calcDeterminant(inds, offset + 1);
        for (int i = 1; i < rc - offset; ++i) {
            AMatrix.swap(inds, offset, offset + i);
            det -= this.get(offset, inds[offset]) * this.calcDeterminant(inds, offset + 1);
            AMatrix.swap(inds, offset, offset + i);
        }
        return det;
    }

    public AMatrix toMutableMatrix() {
        return Matrixx.create(this);
    }

    public void transposeInPlace() {
        if (!this.isSquare()) {
            throw new Error("Only square matrixes can be transposed in place!");
        }
        int dims = this.rowCount();
        for (int i = 0; i < dims; ++i) {
            for (int j = i + 1; j < dims; ++j) {
                double temp = this.get(i, j);
                this.set(i, j, this.get(j, i));
                this.set(j, i, temp);
            }
        }
    }

    public AMatrix getTranspose() {
        return TransposedMatrix.wrap(this);
    }

    public void add(AMatrix m) {
        int rc = this.rowCount();
        int cc = this.columnCount();
        assert (rc == m.rowCount());
        assert (cc == m.columnCount());
        for (int i = 0; i < rc; ++i) {
            for (int j = 0; j < cc; ++j) {
                this.set(i, j, this.get(i, j) + m.get(i, j));
            }
        }
    }

    public void add(AVector v) {
        int rc = this.rowCount();
        int cc = this.columnCount();
        assert (cc == v.length());
        for (int i = 0; i < rc; ++i) {
            for (int j = 0; j < cc; ++j) {
                this.set(i, j, this.get(i, j) + v.get(j));
            }
        }
    }

    public void sub(AVector v) {
        int rc = this.rowCount();
        int cc = this.columnCount();
        assert (cc == v.length());
        for (int i = 0; i < rc; ++i) {
            for (int j = 0; j < cc; ++j) {
                this.addAt(i, j, -v.get(j));
            }
        }
    }

    @Override
    public void sub(double d) {
        this.add(-d);
    }

    @Override
    public final void scale(double factor) {
        this.multiply(factor);
    }

    @Override
    public void multiply(double factor) {
        int rc = this.rowCount();
        int cc = this.columnCount();
        for (int i = 0; i < rc; ++i) {
            for (int j = 0; j < cc; ++j) {
                this.set(i, j, this.get(i, j) * factor);
            }
        }
    }

    @Override
    public double elementSum() {
        int rc = this.rowCount();
        int cc = this.columnCount();
        double result = 0.0;
        for (int i = 0; i < rc; ++i) {
            for (int j = 0; j < cc; ++j) {
                result += this.get(i, j);
            }
        }
        return result;
    }

    @Override
    public long nonZeroCount() {
        long result = 0L;
        int rc = this.rowCount();
        int cc = this.columnCount();
        for (int i = 0; i < rc; ++i) {
            for (int j = 0; j < cc; ++j) {
                if (this.get(i, j) == 0.0) continue;
                ++result;
            }
        }
        return result;
    }

    public void sub(AMatrix m) {
        this.addMultiple(m, -1.0);
    }

    @Override
    public void negate() {
        this.multiply(-1.0);
    }

    public void elementMul(AMatrix m) {
        int rc = this.rowCount();
        int cc = this.columnCount();
        assert (rc == m.rowCount());
        assert (cc == m.columnCount());
        for (int i = 0; i < rc; ++i) {
            for (int j = 0; j < cc; ++j) {
                this.set(i, j, this.get(i, j) * m.get(i, j));
            }
        }
    }

    public void mul(AMatrix a) {
        this.composeWith(a);
    }

    public void multiplyRow(int i, double factor) {
        this.getRow(i).multiply(factor);
    }

    public void addRowMultiple(int src, int dst, double factor) {
        this.getRow(dst).addMultiple(this.getRow(src), factor);
    }

    @Override
    public void composeWith(ATransform a) {
        if (a instanceof AMatrix) {
            this.composeWith((AMatrix)a);
        }
        super.composeWith(a);
    }

    public void composeWith(AMatrix a) {
        AMatrix t = this.compose(a);
        this.set(t);
    }

    @Override
    public boolean isView() {
        return false;
    }

    @Override
    public AMatrix copyOfMatrix() {
        return this.clone();
    }

    @Override
    public AVector copyOfTranslationVector() {
        return Vectorz.createZeroVector(this.rowCount());
    }

    public void addMultiple(AMatrix m, double factor) {
        int rc = this.rowCount();
        int cc = this.columnCount();
        assert (rc == m.rowCount());
        assert (cc == m.columnCount());
        for (int i = 0; i < rc; ++i) {
            for (int j = 0; j < cc; ++j) {
                this.set(i, j, this.get(i, j) + m.get(i, j) * factor);
            }
        }
    }

    @Override
    public Iterator<AVector> iterator() {
        return new MatrixIterator(this);
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof AMatrix) {
            return this.equals((AMatrix)o);
        }
        if (o instanceof INDArray) {
            return this.equals((INDArray)o);
        }
        return false;
    }

    public boolean equals(AMatrix a) {
        int rc = this.rowCount();
        if (rc != a.rowCount()) {
            return false;
        }
        int cc = this.columnCount();
        if (cc != a.columnCount()) {
            return false;
        }
        for (int i = 0; i < rc; ++i) {
            for (int j = 0; j < cc; ++j) {
                if (this.get(i, j) == a.get(i, j)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean equals(INDArray v) {
        if (v instanceof AMatrix) {
            return this.equals((AMatrix)v);
        }
        if (v.dimensionality() != 2) {
            return false;
        }
        int[] vs = v.getShape();
        int rc = this.rowCount();
        if (rc != vs[0]) {
            return false;
        }
        int cc = this.columnCount();
        if (cc != vs[1]) {
            return false;
        }
        int[] ind = new int[2];
        for (int i = 0; i < rc; ++i) {
            ind[0] = i;
            for (int j = 0; j < cc; ++j) {
                ind[1] = j;
                if (this.get(i, j) == v.get(ind)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean epsilonEquals(AMatrix a) {
        int rc = this.rowCount();
        int cc = this.columnCount();
        if (rc != a.rowCount() || cc != a.columnCount()) {
            throw new VectorzException("Mismatched matrix sizes!");
        }
        for (int i = 0; i < rc; ++i) {
            for (int j = 0; j < cc; ++j) {
                if (Tools.epsilonEquals(this.get(i, j), a.get(i, j))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean equals(AAffineTransform a) {
        return a.getTranslationComponent().isIdentity() && this.equals(a.getMatrixComponent());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int rc = this.rowCount();
        sb.append("[");
        for (int i = 0; i < rc; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(this.getRow(i).toString());
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        int rc = this.rowCount();
        int cc = this.columnCount();
        for (int i = 0; i < rc; ++i) {
            for (int j = 0; j < cc; ++j) {
                hashCode = 31 * hashCode + Hash.hashCode((double)this.get(i, j));
            }
        }
        return hashCode;
    }

    @Override
    public AVector asVector() {
        int rc = this.rowCount();
        if (rc == 0) {
            return Vector0.INSTANCE;
        }
        AVector v = this.getRow(0);
        for (int i = 1; i < rc; ++i) {
            v = Vectorz.join(v, this.getRow(i));
        }
        return v;
    }

    @Override
    public ATransform compose(ATransform a) {
        if (!(a instanceof AMatrix)) {
            return super.compose(a);
        }
        return this.compose((AMatrix)a);
    }

    public final AMatrix compose(AMatrix a) {
        return this.innerProduct(a);
    }

    public AMatrix innerProduct(AMatrix a) {
        if (this.columnCount() != a.rowCount()) {
            throw new VectorzException("Matrix sizes not compatible!");
        }
        int rc = this.rowCount();
        int cc = a.columnCount();
        int ic = this.columnCount();
        AMatrix result = Matrixx.newMatrix(rc, cc);
        for (int i = 0; i < rc; ++i) {
            for (int j = 0; j < cc; ++j) {
                double acc = 0.0;
                for (int k = 0; k < ic; ++k) {
                    acc += this.get(i, k) * a.get(k, j);
                }
                result.set(i, j, acc);
            }
        }
        return result;
    }

    public AVector innerProduct(AVector v) {
        return this.transform(v);
    }

    public AMatrix innerProduct(AScalar s) {
        AMatrix r = this.clone();
        r.scale(s.get());
        return r;
    }

    @Override
    public INDArray innerProduct(INDArray a) {
        if (a instanceof AVector) {
            return this.innerProduct((AVector)a);
        }
        if (a instanceof AMatrix) {
            return this.compose((AMatrix)a);
        }
        if (a instanceof AScalar) {
            return this.innerProduct((AScalar)a);
        }
        throw new UnsupportedOperationException("Can't take inner product with: " + a.getClass());
    }

    @Override
    public INDArray outerProduct(INDArray a) {
        ArrayList<INDArray> al = new ArrayList<INDArray>();
        for (AVector s : this) {
            if (s instanceof INDArray) {
                al.add(((INDArray)s).outerProduct(a));
                continue;
            }
            double x = Tools.toDouble(s);
            INDArray sa = a.clone();
            sa.scale(x);
            al.add(sa);
        }
        return Arrayz.create(al);
    }

    @Override
    public AMatrix inverse() {
        Matrix result = Matrixx.createInverse(this);
        return result;
    }

    public double trace() {
        int rc = this.rowCount();
        assert (rc == this.columnCount());
        double result = 0.0;
        for (int i = 0; i < rc; ++i) {
            result += this.get(i, i);
        }
        return result;
    }

    @Override
    public boolean isInvertible() {
        return this.isSquare() && this.determinant() != 0.0;
    }

    public void swapRows(int i, int j) {
        if (i == j) {
            return;
        }
        AVector a = this.getRow(i);
        AVector b = this.getRow(j);
        int cc = this.columnCount();
        for (int k = 0; k < cc; ++k) {
            double t = a.get(k);
            a.set(k, b.get(k));
            b.set(k, t);
        }
    }

    public void swapColumns(int i, int j) {
        if (i == j) {
            return;
        }
        AVector a = this.getColumn(i);
        AVector b = this.getColumn(j);
        int rc = this.rowCount();
        for (int k = 0; k < rc; ++k) {
            double t = a.get(k);
            a.set(k, b.get(k));
            b.set(k, t);
        }
    }

    public AVector toVector() {
        int rc = this.rowCount();
        int cc = this.columnCount();
        AVector v = Vectorz.newVector(rc * cc);
        for (int i = 0; i < rc; ++i) {
            for (int j = 0; j < cc; ++j) {
                v.set(i * cc + j, this.get(i, j));
            }
        }
        return v;
    }

    @Override
    public void toDoubleBuffer(DoubleBuffer dest) {
        int n = this.rowCount();
        for (int i = 0; i < n; ++i) {
            this.getRow(i).toDoubleBuffer(dest);
        }
    }

    @Override
    public void applyOp(Op op) {
        int rc = this.rowCount();
        int cc = this.columnCount();
        for (int i = 0; i < rc; ++i) {
            for (int j = 0; j < cc; ++j) {
                this.set(i, j, op.apply(this.get(i, j)));
            }
        }
    }

    @Override
    public void applyOp(IOp op) {
        if (op instanceof Op) {
            this.applyOp((Op)op);
            return;
        }
        int rc = this.rowCount();
        int cc = this.columnCount();
        for (int i = 0; i < rc; ++i) {
            for (int j = 0; j < cc; ++j) {
                this.set(i, j, op.apply(this.get(i, j)));
            }
        }
    }

    @Override
    public void add(INDArray a) {
        block3: {
            int rc;
            int dims;
            block7: {
                block6: {
                    block5: {
                        block4: {
                            block2: {
                                if (!(a instanceof AMatrix)) break block2;
                                this.add((AMatrix)a);
                                break block3;
                            }
                            if (!(a instanceof AVector)) break block4;
                            this.add((AVector)a);
                            break block3;
                        }
                        if (!(a instanceof AScalar)) break block5;
                        this.add(a.get());
                        break block3;
                    }
                    dims = a.dimensionality();
                    rc = this.rowCount();
                    if (dims != 0) break block6;
                    this.add(a.get());
                    break block3;
                }
                if (dims != 1) break block7;
                for (int i = 0; i < rc; ++i) {
                    this.slice(i).add(a);
                }
                break block3;
            }
            if (dims != 2) break block3;
            for (int i = 0; i < rc; ++i) {
                this.slice(i).add(a.slice(i));
            }
        }
    }

    @Override
    public void multiply(INDArray a) {
        if (a instanceof AMatrix) {
            this.elementMul((AMatrix)a);
        } else if (a instanceof AScalar) {
            this.multiply(a.get());
        } else {
            int dims = a.dimensionality();
            int rc = this.rowCount();
            if (dims == 0) {
                this.multiply(a.get());
            } else if (dims == 1) {
                for (int i = 0; i < rc; ++i) {
                    this.slice(i).multiply(a);
                }
            } else if (dims == 2) {
                for (int i = 0; i < rc; ++i) {
                    this.slice(i).multiply(a.slice(i));
                }
            } else {
                throw new VectorzException("Can't multiply matrix with array of dimensionality: " + dims);
            }
        }
    }

    @Override
    public void sub(INDArray a) {
        block3: {
            int rc;
            int dims;
            block7: {
                block6: {
                    block5: {
                        block4: {
                            block2: {
                                if (!(a instanceof AMatrix)) break block2;
                                this.sub((AMatrix)a);
                                break block3;
                            }
                            if (!(a instanceof AVector)) break block4;
                            this.sub((AVector)a);
                            break block3;
                        }
                        if (!(a instanceof AScalar)) break block5;
                        this.sub(a.get());
                        break block3;
                    }
                    dims = a.dimensionality();
                    rc = this.rowCount();
                    if (dims != 0) break block6;
                    this.sub(a.get());
                    break block3;
                }
                if (dims != 1) break block7;
                for (int i = 0; i < rc; ++i) {
                    this.slice(i).sub(a);
                }
                break block3;
            }
            if (dims != 2) break block3;
            for (int i = 0; i < rc; ++i) {
                this.slice(i).sub(a.slice(i));
            }
        }
    }

    @Override
    public void add(double d) {
        int rc = this.rowCount();
        int cc = this.columnCount();
        for (int i = 0; i < rc; ++i) {
            for (int j = 0; j < cc; ++j) {
                this.addAt(i, j, d);
            }
        }
    }

    public void addAt(int i, int j, double d) {
        this.set(i, j, this.get(i, j) + d);
    }

    @Override
    public INDArray broadcast(int ... targetShape) {
        int tdims = targetShape.length;
        if (tdims < 2) {
            throw new VectorzException("Can't broadcast to a smaller shape!");
        }
        if (2 == tdims) {
            return this;
        }
        int n = targetShape[0];
        INDArray s = this.broadcast(Arrays.copyOfRange(targetShape, 1, tdims));
        return SliceArray.repeat(s, n);
    }

    public boolean isZeroMatrix() {
        int rc = this.rowCount();
        int cc = this.columnCount();
        for (int i = 0; i < rc; ++i) {
            for (int j = 0; j < cc; ++j) {
                if (this.get(i, j) == 0.0) continue;
                return false;
            }
        }
        return true;
    }

    public void isPositiveDefinite() {
        throw new UnsupportedOperationException();
    }

    public boolean isDiagonal() {
        int cc;
        int rc = this.rowCount();
        if (rc != (cc = this.columnCount())) {
            return false;
        }
        for (int i = 0; i < rc; ++i) {
            for (int j = 0; j < cc; ++j) {
                if (i == j || this.get(i, j) == 0.0) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isSymmetric() {
        int cc;
        int rc = this.rowCount();
        if (rc != (cc = this.columnCount())) {
            return false;
        }
        for (int i = 0; i < rc; ++i) {
            for (int j = i + 1; j < cc; ++j) {
                if (this.get(i, j) == this.get(j, i)) continue;
                return false;
            }
        }
        return true;
    }

    public final boolean isHermitian() {
        return this.isSymmetric();
    }

    public boolean isUpperTriangular() {
        int rc = this.rowCount();
        int cc = this.columnCount();
        for (int j = 0; j < cc; ++j) {
            for (int i = j + 1; i < rc; ++i) {
                if (this.get(i, j) == 0.0) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isLowerTriangular() {
        int rc = this.rowCount();
        int cc = this.columnCount();
        for (int i = 0; i < rc; ++i) {
            for (int j = i + 1; j < cc; ++j) {
                if (this.get(i, j) == 0.0) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public abstract AMatrix exactClone();

    @Override
    public void validate() {
    }

    private class MatrixColumn
    extends MatrixSubVector {
        private final int column;

        private MatrixColumn(int column) {
            this.column = column;
        }

        @Override
        public int length() {
            return AMatrix.this.rowCount();
        }

        @Override
        public double get(int i) {
            return AMatrix.this.get(i, this.column);
        }

        @Override
        public boolean isFullyMutable() {
            return AMatrix.this.isFullyMutable();
        }

        @Override
        public void set(int i, double value) {
            AMatrix.this.set(i, this.column, value);
        }

        @Override
        public MatrixColumn exactClone() {
            AMatrix aMatrix = AMatrix.this.exactClone();
            aMatrix.getClass();
            return aMatrix.new MatrixColumn(this.column);
        }
    }

    private class MatrixRow
    extends MatrixSubVector {
        private final int row;

        private MatrixRow(int row) {
            this.row = row;
        }

        @Override
        public int length() {
            return AMatrix.this.columnCount();
        }

        @Override
        public double get(int i) {
            return AMatrix.this.get(this.row, i);
        }

        @Override
        public void set(int i, double value) {
            AMatrix.this.set(this.row, i, value);
        }

        @Override
        public boolean isFullyMutable() {
            return AMatrix.this.isFullyMutable();
        }

        @Override
        public MatrixRow exactClone() {
            AMatrix aMatrix = AMatrix.this.exactClone();
            aMatrix.getClass();
            return aMatrix.new MatrixRow(this.row);
        }
    }
}

