/*
 * Decompiled with CFR 0.152.
 */
package mikera.vectorz;

import mikera.vectorz.APrimitiveVector;
import mikera.vectorz.AVector;
import mikera.vectorz.Op;

public final class Vector2
extends APrimitiveVector {
    private static final long serialVersionUID = -7815583836324137277L;
    public double x;
    public double y;

    public Vector2() {
    }

    public Vector2(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public Vector2(double ... values) {
        if (values.length != this.length()) {
            throw new IllegalArgumentException("Can't create " + this.length() + "D vector from: " + values);
        }
        this.x = values[0];
        this.y = values[1];
    }

    public static Vector2 of(double x, double y) {
        return new Vector2(x, y);
    }

    public static Vector2 of(double ... values) {
        return new Vector2(values);
    }

    @Override
    public void applyOp(Op op) {
        this.x = op.apply(this.x);
        this.y = op.apply(this.y);
    }

    public void add(Vector2 v) {
        this.x += v.x;
        this.y += v.y;
    }

    public void addMultiple(Vector2 v, double factor) {
        this.x += v.x * factor;
        this.y += v.y * factor;
    }

    public void addProduct(Vector2 a, Vector2 b) {
        this.x += a.x * b.x;
        this.y += a.y * b.y;
    }

    public void addProduct(Vector2 a, Vector2 b, double factor) {
        this.x += a.x * b.x * factor;
        this.y += a.y * b.y * factor;
    }

    @Override
    public void scaleAdd(double factor, double constant) {
        this.x = this.x * factor + constant;
        this.y = this.y * factor + constant;
    }

    @Override
    public void negate() {
        this.x = -this.x;
        this.y = -this.y;
    }

    @Override
    public void add(double constant) {
        this.x += constant;
        this.y += constant;
    }

    public void add(double dx, double dy) {
        this.x += dx;
        this.y += dy;
    }

    @Override
    public void add(AVector v) {
        assert (v.length() == 2);
        this.x += v.get(0);
        this.y += v.get(1);
    }

    @Override
    public int length() {
        return 2;
    }

    @Override
    public double elementSum() {
        return this.x + this.y;
    }

    @Override
    public double magnitudeSquared() {
        return this.x * this.x + this.y * this.y;
    }

    @Override
    public double magnitude() {
        return Math.sqrt(this.magnitudeSquared());
    }

    @Override
    public double get(int i) {
        switch (i) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
        }
        throw new IndexOutOfBoundsException("Index: i");
    }

    @Override
    public void copyTo(double[] data, int offset) {
        data[offset] = this.x;
        data[offset + 1] = this.y;
    }

    @Override
    public void set(int i, double value) {
        switch (i) {
            case 0: {
                this.x = value;
                return;
            }
            case 1: {
                this.y = value;
                return;
            }
        }
        throw new IndexOutOfBoundsException("Index: i");
    }

    @Override
    public void addAt(int i, double value) {
        switch (i) {
            case 0: {
                this.x += value;
                return;
            }
            case 1: {
                this.y += value;
                return;
            }
        }
        throw new IndexOutOfBoundsException("Index: i");
    }

    public void setValues(double x, double y) {
        this.x = x;
        this.y = y;
    }

    @Override
    public Vector2 clone() {
        return new Vector2(this.x, this.y);
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public Vector2 exactClone() {
        return this.clone();
    }
}

