/*
 * Decompiled with CFR 0.152.
 */
package mikera.matrixx.impl;

import mikera.matrixx.AMatrix;
import mikera.matrixx.impl.ColumnMatrix;
import mikera.vectorz.AVector;
import mikera.vectorz.Op;

public class RowMatrix
extends AMatrix {
    private final AVector vector;

    public RowMatrix(AVector v) {
        this.vector = v;
    }

    public static RowMatrix wrap(AVector v) {
        return new RowMatrix(v);
    }

    @Override
    public int rowCount() {
        return 1;
    }

    @Override
    public AVector toVector() {
        return this.vector.clone();
    }

    @Override
    public AVector asVector() {
        return this.vector;
    }

    @Override
    public void multiply(double factor) {
        this.vector.scale(factor);
    }

    @Override
    public void applyOp(Op op) {
        this.vector.applyOp(op);
    }

    @Override
    public int columnCount() {
        return this.vector.length();
    }

    @Override
    public double elementSum() {
        return this.vector.elementSum();
    }

    @Override
    public long nonZeroCount() {
        return this.vector.nonZeroCount();
    }

    @Override
    public double get(int row, int column) {
        assert (row == 0);
        return this.vector.get(column);
    }

    @Override
    public void set(int row, int column, double value) {
        assert (row == 0);
        this.vector.set(column, value);
    }

    @Override
    public ColumnMatrix getTranspose() {
        return new ColumnMatrix(this.vector);
    }

    @Override
    public RowMatrix exactClone() {
        return new RowMatrix(this.vector.exactClone());
    }
}

