/*
 * Decompiled with CFR 0.152.
 */
package mikera.matrixx;

import java.util.Arrays;
import mikera.matrixx.AMatrix;
import mikera.matrixx.Matrixx;
import mikera.vectorz.AVector;
import mikera.vectorz.Op;
import mikera.vectorz.Vector;
import mikera.vectorz.impl.ArraySubVector;
import mikera.vectorz.impl.StridedArrayVector;
import mikera.vectorz.util.DoubleArrays;
import mikera.vectorz.util.VectorzException;

public final class Matrix
extends AMatrix {
    private final int rows;
    private final int columns;
    public final double[] data;

    public Matrix(int rowCount, int columnCount) {
        this(rowCount, columnCount, new double[rowCount * columnCount]);
    }

    public static Matrix create(int rowCount, int columnCount) {
        return new Matrix(rowCount, columnCount);
    }

    public Matrix(AMatrix m) {
        this(m.rowCount(), m.columnCount());
        this.set(m);
    }

    public Matrix(Object ... vs) {
        AMatrix m = Matrixx.create(vs);
        this.rows = m.rowCount();
        this.columns = m.columnCount();
        this.data = new double[this.rows * this.columns];
        this.set(m);
    }

    @Override
    public boolean isView() {
        return false;
    }

    private Matrix(int rowCount, int columnCount, double[] data) {
        this.rows = rowCount;
        this.columns = columnCount;
        this.data = data;
    }

    public static Matrix wrap(int rowCount, int columnCount, double[] data) {
        if (data.length != rowCount * columnCount) {
            throw new VectorzException("data array is of wrong size: " + data.length);
        }
        return new Matrix(rowCount, columnCount, data);
    }

    public Matrix innerProduct(Matrix a) {
        if (this.columnCount() != a.rowCount()) {
            throw new VectorzException("Matrix sizes not compatible!");
        }
        int rc = this.rowCount();
        int cc = a.columnCount();
        int ic = this.columnCount();
        Matrix result = Matrix.create(rc, cc);
        for (int i = 0; i < rc; ++i) {
            for (int j = 0; j < cc; ++j) {
                double acc = 0.0;
                for (int k = 0; k < ic; ++k) {
                    acc += this.get(i, k) * a.get(k, j);
                }
                result.set(i, j, acc);
            }
        }
        return result;
    }

    @Override
    public Matrix innerProduct(AMatrix a) {
        if (a instanceof Matrix) {
            return this.innerProduct((Matrix)a);
        }
        if (this.columnCount() != a.rowCount()) {
            throw new VectorzException("Matrix sizes not compatible!");
        }
        int rc = this.rowCount();
        int cc = a.columnCount();
        int ic = this.columnCount();
        Matrix result = Matrix.create(rc, cc);
        for (int i = 0; i < rc; ++i) {
            for (int j = 0; j < cc; ++j) {
                double acc = 0.0;
                for (int k = 0; k < ic; ++k) {
                    acc += this.get(i, k) * a.get(k, j);
                }
                result.set(i, j, acc);
            }
        }
        return result;
    }

    @Override
    public double elementSum() {
        return DoubleArrays.elementSum(this.data, 0, this.data.length);
    }

    @Override
    public long nonZeroCount() {
        return DoubleArrays.nonZeroCount(this.data, 0, this.data.length);
    }

    @Override
    public void transform(AVector source, AVector dest) {
        assert (this.rowCount() == dest.length());
        assert (this.columnCount() == source.length());
        int index = 0;
        for (int i = 0; i < this.rows; ++i) {
            double acc = 0.0;
            for (int j = 0; j < this.columns; ++j) {
                acc += this.data[index++] * source.get(j);
            }
            dest.set(i, acc);
        }
    }

    @Override
    public ArraySubVector getRow(int row) {
        return ArraySubVector.wrap(this.data, row * this.columns, this.columns);
    }

    @Override
    public AVector getColumn(int row) {
        return StridedArrayVector.wrap(this.data, row, this.rows, this.columns);
    }

    @Override
    public int rowCount() {
        return this.rows;
    }

    @Override
    public int columnCount() {
        return this.columns;
    }

    @Override
    public void swapRows(int i, int j) {
        if (i == j) {
            return;
        }
        int a = i * this.columns;
        int b = j * this.columns;
        int cc = this.columnCount();
        for (int k = 0; k < cc; ++k) {
            double t = this.data[a + k];
            this.data[a + k] = this.data[b + k];
            this.data[b + k] = t;
        }
    }

    @Override
    public void multiplyRow(int i, double factor) {
        int offset = i * this.columns;
        for (int j = 0; j < this.columns; ++j) {
            int n = offset + j;
            this.data[n] = this.data[n] * factor;
        }
    }

    @Override
    public void addRowMultiple(int src, int dst, double factor) {
        int soffset = src * this.columns;
        int doffset = dst * this.columns;
        for (int j = 0; j < this.columns; ++j) {
            int n = doffset + j;
            this.data[n] = this.data[n] + factor * this.data[soffset + j];
        }
    }

    @Override
    public Vector asVector() {
        return Vector.wrap(this.data);
    }

    @Override
    public double get(int row, int column) {
        return this.data[row * this.columns + column];
    }

    @Override
    public void set(int row, int column, double value) {
        this.data[row * this.columns + column] = value;
    }

    @Override
    public void applyOp(Op op) {
        op.applyTo(this.data);
    }

    public void addMultiple(Matrix m, double factor) {
        assert (this.rowCount() == m.rowCount());
        assert (this.columnCount() == m.columnCount());
        for (int i = 0; i < this.data.length; ++i) {
            int n = i;
            this.data[n] = this.data[n] + m.data[i] * factor;
        }
    }

    public void add(Matrix m) {
        assert (this.rowCount() == m.rowCount());
        assert (this.columnCount() == m.columnCount());
        for (int i = 0; i < this.data.length; ++i) {
            int n = i;
            this.data[n] = this.data[n] + m.data[i];
        }
    }

    @Override
    public void addMultiple(AMatrix m, double factor) {
        if (m instanceof Matrix) {
            this.addMultiple((Matrix)m, factor);
            return;
        }
        int rc = this.rowCount();
        int cc = this.columnCount();
        assert (rc == m.rowCount());
        assert (cc == m.columnCount());
        int di = 0;
        for (int i = 0; i < rc; ++i) {
            for (int j = 0; j < cc; ++j) {
                int n = di++;
                this.data[n] = this.data[n] + m.get(i, j) * factor;
            }
        }
    }

    @Override
    public void add(AMatrix m) {
        if (m instanceof Matrix) {
            this.add((Matrix)m);
            return;
        }
        int rc = this.rowCount();
        int cc = this.columnCount();
        assert (rc == m.rowCount());
        assert (cc == m.columnCount());
        int di = 0;
        for (int i = 0; i < rc; ++i) {
            for (int j = 0; j < cc; ++j) {
                int n = di++;
                this.data[n] = this.data[n] + m.get(i, j);
            }
        }
    }

    @Override
    public void multiply(double factor) {
        int i = 0;
        while (i < this.data.length) {
            int n = i++;
            this.data[n] = this.data[n] * factor;
        }
    }

    @Override
    public void set(AMatrix a) {
        int rc = this.rowCount();
        assert (rc == a.rowCount());
        int cc = this.columnCount();
        assert (cc == a.columnCount());
        int di = 0;
        for (int row = 0; row < rc; ++row) {
            for (int column = 0; column < cc; ++column) {
                this.data[di++] = a.get(row, column);
            }
        }
    }

    @Override
    public void getElements(double[] dest, int offset) {
        System.arraycopy(this.data, 0, dest, offset, this.data.length);
    }

    @Override
    public void set(double value) {
        Arrays.fill(this.data, value);
    }

    @Override
    public Matrix exactClone() {
        return new Matrix(this);
    }
}

