/*
 * Decompiled with CFR 0.152.
 */
package mikera.arrayz;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mikera.arrayz.AbstractArray;
import mikera.arrayz.INDArray;
import mikera.vectorz.AVector;
import mikera.vectorz.IOp;
import mikera.vectorz.Op;
import mikera.vectorz.Tools;
import mikera.vectorz.Vector;
import mikera.vectorz.Vectorz;
import mikera.vectorz.impl.ArrayIndexScalar;
import mikera.vectorz.impl.ArraySubVector;
import mikera.vectorz.impl.StridedArrayVector;
import mikera.vectorz.impl.Vector0;
import mikera.vectorz.util.IntArrays;
import mikera.vectorz.util.VectorzException;

public final class NDArray
extends AbstractArray<INDArray> {
    private final int dimensions;
    private final int[] shape;
    private int offset;
    private final double[] data;
    private int[] stride;

    private NDArray(int ... shape) {
        this.shape = (int[])shape.clone();
        this.dimensions = shape.length;
        this.data = new double[(int)this.elementCount()];
        this.stride = new int[this.dimensions];
        this.offset = 0;
        int st = 1;
        for (int j = this.dimensions - 1; j >= 0; --j) {
            this.stride[j] = st;
            st *= shape[j];
        }
    }

    public NDArray(double[] data, int offset, int[] shape, int[] stride) {
        this.data = data;
        this.offset = offset;
        this.shape = shape;
        this.stride = stride;
        this.dimensions = shape.length;
    }

    public NDArray(double[] data, int dimensions, int offset, int[] shape, int[] stride) {
        this.data = data;
        this.offset = offset;
        this.shape = shape;
        this.stride = stride;
        this.dimensions = dimensions;
    }

    public static NDArray newArray(int ... shape) {
        return new NDArray(shape);
    }

    @Override
    public int dimensionality() {
        return this.dimensions;
    }

    @Override
    public int[] getShape() {
        return this.shape;
    }

    public int getStride(int dim) {
        return this.stride[dim];
    }

    @Override
    public int getShape(int dim) {
        return this.shape[dim];
    }

    @Override
    public long[] getLongShape() {
        long[] sh = new long[this.dimensions];
        Tools.copyIntsToLongs(this.shape, sh);
        return sh;
    }

    @Override
    public double get() {
        if (this.dimensions == 0) {
            return this.data[this.offset];
        }
        throw new UnsupportedOperationException("0-d get not possible on NDArray with dimensionality=" + this.dimensions);
    }

    @Override
    public double get(int x) {
        if (this.dimensions == 1) {
            return this.data[this.offset + x * this.getStride(0)];
        }
        throw new UnsupportedOperationException("1-d get not possible on NDArray with dimensionality=" + this.dimensions);
    }

    @Override
    public double get(int x, int y) {
        if (this.dimensions == 2) {
            return this.data[this.offset + x * this.getStride(0) + y * this.getStride(1)];
        }
        throw new UnsupportedOperationException("2-d get not possible on NDArray with dimensionality=" + this.dimensions);
    }

    @Override
    public double get(int ... indexes) {
        int ix = this.offset;
        for (int i = 0; i < this.dimensions; ++i) {
            ix += indexes[i] * this.getStride(i);
        }
        return this.data[ix];
    }

    @Override
    public void set(double value) {
        if (this.dimensions == 0) {
            this.data[this.offset] = value;
        } else if (this.dimensions == 1) {
            int n = this.getShape(0);
            int st = this.getStride(0);
            for (int i = 0; i < n; ++i) {
                this.data[this.offset + i * st] = value;
            }
        } else {
            for (INDArray s : this.getSlices()) {
                s.set(value);
            }
        }
    }

    @Override
    public void set(int x, double value) {
        if (this.dimensions != 1) {
            throw new UnsupportedOperationException("1-d set not possible on NDArray with dimensionality=" + this.dimensions);
        }
        this.data[this.offset + x * this.getStride((int)0)] = value;
    }

    @Override
    public void set(int x, int y, double value) {
        if (this.dimensions != 2) {
            throw new UnsupportedOperationException("2-d set not possible on NDArray with dimensionality=" + this.dimensions);
        }
        this.data[this.offset + x * this.getStride((int)0) + y * this.getStride((int)1)] = value;
    }

    @Override
    public void set(int[] indexes, double value) {
        int ix = this.offset;
        for (int i = 0; i < this.dimensions; ++i) {
            ix += indexes[i] * this.getStride(i);
        }
        this.data[ix] = value;
    }

    @Override
    public void add(INDArray a) {
        super.add(a);
    }

    @Override
    public void sub(INDArray a) {
        super.sub(a);
    }

    @Override
    public INDArray innerProduct(INDArray a) {
        return super.innerProduct(a);
    }

    @Override
    public INDArray outerProduct(INDArray a) {
        return super.outerProduct(a);
    }

    @Override
    public AVector asVector() {
        if (this.fittedDataArray()) {
            return Vector.wrap(this.data);
        }
        if (this.dimensions == 0) {
            return ArraySubVector.wrap(this.data, this.offset, 1);
        }
        if (this.dimensions == 1) {
            return StridedArrayVector.wrap(this.data, this.offset, this.getShape(0), this.getStride(0));
        }
        AVector v = Vector0.INSTANCE;
        int n = this.getShape(0);
        for (int i = 0; i < n; ++i) {
            v = ((AVector)v).join(this.slice(i).asVector());
        }
        return v;
    }

    private boolean fittedDataArray() {
        if (this.offset != 0) {
            return false;
        }
        int st = 1;
        for (int i = this.dimensions - 1; i >= 0; --i) {
            if (this.getStride(i) != st) {
                return false;
            }
            int d = this.shape[i];
            st *= d;
        }
        return st == this.data.length;
    }

    @Override
    public INDArray reshape(int ... dimensions) {
        return super.reshape(dimensions);
    }

    @Override
    public INDArray broadcast(int ... dimensions) {
        return super.broadcast(dimensions);
    }

    @Override
    public INDArray slice(int majorSlice) {
        if (this.dimensions == 0) {
            throw new IllegalArgumentException("Can't slice a 0-d NDArray");
        }
        if (this.dimensions == 1) {
            return new ArrayIndexScalar(this.data, this.offset + majorSlice * this.getStride(0));
        }
        if (this.dimensions == 2) {
            if (majorSlice < 0 || majorSlice > this.shape[0]) {
                throw new IllegalArgumentException("Slice out of range: " + majorSlice);
            }
            int st = this.stride[1];
            if (st == 1) {
                return Vectorz.wrap(this.data, this.offset + majorSlice * this.getStride(0), this.getShape(1));
            }
            return StridedArrayVector.wrapStrided(this.data, this.offset + majorSlice * this.getStride(0), this.getShape(1), st);
        }
        return new NDArray(this.data, this.offset + majorSlice * this.getStride(0), Arrays.copyOfRange(this.shape, 1, this.dimensions), Arrays.copyOfRange(this.stride, 1, this.dimensions));
    }

    @Override
    public INDArray slice(int dimension, int index) {
        if (dimension < 0 || dimension >= this.dimensions) {
            throw new IllegalArgumentException("Dimension out of range!");
        }
        if (dimension == 0) {
            return this.slice(index);
        }
        if (this.dimensions == 2) {
            if (dimension != 1) {
                throw new IllegalArgumentException("Dimension out of range!");
            }
            return StridedArrayVector.wrap(this.data, this.offset + index * this.getStride(1), this.getShape(0), this.getStride(0));
        }
        return new NDArray(this.data, this.offset, IntArrays.removeIndex(this.shape, index), IntArrays.removeIndex(this.stride, index));
    }

    @Override
    public int sliceCount() {
        if (this.dimensions == 0) {
            throw new IllegalArgumentException("Can't count slices o 0-d array");
        }
        return this.getShape(0);
    }

    @Override
    public long elementCount() {
        return Tools.arrayProduct(this.shape);
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    @Override
    public boolean isFullyMutable() {
        return true;
    }

    @Override
    public boolean isElementConstrained() {
        return false;
    }

    @Override
    public boolean isView() {
        return true;
    }

    @Override
    public void applyOp(Op op) {
        if (this.dimensions == 0) {
            this.data[this.offset] = op.apply(this.data[this.offset]);
        } else if (this.dimensions == 1) {
            int st = this.getStride(0);
            int len = this.getShape(0);
            if (st == 1) {
                op.applyTo(this.data, this.offset, len);
            } else {
                for (int i = 0; i < len; ++i) {
                    this.data[this.offset + i * st] = op.apply(this.data[this.offset + i * st]);
                }
            }
        } else {
            int n = this.shape[0];
            for (int i = 0; i < n; ++i) {
                this.slice(i).applyOp(op);
            }
        }
    }

    @Override
    public void applyOp(IOp op) {
        this.applyOp((Op)op);
    }

    public boolean equals(NDArray a) {
        if (this.dimensions != a.dimensions) {
            return false;
        }
        for (int i = 0; i < this.dimensions; ++i) {
            if (this.slice(i).equals(a.slice(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(INDArray a) {
        if (a instanceof NDArray) {
            return this.equals((NDArray)a);
        }
        for (int i = 0; i < this.dimensions; ++i) {
            if (this.slice(i).equals(a.slice(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public NDArray exactClone() {
        NDArray c = new NDArray((double[])this.data.clone(), this.offset, (int[])this.shape.clone(), (int[])this.stride.clone());
        return c;
    }

    @Override
    public NDArray clone() {
        NDArray c = new NDArray((int[])this.shape.clone());
        c.set(this);
        return c;
    }

    @Override
    public void multiply(double d) {
        if (this.dimensions == 0) {
            int n = this.offset;
            this.data[n] = this.data[n] * d;
        } else if (this.dimensions == 1) {
            int n = this.getShape(0);
            for (int i = 0; i < n; ++i) {
                int n2 = this.offset + i * this.getStride(0);
                this.data[n2] = this.data[n2] * d;
            }
        } else {
            int n = this.getShape(0);
            for (int i = 0; i < n; ++i) {
                this.slice(i).scale(d);
            }
        }
    }

    @Override
    public void setElements(double[] values, int offset, int length) {
        if (this.dimensions == 0) {
            this.data[this.offset] = values[offset];
        } else if (this.dimensions == 1) {
            if (length > this.getShape(0)) {
                throw new IllegalArgumentException("Too many values for NDArray: " + length);
            }
            int st0 = this.getStride(0);
            for (int i = 0; i < length; ++i) {
                this.data[this.offset + i * st0] = values[offset + i];
            }
        } else {
            int sc = this.getShape(0);
            int ssize = (int)Tools.arrayProduct(this.shape, 1, this.dimensions);
            for (int i = 0; i < sc; ++i) {
                this.slice(i).setElements(values, offset + ssize * i, ssize);
            }
        }
    }

    @Override
    public List<INDArray> getSlices() {
        if (this.dimensions == 0) {
            throw new IllegalArgumentException("Can't get slices of 0-d NDArray");
        }
        ArrayList<INDArray> al = new ArrayList<INDArray>();
        int n = this.getShape(0);
        for (int i = 0; i < n; ++i) {
            al.add(this.slice(i));
        }
        return al;
    }

    @Override
    public void validate() {
        if (this.dimensions > this.shape.length) {
            throw new VectorzException("Insufficient shape data");
        }
        if (this.dimensions > this.stride.length) {
            throw new VectorzException("Insufficient stride data");
        }
        if (this.offset < 0 || this.offset >= this.data.length) {
            throw new VectorzException("Offset out of bounds");
        }
        super.validate();
    }
}

