/*
 * Decompiled with CFR 0.152.
 */
package mikera.arrayz;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import mikera.arrayz.Arrayz;
import mikera.arrayz.INDArray;
import mikera.arrayz.SliceArray;
import mikera.arrayz.SliceIterator;
import mikera.vectorz.AScalar;
import mikera.vectorz.Ops;
import mikera.vectorz.Tools;
import mikera.vectorz.util.VectorzException;

public abstract class AbstractArray<T>
implements INDArray,
Iterable<T> {
    @Override
    public double get() {
        return this.get(new int[0]);
    }

    @Override
    public double get(int x) {
        return this.get(new int[]{x});
    }

    @Override
    public double get(int x, int y) {
        return this.get(new int[]{x, y});
    }

    @Override
    public int getShape(int dim) {
        return this.getShape()[dim];
    }

    @Override
    public INDArray innerProduct(INDArray a) {
        if (a instanceof AScalar) {
            Object c = this.clone();
            c.scale(((AScalar)a).get());
            return c;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public INDArray outerProduct(INDArray a) {
        ArrayList<INDArray> al = new ArrayList<INDArray>();
        for (T s : this) {
            if (s instanceof INDArray) {
                al.add(((INDArray)s).outerProduct(a));
                continue;
            }
            double x = Tools.toDouble(s);
            INDArray sa = a.clone();
            sa.scale(x);
            al.add(sa);
        }
        return Arrayz.create(al);
    }

    @Override
    public final void scale(double d) {
        this.multiply(d);
    }

    @Override
    public void set(double value) {
        this.set(new int[0], value);
    }

    @Override
    public void set(int x, double value) {
        this.set(new int[]{x}, value);
    }

    @Override
    public void set(int x, int y, double value) {
        this.set(new int[]{x, y}, value);
    }

    @Override
    public void set(INDArray a) {
        int tdims = this.dimensionality();
        int adims = a.dimensionality();
        if (adims < tdims) {
            int sc = this.getShape()[0];
            for (int i = 0; i < sc; ++i) {
                INDArray s = this.slice(i);
                s.set(a);
            }
        } else if (adims == tdims) {
            int sc = this.sliceCount();
            for (int i = 0; i < sc; ++i) {
                INDArray s = this.slice(i);
                s.set(a.slice(i));
            }
        } else {
            throw new IllegalArgumentException("Can't set array to value of higher dimensionality");
        }
    }

    @Override
    public void set(Object o) {
        if (o instanceof INDArray) {
            this.set((INDArray)o);
            return;
        }
        if (o instanceof Number) {
            this.set(((Number)o).doubleValue());
            return;
        }
        if (o instanceof Iterable) {
            int i = 0;
            for (Object ob : (Iterable)o) {
                this.slice(i).set(ob);
            }
            return;
        }
        if (o instanceof double[]) {
            this.setElements((double[])o);
            return;
        }
        throw new UnsupportedOperationException("Can't set to value for " + o.getClass().toString());
    }

    @Override
    public void setElements(double[] values) {
        this.setElements(values, 0, values.length);
    }

    public void square() {
        this.applyOp(Ops.SQUARE);
    }

    @Override
    public Iterator<T> iterator() {
        return new SliceIterator(this);
    }

    public boolean equals(Object o) {
        if (!(o instanceof INDArray)) {
            return false;
        }
        return this.equals((INDArray)o);
    }

    public int hashCode() {
        return this.asVector().hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int length = this.sliceCount();
        sb.append('[');
        if (length > 0) {
            sb.append(this.slice(0).toString());
            for (int i = 1; i < length; ++i) {
                sb.append(',');
                sb.append(this.slice(i).toString());
            }
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    public AbstractArray<?> clone() {
        try {
            return (AbstractArray)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new VectorzException("AbstractArray clone failed");
        }
    }

    @Override
    public void add(INDArray a) {
        int adims;
        int n = this.sliceCount();
        int na = a.sliceCount();
        int dims = this.dimensionality();
        if (dims == (adims = a.dimensionality())) {
            if (n != na) {
                throw new VectorzException("Non-matching dimensions");
            }
            for (int i = 0; i < n; ++i) {
                this.slice(i).add(a.slice(i));
            }
        } else if (adims < dims) {
            for (int i = 0; i < n; ++i) {
                this.slice(i).add(a);
            }
        } else {
            throw new VectorzException("Cannot add array of greater dimensionality");
        }
    }

    @Override
    public long nonZeroCount() {
        long result = 0L;
        int n = this.sliceCount();
        for (int i = 0; i < n; ++i) {
            result += this.slice(i).nonZeroCount();
        }
        return result;
    }

    @Override
    public void sub(INDArray a) {
        int adims;
        int n = this.sliceCount();
        int na = a.sliceCount();
        int dims = this.dimensionality();
        if (dims == (adims = a.dimensionality())) {
            if (n != na) {
                throw new VectorzException("Non-matching dimensions");
            }
            for (int i = 0; i < n; ++i) {
                this.slice(i).sub(a.slice(i));
            }
        } else if (adims < dims) {
            for (int i = 0; i < n; ++i) {
                this.slice(i).sub(a);
            }
        } else {
            throw new VectorzException("Cannot add array of greater dimensionality");
        }
    }

    @Override
    public INDArray reshape(int ... targetShape) {
        return Arrayz.createFromVector(this.asVector(), targetShape);
    }

    public abstract List<T> getSlices();

    @Override
    public void getElements(double[] dest, int offset) {
        int sc = this.sliceCount();
        for (int i = 0; i < sc; ++i) {
            INDArray s = this.slice(i);
            s.getElements(dest, offset);
            offset = (int)((long)offset + s.elementCount());
        }
    }

    @Override
    public void copyTo(double[] arr) {
        this.getElements(arr, 0);
    }

    @Override
    public INDArray broadcast(int ... targetShape) {
        int tdims = targetShape.length;
        int dims = this.dimensionality();
        if (tdims < dims) {
            throw new VectorzException("Can't broadcast to a smaller shape!");
        }
        if (dims == tdims) {
            return this;
        }
        int n = targetShape[0];
        INDArray s = this.broadcast(Arrays.copyOfRange(targetShape, 1, tdims));
        return SliceArray.repeat(s, n);
    }

    @Override
    public void validate() {
    }
}

