/*
 * Decompiled with CFR 0.152.
 */
package mikera.vectorz.impl;

import mikera.vectorz.AVector;
import mikera.vectorz.impl.ArraySubVector;
import mikera.vectorz.impl.Vector0;

public class StridedArrayVector
extends AVector {
    private static final long serialVersionUID = 5807998427323932401L;
    private double[] data;
    private int length;
    private int offset;
    private int stride;

    private StridedArrayVector(double[] data, int offset, int length, int stride) {
        this.data = data;
        this.offset = offset;
        this.length = length;
        this.stride = stride;
    }

    public static StridedArrayVector wrapStrided(double[] data, int offset, int length, int stride) {
        return new StridedArrayVector(data, offset, length, stride);
    }

    public static AVector wrap(double[] data, int offset, int length, int stride) {
        if (stride == 1) {
            return ArraySubVector.wrap(data, offset, length);
        }
        return StridedArrayVector.wrapStrided(data, offset, length, stride);
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public boolean isView() {
        return true;
    }

    @Override
    public boolean isFullyMutable() {
        return true;
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    @Override
    public double dotProduct(AVector v) {
        assert (v.length() == this.length);
        double result = 0.0;
        for (int i = 0; i < this.length; ++i) {
            result += this.data[this.offset + i * this.stride] * v.get(i);
        }
        return result;
    }

    @Override
    public void set(AVector v) {
        assert (v.length() == this.length);
        for (int i = 0; i < this.length; ++i) {
            this.data[this.offset + i * this.stride] = v.get(i);
        }
    }

    @Override
    public AVector subVector(int start, int length) {
        assert (start >= 0);
        assert (start + length <= this.length);
        if (length == 1) {
            return ArraySubVector.wrap(this.data, this.offset + start * this.stride, 1);
        }
        if (length > 0) {
            return StridedArrayVector.wrapStrided(this.data, this.offset + start * this.stride, length, this.stride);
        }
        return Vector0.INSTANCE;
    }

    @Override
    public double get(int i) {
        return this.data[this.offset + i * this.stride];
    }

    @Override
    public void set(int i, double value) {
        this.data[this.offset + i * this.stride] = value;
    }

    @Override
    public void addAt(int i, double value) {
        int n = this.offset + i * this.stride;
        this.data[n] = this.data[n] + value;
    }

    @Override
    public StridedArrayVector exactClone() {
        double[] data = (double[])this.data.clone();
        return StridedArrayVector.wrapStrided(data, this.offset, this.length, this.stride);
    }
}

