/*
 * Decompiled with CFR 0.152.
 */
package mikera.transformz.impl;

import mikera.transformz.ATransform;
import mikera.vectorz.AVector;
import mikera.vectorz.Op;

public class AOpTransform
extends ATransform {
    private final Op op;
    private final int dims;

    public AOpTransform(Op op, int dims) {
        this.op = op;
        this.dims = dims;
    }

    @Override
    public void transform(AVector source, AVector dest) {
        assert (source.length() == this.dims);
        assert (dest.length() == this.dims);
        for (int i = 0; i < this.dims; ++i) {
            dest.set(i, this.op.apply(source.get(i)));
        }
    }

    @Override
    public double calculateElement(int i, AVector inputVector) {
        return this.op.apply(inputVector.get(i));
    }

    @Override
    public int inputDimensions() {
        return this.dims;
    }

    @Override
    public int outputDimensions() {
        return this.dims;
    }
}

