/*
 * Decompiled with CFR 0.152.
 */
package mikera.matrixx.impl;

import mikera.matrixx.impl.AVectorMatrix;
import mikera.transformz.marker.ISpecialisedTransform;
import mikera.vectorz.AVector;
import mikera.vectorz.Vector3;

public final class VectorMatrixM3
extends AVectorMatrix<Vector3>
implements ISpecialisedTransform {
    private int rowCount;
    private Vector3[] rows;

    public VectorMatrixM3(int rowCount) {
        this.rowCount = rowCount;
        this.rows = new Vector3[rowCount];
        for (int i = 0; i < rowCount; ++i) {
            this.rows[i] = new Vector3();
        }
    }

    private void ensureRowCapacity(int size) {
        if (size <= this.rows.length) {
            return;
        }
        int newSize = Math.max(size, this.rows.length * 2);
        Vector3[] newRows = new Vector3[newSize];
        System.arraycopy(this.rows, 0, newRows, 0, this.rowCount);
        this.rows = newRows;
    }

    @Override
    public void multiply(double factor) {
        for (Vector3 vector : this.rows) {
            vector.scale(factor);
        }
    }

    @Override
    public void appendRow(AVector row) {
        if (row instanceof Vector3) {
            this.appendRow((Vector3)row);
        } else {
            this.appendRow(new Vector3(row));
        }
    }

    public void appendRow(Vector3 row) {
        this.ensureRowCapacity(this.rowCount + 1);
        this.rows[this.rowCount++] = row;
    }

    private VectorMatrixM3(Vector3[] rows) {
        this.rowCount = rows.length;
        this.rows = rows;
    }

    @Override
    public int rowCount() {
        return this.rowCount;
    }

    @Override
    public int columnCount() {
        return 3;
    }

    @Override
    public double get(int row, int column) {
        return this.rows[row].get(column);
    }

    @Override
    public void set(int row, int column, double value) {
        this.rows[row].set(column, value);
    }

    @Override
    public Vector3 getRow(int row) {
        return this.rows[row];
    }

    @Override
    public void transform(AVector source, AVector dest) {
        if (source instanceof Vector3) {
            this.transform((Vector3)source, dest);
            return;
        }
        super.transform(source, dest);
    }

    public void transform(Vector3 source, AVector dest) {
        for (int i = 0; i < this.rowCount; ++i) {
            dest.set(i, this.getRow(i).dotProduct(source));
        }
    }

    @Override
    public double calculateElement(int i, AVector inputVector) {
        assert (i < this.rowCount);
        Vector3 row = this.rows[i];
        return row.dotProduct(inputVector);
    }

    @Override
    public boolean isSquare() {
        return this.rowCount == 3;
    }

    @Override
    public VectorMatrixM3 clone() {
        VectorMatrixM3 m = new VectorMatrixM3((Vector3[])this.rows.clone());
        for (int i = 0; i < this.rowCount; ++i) {
            m.rows[i] = m.rows[i].clone();
        }
        return m;
    }

    @Override
    public VectorMatrixM3 exactClone() {
        return this.clone();
    }
}

