/*
 * Decompiled with CFR 0.152.
 */
package mikera.matrixx.impl;

import mikera.matrixx.AMatrix;
import mikera.vectorz.AVector;

public class TransposedMatrix
extends AMatrix {
    private final AMatrix source;

    private TransposedMatrix(AMatrix source) {
        this.source = source;
    }

    public static AMatrix wrap(AMatrix m) {
        if (m instanceof TransposedMatrix) {
            return ((TransposedMatrix)m).source;
        }
        return new TransposedMatrix(m);
    }

    @Override
    public int rowCount() {
        return this.source.columnCount();
    }

    @Override
    public int columnCount() {
        return this.source.rowCount();
    }

    @Override
    public double get(int row, int column) {
        return this.source.get(column, row);
    }

    @Override
    public void set(int row, int column, double value) {
        this.source.set(column, row, value);
    }

    @Override
    public AVector getRow(int row) {
        return this.source.getColumn(row);
    }

    @Override
    public boolean isView() {
        return true;
    }

    @Override
    public AVector getLeadingDiagonal() {
        return this.source.getLeadingDiagonal();
    }

    @Override
    public AVector getColumn(int column) {
        return this.source.getRow(column);
    }

    @Override
    public double determinant() {
        return this.source.determinant();
    }

    @Override
    public AMatrix getTranspose() {
        return this.source;
    }

    @Override
    public TransposedMatrix exactClone() {
        return new TransposedMatrix(this.source.exactClone());
    }
}

