/*
 * Decompiled with CFR 0.152.
 */
package mikera.matrixx.impl;

import mikera.arrayz.ISparse;
import mikera.matrixx.AMatrix;
import mikera.matrixx.impl.DiagonalMatrix;
import mikera.vectorz.AVector;

public abstract class ADiagonalMatrix
extends AMatrix
implements ISparse {
    protected final int dimensions;

    public ADiagonalMatrix(int dimensions) {
        this.dimensions = dimensions;
    }

    @Override
    public boolean isSquare() {
        return true;
    }

    @Override
    public boolean isFullyMutable() {
        return false;
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @Override
    public double determinant() {
        double det = 1.0;
        for (int i = 0; i < this.dimensions; ++i) {
            det *= this.get(i, i);
        }
        return det;
    }

    public int dimensions() {
        return this.dimensions;
    }

    public AMatrix innerProduct(ADiagonalMatrix a) {
        if (this.dimensions != a.dimensions) {
            throw new IllegalArgumentException("Matrix dimensions not compatible!");
        }
        DiagonalMatrix result = DiagonalMatrix.create(this.dimensions);
        for (int i = 0; i < this.dimensions; ++i) {
            result.data[i] = this.getDiagonalValue(i) * a.getDiagonalValue(i);
        }
        return result;
    }

    @Override
    public AMatrix innerProduct(AMatrix a) {
        if (a instanceof ADiagonalMatrix) {
            return this.innerProduct((ADiagonalMatrix)a);
        }
        if (this.dimensions != a.rowCount()) {
            throw new IllegalArgumentException("Matrix dimensions not compatible!");
        }
        return super.innerProduct(a);
    }

    @Override
    public void transformInPlace(AVector v) {
        for (int i = 0; i < this.dimensions; ++i) {
            v.set(i, v.get(i) * this.getDiagonalValue(i));
        }
    }

    @Override
    public int rowCount() {
        return this.dimensions;
    }

    @Override
    public int columnCount() {
        return this.dimensions;
    }

    @Override
    public boolean isIdentity() {
        int dimensions = this.dimensions();
        for (int i = 0; i < dimensions; ++i) {
            if (this.get(i, i) == 1.0) continue;
            return false;
        }
        return true;
    }

    @Override
    public void transposeInPlace() {
    }

    @Override
    public double calculateElement(int i, AVector v) {
        return v.get(i) * this.getDiagonalValue(i);
    }

    @Override
    public void set(int row, int column, double value) {
        throw new UnsupportedOperationException("Matrix set not supported by " + this.getClass());
    }

    public double getDiagonalValue(int i) {
        return this.get(i, i);
    }

    @Override
    public double density() {
        return 1.0 / (double)this.dimensions;
    }
}

