/*
 * Decompiled with CFR 0.152.
 */
package mikera.arrayz;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mikera.arrayz.AbstractArray;
import mikera.arrayz.Arrayz;
import mikera.arrayz.INDArray;
import mikera.vectorz.AVector;
import mikera.vectorz.IOp;
import mikera.vectorz.Op;
import mikera.vectorz.Tools;
import mikera.vectorz.impl.Vector0;
import mikera.vectorz.util.VectorzException;

public class SliceArray<T extends INDArray>
extends AbstractArray<T> {
    private final int[] shape;
    private final long[] longShape;
    private final T[] slices;

    private SliceArray(int[] shape, T[] slices) {
        this.shape = shape;
        this.slices = slices;
        int dims = shape.length;
        this.longShape = new long[dims];
        for (int i = 0; i < dims; ++i) {
            this.longShape[i] = shape[i];
        }
    }

    public static <T extends INDArray> SliceArray<T> create(T ... slices) {
        return new SliceArray(Tools.consArray(slices.length, slices[0].getShape()), (INDArray[])slices.clone());
    }

    public static <T extends INDArray> SliceArray<T> repeat(T s, int n) {
        ArrayList<T> al = new ArrayList<T>();
        for (int i = 0; i < n; ++i) {
            al.add(s);
        }
        return SliceArray.create(al);
    }

    public static <T extends INDArray> SliceArray<T> create(List<T> slices) {
        int slen = slices.size();
        if (slen == 0) {
            throw new VectorzException("Empty list of slices provided to SliceArray");
        }
        INDArray[] arr = (INDArray[])Array.newInstance(((INDArray)slices.get(0)).getClass(), slen);
        return new SliceArray(Tools.consArray(slen, ((INDArray)slices.get(0)).getShape()), slices.toArray(arr));
    }

    @Override
    public int dimensionality() {
        return this.shape.length;
    }

    @Override
    public int[] getShape() {
        return this.shape;
    }

    @Override
    public long[] getLongShape() {
        return this.longShape;
    }

    @Override
    public double get(int ... indexes) {
        int d = indexes.length;
        T slice = this.slices[indexes[0]];
        switch (d) {
            case 0: {
                throw new VectorzException("Can't do 0D get on SliceArray!");
            }
            case 1: {
                return slice.get();
            }
            case 2: {
                return slice.get(indexes[1]);
            }
            case 3: {
                return slice.get(indexes[1], indexes[2]);
            }
        }
        return slice.get(Arrays.copyOfRange(indexes, 1, d));
    }

    @Override
    public void set(int[] indexes, double value) {
        int d = indexes.length;
        if (d == 0) {
            for (int i = 0; i < this.slices.length; ++i) {
                this.slices[i].set(indexes, value);
            }
            return;
        }
        T slice = this.slices[indexes[0]];
        switch (d) {
            case 0: {
                throw new VectorzException("Can't do 0D set on SliceArray!");
            }
            case 1: {
                slice.set(value);
                return;
            }
            case 2: {
                slice.set(indexes[1], value);
                return;
            }
            case 3: {
                slice.set(indexes[1], indexes[2], value);
                return;
            }
        }
        slice.set(Arrays.copyOfRange(indexes, 1, d), value);
    }

    @Override
    public AVector asVector() {
        AVector v = Vector0.INSTANCE;
        for (T a : this.slices) {
            v = ((AVector)v).join(a.asVector());
        }
        return v;
    }

    @Override
    public INDArray reshape(int ... dimensions) {
        return Arrayz.createFromVector(this.asVector(), dimensions);
    }

    @Override
    public INDArray slice(int majorSlice) {
        return this.slices[majorSlice];
    }

    @Override
    public long elementCount() {
        return Tools.arrayProduct(this.shape);
    }

    @Override
    public INDArray innerProduct(INDArray a) {
        ArrayList<INDArray> al = new ArrayList<INDArray>();
        for (INDArray s : this) {
            al.add(s.innerProduct(a));
        }
        return Arrayz.create(al);
    }

    @Override
    public INDArray outerProduct(INDArray a) {
        ArrayList<INDArray> al = new ArrayList<INDArray>();
        for (INDArray s : this) {
            al.add(s.outerProduct(a));
        }
        return Arrayz.create(al);
    }

    @Override
    public boolean isMutable() {
        for (T a : this.slices) {
            if (!a.isMutable()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isFullyMutable() {
        for (T a : this.slices) {
            if (a.isFullyMutable()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isElementConstrained() {
        for (T a : this.slices) {
            if (!a.isElementConstrained()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isView() {
        return true;
    }

    @Override
    public void applyOp(Op op) {
        for (T a : this.slices) {
            a.applyOp(op);
        }
    }

    @Override
    public void applyOp(IOp op) {
        for (T a : this.slices) {
            a.applyOp(op);
        }
    }

    @Override
    public void multiply(double d) {
        for (T a : this.slices) {
            a.scale(d);
        }
    }

    @Override
    public boolean equals(INDArray a) {
        if (!Arrays.equals(a.getShape(), this.getShape())) {
            return false;
        }
        for (int i = 0; i < this.slices.length; ++i) {
            if (this.slices[i].equals(a.slice(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public SliceArray<T> clone() {
        return this.exactClone();
    }

    @Override
    public SliceArray<T> exactClone() {
        INDArray[] newSlices = (INDArray[])this.slices.clone();
        for (int i = 0; i < this.slices.length; ++i) {
            newSlices[i] = newSlices[i].exactClone();
        }
        return new SliceArray(this.shape, newSlices);
    }

    @Override
    public int sliceCount() {
        return this.slices.length;
    }

    public List<INDArray> getSlices() {
        ArrayList<INDArray> al = new ArrayList<INDArray>();
        for (INDArray sl : this) {
            al.add(sl);
        }
        return al;
    }

    @Override
    public void setElements(double[] values, int offset, int length) {
        int skip = (int)this.slice(0).elementCount();
        for (int i = 0; i < this.slices.length; ++i) {
            this.slices[i].setElements(values, offset + skip * i, skip);
        }
    }
}

