/*
 * Decompiled with CFR 0.152.
 */
package mikera.vectorz;

import mikera.vectorz.AVector;
import mikera.vectorz.Vectorz;

public final class BitVector
extends AVector {
    private static final long serialVersionUID = 349277216077562294L;
    public static final double BIT_ON = 1.0;
    public static final double BIT_OFF = 0.0;
    public static final double BIT_THRESHOLD = 0.5;
    private final int length;
    private final long[] data;

    public BitVector(int length) {
        this.length = length;
        this.data = new long[this.requiredArraySize(length)];
    }

    private int requiredArraySize(int length) {
        assert (length >= 0);
        return (length + 63) / 64;
    }

    public static BitVector createLength(int length) {
        return new BitVector(length);
    }

    public BitVector(AVector source) {
        this(source.length());
        this.set(source);
    }

    public BitVector(BitVector source) {
        this(source.data, source.length());
    }

    private BitVector(long[] data, int length) {
        this.length = length;
        this.data = data;
    }

    @Override
    public int length() {
        return this.length;
    }

    public final boolean getBit(int i) {
        return (this.data[i >>> 6] >>> i % 64 & 1L) != 0L;
    }

    @Override
    public double get(int i) {
        return this.getBit(i) ? 1.0 : 0.0;
    }

    @Override
    public double elementSum() {
        double result = 0.0;
        for (int i = 0; i < this.data.length; ++i) {
            result += (double)Long.bitCount(i);
        }
        return result;
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    @Override
    public void copyTo(double[] data, int offset) {
        int len = this.length();
        for (int i = 0; i < len; ++i) {
            data[i + offset] = this.get(i);
        }
    }

    @Override
    public boolean isFullyMutable() {
        return false;
    }

    @Override
    public boolean isElementConstrained() {
        return true;
    }

    @Override
    public boolean isView() {
        return false;
    }

    @Override
    public void set(int i, double value) {
        if (i < 0 || i >= this.length) {
            throw new IndexOutOfBoundsException("Index: " + i);
        }
        int bit = i % 64;
        long mask = 1L << bit;
        int p = i >>> 6;
        this.data[p] = this.data[p] & (mask ^ 0xFFFFFFFFFFFFFFFFL) | (value >= 0.5 ? mask : 0L);
    }

    @Override
    public AVector clone() {
        AVector v = Vectorz.newVector(this.length);
        v.set(this);
        return v;
    }

    public static BitVector of(double ... values) {
        int len = values.length;
        BitVector b = new BitVector(len);
        b.set(values);
        return b;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        int length = this.length();
        sb.append('[');
        if (length > 0) {
            sb.append(this.getBit(0) ? (char)'1' : '0');
            for (int i = 1; i < length; ++i) {
                sb.append(',');
                sb.append(this.getBit(i) ? (char)'1' : '0');
            }
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    public BitVector exactClone() {
        return new BitVector(this);
    }
}

