/*
 * Decompiled with CFR 0.152.
 */
package mikera.matrixx.impl;

import mikera.matrixx.AMatrix;
import mikera.matrixx.impl.ADiagonalMatrix;
import mikera.vectorz.AVector;
import mikera.vectorz.Vectorz;

public final class DiagonalMatrix
extends ADiagonalMatrix {
    final double[] data;

    public DiagonalMatrix(int dimensions) {
        super(dimensions);
        this.data = new double[dimensions];
    }

    private DiagonalMatrix(double ... values) {
        super(values.length);
        this.data = values;
    }

    public static DiagonalMatrix create(double ... values) {
        int dimensions = values.length;
        double[] data = new double[dimensions];
        System.arraycopy(values, 0, data, 0, dimensions);
        return new DiagonalMatrix(data);
    }

    public static DiagonalMatrix create(AVector v) {
        return DiagonalMatrix.wrap(v.toArray());
    }

    public static DiagonalMatrix wrap(double[] data) {
        return new DiagonalMatrix(data);
    }

    @Override
    public double trace() {
        double result = 0.0;
        for (int i = 0; i < this.dimensions; ++i) {
            result += this.data[i];
        }
        return result;
    }

    @Override
    public double get(int row, int column) {
        if (row != column) {
            return 0.0;
        }
        return this.data[row];
    }

    @Override
    public void set(int row, int column, double value) {
        if (row != column) {
            if (value != 0.0) {
                throw new UnsupportedOperationException("Diagonal matrix cannot be set to non-zero value at position (" + row + "," + column + ")!");
            }
        } else {
            this.data[row] = value;
        }
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    @Override
    public void scale(double factor) {
        int i = 0;
        while (i < this.data.length) {
            int n = i++;
            this.data[n] = this.data[n] * factor;
        }
    }

    @Override
    public double calculateElement(int i, AVector v) {
        return this.data[i] * v.get(i);
    }

    @Override
    public void transformInPlace(AVector v) {
        if (v.length() != this.dimensions) {
            throw new IllegalArgumentException("Wrong length vector: " + v.length());
        }
        for (int i = 0; i < this.dimensions; ++i) {
            v.set(i, v.get(i) * this.data[i]);
        }
    }

    @Override
    public boolean isIdentity() {
        for (int i = 0; i < this.dimensions; ++i) {
            if (this.data[i] == 1.0) continue;
            return false;
        }
        return true;
    }

    @Override
    public DiagonalMatrix clone() {
        DiagonalMatrix m = new DiagonalMatrix(this.data);
        return m;
    }

    @Override
    public double determinant() {
        double det = 1.0;
        for (int i = 0; i < this.dimensions; ++i) {
            det *= this.data[i];
        }
        return det;
    }

    @Override
    public DiagonalMatrix inverse() {
        double[] newData = new double[this.dimensions];
        for (int i = 0; i < this.dimensions; ++i) {
            newData[i] = 1.0 / this.data[i];
        }
        return new DiagonalMatrix(newData);
    }

    @Override
    public double getDiagonalValue(int i) {
        return this.data[i];
    }

    @Override
    public AVector getLeadingDiagonal() {
        return Vectorz.create(this.data);
    }

    @Override
    public AMatrix innerProduct(AMatrix a) {
        if (a instanceof ADiagonalMatrix) {
            return this.innerProduct((ADiagonalMatrix)a);
        }
        return super.innerProduct(a);
    }

    @Override
    public AMatrix innerProduct(ADiagonalMatrix a) {
        if (this.dimensions != a.dimensions) {
            throw new IllegalArgumentException("Matrix dimensions not compatible!");
        }
        DiagonalMatrix result = DiagonalMatrix.create(this.data);
        for (int i = 0; i < this.dimensions; ++i) {
            int n = i;
            result.data[n] = result.data[n] * a.getDiagonalValue(i);
        }
        return result;
    }

    @Override
    public DiagonalMatrix exactClone() {
        return DiagonalMatrix.create(this.data);
    }
}

