/*
 * Decompiled with CFR 0.152.
 */
package mikera.vectorz.ops;

import mikera.vectorz.Op;

public class ComposedOp
extends Op {
    public final Op inner;
    public final Op outer;

    private ComposedOp(Op outer, Op inner) {
        this.outer = outer;
        this.inner = inner;
    }

    public static Op compose(Op outer, Op inner) {
        if (inner instanceof ComposedOp) {
            ComposedOp ci = (ComposedOp)inner;
            return outer.compose(ci.outer).compose(ci.inner);
        }
        return new ComposedOp(outer, inner);
    }

    public static Op create(Op a, Op b) {
        return ComposedOp.compose(a, b);
    }

    @Override
    public double apply(double x) {
        return this.outer.apply(this.inner.apply(x));
    }

    @Override
    public void applyTo(double[] data, int start, int length) {
        this.inner.applyTo(data, start, length);
        this.outer.applyTo(data, start, length);
    }

    @Override
    public boolean isBounded() {
        return this.outer.isBounded();
    }

    @Override
    public double minValue() {
        return this.outer.minValue();
    }

    @Override
    public boolean hasDerivative() {
        return this.outer.hasDerivative() && this.inner.hasDerivative();
    }

    @Override
    public double derivativeForOutput(double y) {
        return this.outer.derivativeForOutput(y) * this.inner.derivativeForOutput(this.outer.applyInverse(y));
    }

    @Override
    public double derivative(double x) {
        double y = this.inner.apply(x);
        return this.outer.derivative(y) * this.inner.derivativeForOutput(y);
    }

    @Override
    public Op getDerivativeOp() {
        return this.outer.getDerivativeOp().compose(this.inner).product(this.inner.getDerivativeOp());
    }

    @Override
    public double maxValue() {
        return this.outer.maxValue();
    }

    @Override
    public boolean hasInverse() {
        return this.outer.hasInverse() && this.inner.hasInverse();
    }

    @Override
    public boolean isStochastic() {
        return this.outer.isStochastic() || this.inner.isStochastic();
    }

    @Override
    public Op getInverse() {
        return this.inner.getInverse().compose(this.outer.getInverse());
    }

    @Override
    public double averageValue() {
        return this.outer.averageValue();
    }
}

