/*
 * Decompiled with CFR 0.152.
 */
package mikera.vectorz.impl;

import mikera.vectorz.AVector;
import mikera.vectorz.Op;

public final class JoinedVector
extends AVector {
    private static final long serialVersionUID = -5535850407701653222L;
    private final AVector left;
    private final AVector right;
    private final int split;
    private final int length;

    private JoinedVector(AVector left, AVector right) {
        this.left = left;
        this.right = right;
        this.split = left.length();
        this.length = this.split + right.length();
    }

    public static AVector joinVectors(AVector left, AVector right) {
        while (left.length() > right.length() * 2 && left instanceof JoinedVector) {
            JoinedVector bigLeft = (JoinedVector)left;
            left = bigLeft.left;
            right = JoinedVector.joinVectors(bigLeft.right, right);
        }
        while (left.length() * 2 < right.length() && right instanceof JoinedVector) {
            JoinedVector bigRight = (JoinedVector)right;
            left = JoinedVector.joinVectors(left, bigRight.left);
            right = bigRight.right;
        }
        return new JoinedVector(left, right);
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public boolean isView() {
        return true;
    }

    @Override
    public boolean isFullyMutable() {
        return this.left.isFullyMutable() && this.right.isFullyMutable();
    }

    @Override
    public void copyTo(AVector dest, int offset) {
        this.left.copyTo(dest, offset);
        this.right.copyTo(dest, offset + this.split);
    }

    @Override
    public void addToArray(int offset, double[] array, int arrayOffset, int length) {
        assert (arrayOffset + length <= array.length);
        assert (offset + length <= this.length());
        if (offset >= this.split) {
            this.right.addToArray(offset - this.split, array, arrayOffset, length);
        } else if (offset + length <= this.split) {
            this.left.addToArray(offset, array, arrayOffset, length);
        } else {
            this.left.addToArray(offset, array, arrayOffset, this.split - offset);
            this.right.addToArray(0, array, arrayOffset + (this.split - offset), length - (this.split - offset));
        }
    }

    @Override
    public void addMultipleToArray(double factor, int offset, double[] array, int arrayOffset, int length) {
        assert (arrayOffset + length <= array.length);
        assert (offset + length <= this.length());
        if (offset >= this.split) {
            this.right.addMultipleToArray(factor, offset - this.split, array, arrayOffset, length);
        } else if (offset + length <= this.split) {
            this.left.addMultipleToArray(factor, offset, array, arrayOffset, length);
        } else {
            this.left.addMultipleToArray(factor, offset, array, arrayOffset, this.split - offset);
            this.right.addMultipleToArray(factor, 0, array, arrayOffset + (this.split - offset), length - (this.split - offset));
        }
    }

    @Override
    public void addAt(int i, double v) {
        if (i < this.split) {
            this.left.addAt(i, v);
        } else {
            this.right.addAt(i - this.split, v);
        }
    }

    @Override
    public void copyTo(double[] data, int offset) {
        this.left.copyTo(data, offset);
        this.right.copyTo(data, offset + this.split);
    }

    @Override
    public void multiplyTo(double[] data, int offset) {
        this.left.multiplyTo(data, offset);
        this.right.multiplyTo(data, offset + this.split);
    }

    @Override
    public void divideTo(double[] data, int offset) {
        this.left.divideTo(data, offset);
        this.right.divideTo(data, offset + this.split);
    }

    @Override
    public void copyTo(int start, AVector dest, int destOffset, int length) {
        this.subVector(start, length).copyTo(dest, destOffset);
    }

    @Override
    public AVector subVector(int start, int length) {
        assert (start >= 0);
        assert (start + length <= this.length);
        if (start == 0 && length == this.length) {
            return this;
        }
        if (start >= this.split) {
            return this.right.subVector(start - this.split, length);
        }
        if (start + length <= this.split) {
            return this.left.subVector(start, length);
        }
        AVector v1 = this.left.subVector(start, this.split - start);
        AVector v2 = this.right.subVector(0, length - (this.split - start));
        return new JoinedVector(v1, v2);
    }

    @Override
    public void add(AVector a) {
        assert (this.length() == a.length());
        if (a instanceof JoinedVector) {
            this.add((JoinedVector)a);
        } else {
            this.add(a, 0);
        }
    }

    public void add(JoinedVector a) {
        if (this.split == a.split) {
            this.left.add(a.left);
            this.right.add(a.right);
        } else {
            this.add(a, 0);
        }
    }

    @Override
    public void scaleAdd(double factor, double constant) {
        this.left.scaleAdd(factor, constant);
        this.right.scaleAdd(factor, constant);
    }

    @Override
    public void add(double constant) {
        this.left.add(constant);
        this.right.add(constant);
    }

    @Override
    public double dotProduct(AVector v) {
        if (v instanceof JoinedVector) {
            JoinedVector jv = (JoinedVector)v;
            return this.dotProduct(jv);
        }
        return super.dotProduct(v);
    }

    public double dotProduct(JoinedVector jv) {
        if (jv.left.length() == this.left.length()) {
            return this.left.dotProduct(jv.left) + this.right.dotProduct(jv.right);
        }
        return super.dotProduct(jv);
    }

    @Override
    public void add(AVector a, int aOffset) {
        this.left.add(a, aOffset);
        this.right.add(a, aOffset + this.split);
    }

    @Override
    public void add(int offset, AVector a) {
        this.add(offset, a, 0, a.length());
    }

    @Override
    public void add(int offset, AVector a, int aOffset, int length) {
        if (offset >= this.split) {
            this.right.add(offset - this.split, a, aOffset, length);
        } else if (offset + length <= this.split) {
            this.left.add(offset, a, aOffset, length);
        } else {
            this.left.add(offset, a, aOffset, this.split - offset);
            this.right.add(0, a, aOffset + this.split - offset, length - (this.split - offset));
        }
    }

    @Override
    public void addMultiple(AVector a, double factor) {
        if (a instanceof JoinedVector) {
            this.addMultiple((JoinedVector)a, factor);
        } else {
            this.left.addMultiple(a, 0, factor);
            this.right.addMultiple(a, this.split, factor);
        }
    }

    public void addMultiple(JoinedVector a, double factor) {
        if (this.split == a.split) {
            this.left.addMultiple(a.left, factor);
            this.right.addMultiple(a.right, factor);
        } else {
            this.left.addMultiple((AVector)a, 0, factor);
            this.right.addMultiple((AVector)a, this.split, factor);
        }
    }

    @Override
    public void addMultiple(AVector a, int aOffset, double factor) {
        this.left.addMultiple(a, aOffset, factor);
        this.right.addMultiple(a, aOffset + this.split, factor);
    }

    @Override
    public void addProduct(AVector a, AVector b, double factor) {
        this.left.addProduct(a, 0, b, 0, factor);
        this.right.addProduct(a, this.split, b, this.split, factor);
    }

    @Override
    public void addProduct(AVector a, int aOffset, AVector b, int bOffset, double factor) {
        this.left.addProduct(a, aOffset, b, bOffset, factor);
        this.right.addProduct(a, aOffset + this.split, b, bOffset + this.split, factor);
    }

    @Override
    public void applyOp(Op op) {
        this.left.applyOp(op);
        this.right.applyOp(op);
    }

    @Override
    public double elementSum() {
        return this.left.elementSum() + this.right.elementSum();
    }

    @Override
    public double get(int i) {
        if (i < this.split) {
            return this.left.get(i);
        }
        return this.right.get(i - this.split);
    }

    @Override
    public void set(AVector src) {
        this.set(src, 0);
    }

    @Override
    public void set(AVector src, int srcOffset) {
        this.left.set(src, srcOffset);
        this.right.set(src, srcOffset + this.split);
    }

    @Override
    public void set(int i, double value) {
        if (i < this.split) {
            this.left.set(i, value);
        } else {
            this.right.set(i - this.split, value);
        }
    }

    @Override
    public void fill(double value) {
        this.left.fill(value);
        this.right.fill(value);
    }

    @Override
    public void multiply(double value) {
        this.left.multiply(value);
        this.right.multiply(value);
    }

    public static int depthCalc(AVector v) {
        if (v instanceof JoinedVector) {
            JoinedVector jv = (JoinedVector)v;
            return 1 + Math.max(JoinedVector.depthCalc(jv.left), JoinedVector.depthCalc(jv.right));
        }
        return 1;
    }

    public int depth() {
        return JoinedVector.depthCalc(this);
    }

    @Override
    public JoinedVector exactClone() {
        return new JoinedVector(this.left.exactClone(), this.right.exactClone());
    }
}

