/*
 * Decompiled with CFR 0.152.
 */
package mikera.vectorz;

import mikera.transformz.ATransform;
import mikera.transformz.ITransform;
import mikera.transformz.impl.AOpTransform;
import mikera.vectorz.AScalar;
import mikera.vectorz.AVector;
import mikera.vectorz.ArrayVector;
import mikera.vectorz.IOp;
import mikera.vectorz.ops.ClampOp;
import mikera.vectorz.ops.ComposedOp;
import mikera.vectorz.ops.ConstantOp;
import mikera.vectorz.ops.IdentityOp;
import mikera.vectorz.ops.InverseOp;
import mikera.vectorz.ops.Logistic;
import mikera.vectorz.ops.SoftPlus;
import mikera.vectorz.ops.StochasticBinary;
import mikera.vectorz.ops.Tanh;

public abstract class Op
implements IOp,
ITransform {
    public static final Op STOCHASTIC_BINARY = StochasticBinary.INSTANCE;
    public static final Op LINEAR = IdentityOp.INSTANCE;
    public static final Op LOGISTIC = Logistic.INSTANCE;
    public static final Op RECTIFIER = new ClampOp(0.0, Double.MAX_VALUE);
    public static final Op STOCHASTIC_LOGISTIC = Op.compose(STOCHASTIC_BINARY, Logistic.INSTANCE);
    public static final Op TANH = Tanh.INSTANCE;
    public static final Op SOFTPLUS = SoftPlus.INSTANCE;

    @Override
    public abstract double apply(double var1);

    public double applyInverse(double y) {
        throw new UnsupportedOperationException("Inverse not defined for operator: " + this.toString());
    }

    @Override
    public void applyTo(AVector v) {
        if (v instanceof ArrayVector) {
            this.applyTo((ArrayVector)v);
        } else {
            v.applyOp(this);
        }
    }

    public void applyTo(AScalar s) {
        s.set(this.apply(s.get()));
    }

    public void applyTo(ArrayVector v) {
        this.applyTo(v.getArray(), v.getArrayOffset(), v.length());
    }

    @Override
    public void applyTo(double[] data, int start, int length) {
        for (int i = 0; i < length; ++i) {
            double x = data[start + i];
            data[start + i] = this.apply(x);
        }
    }

    public void applyTo(double[] data) {
        this.applyTo(data, 0, data.length);
    }

    @Override
    public ATransform getTransform(int dims) {
        return new AOpTransform(this, dims);
    }

    @Override
    public int inputDimensions() {
        return 1;
    }

    @Override
    public int outputDimensions() {
        return 1;
    }

    @Override
    public void transform(AVector source, AVector dest) {
        assert (source.length() == 1);
        assert (dest.length() == 1);
        dest.set(0, this.apply(source.get(0)));
    }

    @Override
    public Op getInverse() {
        if (this.hasInverse()) {
            return new InverseOp(this);
        }
        throw new UnsupportedOperationException("No inverse available: " + this.getClass());
    }

    public boolean hasDerivative() {
        return false;
    }

    public boolean hasInverse() {
        return false;
    }

    public double derivativeForOutput(double y) {
        assert (!this.hasDerivative());
        throw new UnsupportedOperationException("No derivative defined for " + this.toString());
    }

    public double derivative(double x) {
        assert (!this.hasDerivative());
        return this.derivativeForOutput(this.apply(x));
    }

    public boolean isStochastic() {
        return false;
    }

    public double minValue() {
        return -1.7976931348623157E308;
    }

    public abstract double averageValue();

    public double maxValue() {
        return Double.MAX_VALUE;
    }

    public boolean validateOutput(double[] output) {
        double min = this.minValue();
        double max = this.maxValue();
        for (double d : output) {
            if (!(d < min) && !(d > max)) continue;
            return false;
        }
        return true;
    }

    public void constrainValues(double[] src, double[] dest, int offset, int length) {
        if (!this.isBounded()) {
            System.arraycopy(src, 0, dest, offset, length);
        }
        double min = this.minValue();
        double max = this.maxValue();
        for (int i = offset; i < offset + length; ++i) {
            double v = src[i];
            dest[i] = v > max ? max : (v < min ? min : v);
        }
    }

    public boolean isBounded() {
        return this.minValue() > -1.7976931348623157E308 || this.maxValue() < Double.MAX_VALUE;
    }

    public static Op compose(Op op1, Op op2) {
        return op1.compose(op2);
    }

    public Op compose(Op op) {
        if (op instanceof IdentityOp) {
            return this;
        }
        if (op instanceof ConstantOp) {
            return ConstantOp.create(this.apply(((ConstantOp)op).value));
        }
        return new ComposedOp(this, op);
    }
}

