/*
 * Decompiled with CFR 0.152.
 */
package mikera.vectorz;

import mikera.arrayz.INDArray;
import mikera.randomz.Hash;
import mikera.vectorz.AVector;
import mikera.vectorz.IOp;
import mikera.vectorz.Op;
import mikera.vectorz.impl.ScalarVector;
import mikera.vectorz.util.VectorzException;

public abstract class AScalar
implements INDArray,
Cloneable {
    private static final int[] SCALAR_SHAPE = new int[0];

    public abstract double get();

    public void set(double value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int dimensionality() {
        return 0;
    }

    @Override
    public INDArray slice(int position) {
        throw new UnsupportedOperationException("Can't slice a scalar!");
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    @Override
    public boolean isFullyMutable() {
        return this.isMutable();
    }

    public void add(AScalar s) {
        this.set(this.get() + s.get());
    }

    public void sub(AScalar s) {
        this.set(this.get() - s.get());
    }

    @Override
    public double get(int ... indexes) {
        assert (indexes.length == 0);
        return this.get();
    }

    @Override
    public int[] getShape() {
        return SCALAR_SHAPE;
    }

    @Override
    public long elementCount() {
        return 1L;
    }

    @Override
    public AVector asVector() {
        return new ScalarVector(this);
    }

    @Override
    public INDArray reshape(int ... dimensions) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void applyOp(IOp op) {
        this.set(op.apply(this.get()));
    }

    @Override
    public void applyOp(Op op) {
        this.set(op.apply(this.get()));
    }

    @Override
    public AScalar clone() {
        try {
            return (AScalar)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new VectorzException("AScalar clone failed");
        }
    }

    public boolean equals(Object o) {
        if (o instanceof AScalar) {
            return this.equals((AScalar)o);
        }
        if (o instanceof INDArray) {
            return this.equals((INDArray)o);
        }
        return false;
    }

    @Override
    public boolean equals(INDArray o) {
        return o.dimensionality() == 0 && o.get(SCALAR_SHAPE) == this.get();
    }

    public boolean equals(AScalar o) {
        return this.get() == o.get();
    }

    public int hashCode() {
        return Hash.hashCode((double)this.get());
    }
}

