/*
 * Decompiled with CFR 0.152.
 */
package mikera.transformz;

import mikera.transformz.AAffineTransform;
import mikera.transformz.impl.CompoundTransform;
import mikera.vectorz.AVector;
import mikera.vectorz.Vectorz;

public abstract class ATransform
implements Cloneable {
    public abstract void transform(AVector var1, AVector var2);

    public abstract int inputDimensions();

    public abstract int outputDimensions();

    public ATransform clone() {
        try {
            return (ATransform)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Clone should be supported!!");
        }
    }

    public ATransform compose(ATransform trans) {
        return new CompoundTransform(this, trans);
    }

    public void composeWith(ATransform trans) {
        throw new UnsupportedOperationException(this.getClass() + " cannot compose with " + trans.getClass());
    }

    public boolean isLinear() {
        return false;
    }

    public AVector transform(AVector v) {
        AVector temp = Vectorz.createLength(this.outputDimensions());
        this.transform(v, temp);
        return temp;
    }

    public void transformInPlace(AVector v) {
        throw new UnsupportedOperationException("Cannot transform in place");
    }

    public boolean isIdentity() {
        throw new UnsupportedOperationException();
    }

    public AAffineTransform inverse() {
        throw new UnsupportedOperationException("inverse not supported by " + this.getClass());
    }
}

