/*
 * Decompiled with CFR 0.152.
 */
package mikera.vectorz;

import mikera.vectorz.PrimitiveVector;

public final class Vector3
extends PrimitiveVector {
    public double x;
    public double y;
    public double z;

    public Vector3() {
    }

    public Vector3(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector3(double ... values) {
        this.x = values[0];
        this.y = values[1];
        this.y = values[2];
    }

    public void add(double dx, double dy, double dz) {
        this.x += dx;
        this.y += dy;
        this.z += dz;
    }

    public void addMultiple(double dx, double dy, double dz, double factor) {
        this.x += dx * factor;
        this.y += dy * factor;
        this.z += dz * factor;
    }

    public double dotProduct(Vector3 a) {
        return this.x * a.x + this.y * a.y + this.z * a.z;
    }

    public void crossProduct(Vector3 a) {
        double tx = this.y * a.z - this.z * a.y;
        double ty = this.z * a.x - this.x * a.z;
        double tz = this.x * a.y - this.y * a.x;
        this.x = tx;
        this.y = ty;
        this.z = tz;
    }

    @Override
    public int length() {
        return 3;
    }

    @Override
    public double get(int i) {
        switch (i) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
        }
        throw new IndexOutOfBoundsException("Index: i");
    }

    @Override
    public void set(int i, double value) {
        switch (i) {
            case 0: {
                this.x = value;
                return;
            }
            case 1: {
                this.y = value;
                return;
            }
            case 2: {
                this.z = value;
                return;
            }
        }
        throw new IndexOutOfBoundsException("Index: i");
    }

    @Override
    public Vector3 clone() {
        return new Vector3(this.x, this.y, this.z);
    }
}

