/*
 * Decompiled with CFR 0.152.
 */
package mikera.vectorz;

import mikera.vectorz.AVector;
import mikera.vectorz.ArrayVector;

public final class Vector
extends ArrayVector {
    private final double[] data;

    public Vector(double ... values) {
        int length = values.length;
        this.data = new double[length];
        System.arraycopy(values, 0, this.data, 0, length);
    }

    Vector(int length) {
        this.data = new double[length];
    }

    public Vector(AVector source) {
        int length = source.length();
        this.data = new double[length];
        source.copyTo(this.data, 0);
    }

    @Override
    public int length() {
        return this.data.length;
    }

    @Override
    public double get(int i) {
        return this.data[i];
    }

    @Override
    public void set(int i, double value) {
        this.data[i] = value;
    }

    @Override
    public double[] getArray() {
        return this.data;
    }

    @Override
    public int getArrayOffset() {
        return 0;
    }

    @Override
    public void fill(double value) {
        int len = this.length();
        for (int i = 0; i < len; ++i) {
            this.data[i] = value;
        }
    }

    public void add(ArrayVector v) {
        int length;
        int vlength = v.length();
        if (vlength != (length = this.length())) {
            throw new Error("Source vector has different size: " + vlength);
        }
        double[] vdata = v.getArray();
        int voffset = v.getArrayOffset();
        for (int i = 0; i < length; ++i) {
            int n = i;
            this.data[n] = this.data[n] + vdata[voffset + i];
        }
    }

    public void addMultiple(ArrayVector v, double factor) {
        int length;
        int vlength = v.length();
        if (vlength != (length = this.length())) {
            throw new Error("Source vector has different size: " + vlength);
        }
        double[] vdata = v.getArray();
        int voffset = v.getArrayOffset();
        for (int i = 0; i < length; ++i) {
            int n = i;
            this.data[n] = this.data[n] + vdata[voffset + i] * factor;
        }
    }

    @Override
    public void add(AVector v) {
        int length;
        if (v instanceof ArrayVector) {
            this.add((ArrayVector)v);
            return;
        }
        int vlength = v.length();
        if (vlength != (length = this.length())) {
            throw new Error("Source vector has different size: " + vlength);
        }
        for (int i = 0; i < length; ++i) {
            int n = i;
            this.data[n] = this.data[n] + v.get(i);
        }
    }

    @Override
    public void addMultiple(AVector v, double factor) {
        int length;
        if (v instanceof ArrayVector) {
            this.addMultiple((ArrayVector)v, factor);
            return;
        }
        int vlength = v.length();
        if (vlength != (length = this.length())) {
            throw new Error("Source vector has different size: " + vlength);
        }
        for (int i = 0; i < length; ++i) {
            int n = i;
            this.data[n] = this.data[n] + v.get(i) * factor;
        }
    }

    @Override
    public void multiply(double factor) {
        int len = this.length();
        int i = 0;
        while (i < len) {
            int n = i++;
            this.data[n] = this.data[n] * factor;
        }
    }

    @Override
    public Vector clone() {
        return new Vector(this);
    }
}

