/*
 * Decompiled with CFR 0.152.
 */
package mikera.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.io.PrintStream;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.Timer;
import mikera.gui.ConsoleData;

public class JConsole
extends JComponent
implements HierarchyListener {
    private static final long serialVersionUID = 3571518591759968333L;
    private static final Color DEFAULT_FOREGROUND = Color.LIGHT_GRAY;
    private static final Color DEFAULT_BACKGROUND = Color.BLACK;
    private static final Font DEFAULT_FONT = new Font("Courier New", 0, 18);
    private static final int DEFAULT_BLINKRATE = 200;
    private static final boolean DEFAULT_BLINK_ON = true;
    private ConsoleData data = new ConsoleData();
    private int fontWidth;
    private int fontHeight;
    private int fontYOffset;
    private boolean cursorVisible = false;
    private boolean cursorBlinkOn = true;
    private boolean cursorInverted = true;
    private int cursorX = 0;
    private int cursorY = 0;
    private Font mainFont = null;
    private Font currentFont = null;
    private Color currentForeground = DEFAULT_FOREGROUND;
    private Color currentBackground = DEFAULT_BACKGROUND;
    private Timer blinkTimer;

    public JConsole(int columns, int rows) {
        this.setMainFont(DEFAULT_FONT);
        this.setFont(this.mainFont);
        this.init(columns, rows);
        this.setCursorBlink(true);
    }

    public void setMainFont(Font font) {
        this.mainFont = font;
        FontRenderContext fontRenderContext = new FontRenderContext(this.mainFont.getTransform(), false, false);
        Rectangle2D charBounds = this.mainFont.getStringBounds("X", fontRenderContext);
        this.fontWidth = (int)charBounds.getWidth();
        this.fontHeight = (int)charBounds.getHeight();
        this.fontYOffset = -((int)charBounds.getMinY());
        this.setPreferredSize(new Dimension(this.data.columns * this.fontWidth, this.data.rows * this.fontHeight));
        this.repaint();
    }

    private void stopBlinking() {
        if (this.blinkTimer != null) {
            this.blinkTimer.stop();
            this.cursorInverted = true;
        }
    }

    private void startBlinking() {
        this.getTimer().start();
    }

    public void setCursorBlink(boolean blink) {
        if (blink) {
            this.cursorBlinkOn = true;
            this.startBlinking();
        } else {
            this.cursorBlinkOn = false;
            this.stopBlinking();
        }
    }

    public void setBlinkDelay(int millis) {
        this.getTimer().setDelay(millis);
    }

    private Timer getTimer() {
        if (this.blinkTimer == null) {
            this.blinkTimer = new Timer(200, new TimerAction());
            this.blinkTimer.setRepeats(true);
            if (this.cursorBlinkOn) {
                this.startBlinking();
            }
        }
        return this.blinkTimer;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.addHierarchyListener(this);
    }

    @Override
    public void removeNotify() {
        this.removeHierarchyListener(this);
        super.removeNotify();
    }

    public void setRows(int rows) {
        this.resize(this.data.columns, rows);
    }

    @Override
    public void setFont(Font f) {
        this.currentFont = f;
    }

    public void setCursorVisible(boolean visible) {
        this.cursorVisible = visible;
    }

    public int getRows() {
        return this.data.rows;
    }

    public void setColumns(int columns) {
        this.resize(columns, this.data.rows);
    }

    public int getColumns() {
        return this.data.columns;
    }

    public int getFontWidth() {
        return this.fontWidth;
    }

    public int getFontHeight() {
        return this.fontHeight;
    }

    public void repaintArea(int column, int row, int width, int height) {
        int fw = this.getFontWidth();
        int fh = this.getFontHeight();
        this.repaint(column * fw, row * fh, width * fw, height * fh);
    }

    protected void init(int columns, int rows) {
        this.data.init(columns, rows);
        Arrays.fill(this.data.background, DEFAULT_BACKGROUND);
        Arrays.fill(this.data.foreground, DEFAULT_FOREGROUND);
        Arrays.fill(this.data.font, DEFAULT_FONT);
        Arrays.fill(this.data.text, ' ');
        this.setPreferredSize(new Dimension(columns * this.fontWidth, rows * this.fontHeight));
    }

    @Override
    public void resize(int columns, int rows) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        this.clearArea(0, 0, this.data.columns, this.data.rows);
    }

    public void resetCursor() {
        this.repaintArea(this.cursorX, this.cursorY, 0, 0);
        this.cursorX = 0;
        this.cursorY = 0;
        this.repaintArea(this.cursorX, this.cursorY, 0, 0);
    }

    public void clearScreen() {
        this.clear();
        this.resetCursor();
    }

    private void clearArea(int column, int row, int width, int height) {
        this.data.fillArea(' ', this.currentForeground, this.currentBackground, this.currentFont, column, row, width, height);
        this.repaintArea(0, 0, width, height);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Graphics2D g = (Graphics2D)graphics;
        Rectangle r = g.getClipBounds();
        int x1 = (int)(r.getMinX() / (double)this.fontWidth);
        int x2 = (int)(r.getMaxX() / (double)this.fontWidth) + 1;
        int y1 = (int)(r.getMinY() / (double)this.fontWidth);
        int y2 = (int)(r.getMaxY() / (double)this.fontWidth) + 1;
        int curX = this.getCursorX();
        int curY = this.getCursorY();
        for (int j = Math.max(0, y1); j < Math.min(y2, this.data.rows); ++j) {
            int offset = j * this.data.columns;
            int start = Math.max(x1, 0);
            int end = Math.min(x2, this.data.columns);
            while (start < end) {
                int i;
                Color nfg = this.data.foreground[offset + start];
                Color nbg = this.data.background[offset + start];
                Font nf = this.data.font[offset + start];
                if (j == curY && start == curX) {
                    if (this.cursorVisible && this.cursorBlinkOn && this.cursorInverted) {
                        Color t = nfg;
                        nfg = nbg;
                        nbg = t;
                    }
                } else {
                    for (i = start + 1; i < end && (j != curY || i != curX) && nfg == this.data.foreground[offset + i] && nbg == this.data.background[offset + i] && nf == this.data.font[offset + i]; ++i) {
                    }
                }
                g.setFont(nf);
                g.setBackground(nbg);
                g.clearRect(this.fontWidth * start, j * this.fontHeight, this.fontWidth * (i - start), this.fontHeight);
                g.setColor(nfg);
                for (int k = start; k < i; ++k) {
                    g.drawChars(this.data.text, offset + k, 1, k * this.fontWidth, j * this.fontHeight + this.fontYOffset);
                }
                start = i;
            }
        }
    }

    public void setCursorPos(int column, int row) {
        if (column < 0 || column >= this.data.columns) {
            throw new Error("Invalid X cursor position: " + column);
        }
        if (row < 0 || row >= this.data.rows) {
            throw new Error("Invalid Y cursor position: " + row);
        }
        this.cursorX = column;
        this.cursorY = row;
    }

    public int getCursorX() {
        return this.cursorX;
    }

    public int getCursorY() {
        return this.cursorY;
    }

    @Override
    public void setForeground(Color c) {
        this.currentForeground = c;
    }

    @Override
    public void setBackground(Color c) {
        this.currentBackground = c;
    }

    @Override
    public Color getForeground() {
        return this.currentForeground;
    }

    @Override
    public Color getBackground() {
        return this.currentBackground;
    }

    public char getCharAt(int column, int row) {
        return this.data.getCharAt(column, row);
    }

    public Color getForegroundAt(int column, int row) {
        return this.data.getForegroundAt(column, row);
    }

    public Color getBackgroundAt(int column, int row) {
        return this.data.getBackgroundAt(column, row);
    }

    public Font getFontAt(int column, int row) {
        return this.data.getFontAt(column, row);
    }

    public void captureStdOut() {
        PrintStream ps = new PrintStream(System.out){

            @Override
            public void println(String x) {
                JConsole.this.writeln(x);
            }
        };
        System.setOut(ps);
    }

    public void write(char c) {
        this.data.setDataAt(this.cursorX, this.cursorY, c, this.currentForeground, this.currentBackground, this.currentFont);
        this.moveCursor(c);
    }

    private void moveCursor(char c) {
        switch (c) {
            case '\n': {
                ++this.cursorY;
                this.cursorX = 0;
                break;
            }
            default: {
                ++this.cursorX;
                if (this.cursorX < this.data.columns) break;
                this.cursorX = 0;
                ++this.cursorY;
            }
        }
    }

    public void writeln(String line) {
        this.write(line);
        this.write('\n');
    }

    public void write(String string, Color foreGround, Color backGround) {
        Color foreTemp = this.currentForeground;
        Color backTemp = this.currentBackground;
        this.setForeground(foreGround);
        this.setBackground(backGround);
        this.write(string);
        this.setForeground(foreTemp);
        this.setBackground(backTemp);
    }

    public void write(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            this.write(c);
        }
    }

    public void fillArea(char c, Color fg, Color bg, int column, int row, int width, int height) {
        this.data.fillArea(c, fg, bg, this.currentFont, column, row, width, height);
        this.repaintArea(column, row, width, height);
    }

    @Override
    public void hierarchyChanged(HierarchyEvent e) {
        if ((e.getChangeFlags() & 4L) != 0L) {
            if (this.isShowing()) {
                this.startBlinking();
            } else {
                this.stopBlinking();
            }
        }
    }

    private class TimerAction
    implements ActionListener {
        private TimerAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (JConsole.this.cursorBlinkOn && JConsole.this.isShowing()) {
                JConsole.this.cursorInverted = !JConsole.this.cursorInverted;
                JConsole.this.repaintArea(JConsole.this.getCursorX(), JConsole.this.getCursorY(), 1, 1);
            } else {
                JConsole.this.stopBlinking();
            }
        }
    }
}

