/*
 * Decompiled with CFR 0.152.
 */
package mikera.gui;

import java.awt.Color;
import java.awt.Font;

public final class ConsoleData {
    private int capacity = 0;
    public int rows;
    public int columns;
    public Color[] background;
    public Color[] foreground;
    public Font[] font;
    public char[] text;

    ConsoleData() {
    }

    private void ensureCapacity(int minCapacity) {
        if (this.capacity >= minCapacity) {
            return;
        }
        char[] newText = new char[minCapacity];
        Color[] newBackground = new Color[minCapacity];
        Color[] newForeground = new Color[minCapacity];
        Font[] newFont = new Font[minCapacity];
        int size = this.rows * this.columns;
        if (size > 0) {
            System.arraycopy(this.text, 0, newText, 0, size);
            System.arraycopy(this.foreground, 0, newForeground, 0, size);
            System.arraycopy(this.background, 0, newBackground, 0, size);
            System.arraycopy(this.font, 0, newFont, 0, size);
        }
        this.text = newText;
        this.foreground = newForeground;
        this.background = newBackground;
        this.font = newFont;
        this.capacity = minCapacity;
    }

    void init(int columns, int rows) {
        this.ensureCapacity(rows * columns);
        this.rows = rows;
        this.columns = columns;
    }

    public void setDataAt(int column, int row, char c, Color fg, Color bg, Font f) {
        int pos = column + row * this.columns;
        this.text[pos] = c;
        this.foreground[pos] = fg;
        this.background[pos] = bg;
        this.font[pos] = f;
    }

    public char getCharAt(int column, int row) {
        int offset = column + row * this.columns;
        return this.text[offset];
    }

    public Color getForegroundAt(int column, int row) {
        int offset = column + row * this.columns;
        return this.foreground[offset];
    }

    public Color getBackgroundAt(int column, int row) {
        int offset = column + row * this.columns;
        return this.background[offset];
    }

    public Font getFontAt(int column, int row) {
        int offset = column + row * this.columns;
        return this.font[offset];
    }

    public void fillArea(char c, Color fg, Color bg, Font f, int column, int row, int width, int height) {
        for (int q = Math.max(0, row); q < Math.min(row + height, this.rows); ++q) {
            for (int p = Math.max(0, column); p < Math.min(column + width, this.columns); ++p) {
                int offset = p + q * this.columns;
                this.text[offset] = c;
                this.foreground[offset] = fg;
                this.background[offset] = bg;
                this.font[offset] = f;
            }
        }
    }
}

