/*
 * Decompiled with CFR 0.152.
 */
package mikera.image;

import java.awt.Color;
import mikera.util.Maths;
import mikera.util.Rand;

public class Colours {
    public static int RGB_MASK = 0xFFFFFF;
    public static int RED_MASK = 0xFF0000;
    public static int GREEN_MASK = 65280;
    public static int BLUE_MASK = 255;
    public static int ALPHA_MASK = -16777216;
    public static final int BYTE_MASK = 255;
    private static final int MAX_BYTE = 255;
    private static final float INVERSE_FLOAT_FACTOR = 0.003921569f;

    public static int getRed(int argb) {
        return argb >> 16 & 0xFF;
    }

    public static int getGreen(int argb) {
        return argb >> 8 & 0xFF;
    }

    public static int getBlue(int argb) {
        return argb & 0xFF;
    }

    public static int getAlpha(int argb) {
        return argb >> 24 & 0xFF;
    }

    public static int toGreyScale(int argb) {
        int lum = Colours.getLuminance(argb);
        return argb & ALPHA_MASK | 65793 * lum;
    }

    public static int getLuminance(int argb) {
        int lum = 77 * (argb >> 16 & 0xFF) + 150 * (argb >> 8 & 0xFF) + 29 * (argb & 0xFF) >> 8;
        return lum;
    }

    public static int getARGBClamped(double r, double g, double b, double a) {
        int ri = Maths.clampToInteger((double)(r * 255.0), (int)0, (int)255);
        int gi = Maths.clampToInteger((double)(g * 255.0), (int)0, (int)255);
        int bi = Maths.clampToInteger((double)(b * 255.0), (int)0, (int)255);
        int ai = Maths.clampToInteger((double)(a * 255.0), (int)0, (int)255);
        return Colours.getARGBQuick(ri, gi, bi, ai);
    }

    public static int getARGBClamped(float r, float g, float b, float a) {
        int ri = Maths.clampToInteger((float)(r * 255.0f), (int)0, (int)255);
        int gi = Maths.clampToInteger((float)(g * 255.0f), (int)0, (int)255);
        int bi = Maths.clampToInteger((float)(b * 255.0f), (int)0, (int)255);
        int ai = Maths.clampToInteger((float)(a * 255.0f), (int)0, (int)255);
        return Colours.getARGBQuick(ri, gi, bi, ai);
    }

    public static int getRGBClamped(float r, float g, float b) {
        int ri = Maths.clampToInteger((float)(r * 255.0f), (int)0, (int)255);
        int gi = Maths.clampToInteger((float)(g * 255.0f), (int)0, (int)255);
        int bi = Maths.clampToInteger((float)(b * 255.0f), (int)0, (int)255);
        return Colours.getRGBQuick(ri, gi, bi);
    }

    public static int getRGBClamped(double r, double g, double b) {
        int ri = Maths.clampToInteger((double)(r * 255.0), (int)0, (int)255);
        int gi = Maths.clampToInteger((double)(g * 255.0), (int)0, (int)255);
        int bi = Maths.clampToInteger((double)(b * 255.0), (int)0, (int)255);
        return Colours.getRGBQuick(ri, gi, bi);
    }

    public static int getARGBClamped(int r, int g, int b, int a) {
        int ri = Maths.bound((int)r, (int)0, (int)255);
        int gi = Maths.bound((int)g, (int)0, (int)255);
        int bi = Maths.bound((int)b, (int)0, (int)255);
        int ai = Maths.bound((int)a, (int)0, (int)255);
        return Colours.getARGBQuick(ri, gi, bi, ai);
    }

    public static void toFloat4(float[] col, int offset, int argb) {
        col[offset] = (float)Colours.getRed(argb) * 0.003921569f;
        col[offset + 1] = (float)Colours.getGreen(argb) * 0.003921569f;
        col[offset + 2] = (float)Colours.getBlue(argb) * 0.003921569f;
        col[offset + 3] = (float)Colours.getAlpha(argb) * 0.003921569f;
    }

    public static int fromFloat4(float[] col, int offset) {
        return Colours.getARGBClamped(col[offset], col[offset + 1], col[offset + 2], col[offset + 3]);
    }

    public static int fromDouble3(double[] col, int offset) {
        return Colours.getRGBClamped(col[offset], col[offset + 1], col[offset + 2]);
    }

    public static int fromFloat3(float[] col, int offset) {
        return Colours.getRGBClamped(col[offset], col[offset + 1], col[offset + 2]);
    }

    public static int getARGB(int r, int g, int b, int a) {
        return Colours.getARGBQuick(r & 0xFF, g & 0xFF, b & 0xFF, a & 0xFF);
    }

    public static int getARGB(int r, int g, int b) {
        return Colours.getARGBQuick(r & 0xFF, g & 0xFF, b & 0xFF, 255);
    }

    public static int getARGB(int rgb, int alpha) {
        return rgb & RGB_MASK | (alpha & 0xFF) << 24;
    }

    static int getARGBQuick(int r, int g, int b, int a) {
        return a << 24 | r << 16 | g << 8 | b;
    }

    static int getRGBQuick(int r, int g, int b) {
        return ALPHA_MASK | r << 16 | g << 8 | b;
    }

    public Color getRGBColor(int rgb) {
        int r = Colours.getRed(rgb);
        int g = Colours.getGreen(rgb);
        int b = Colours.getBlue(rgb);
        return new Color(r, g, b);
    }

    public static Color getColor(int argb) {
        int r = Colours.getRed(argb);
        int g = Colours.getGreen(argb);
        int b = Colours.getBlue(argb);
        int a = Colours.getAlpha(argb);
        return new Color(r, g, b, a);
    }

    public static int randomARGBColour() {
        return -16777216 + 65536 * Rand.r((int)256) + 256 * Rand.r((int)256) + Rand.r((int)256);
    }

    public static Color getColor(int r, int g, int b) {
        return new Color(r, g, b);
    }

    public static int toGreyScale(float f) {
        return 0xFF000000 | 65793 * Colours.floatToByte(f);
    }

    public static int toGreyScale(double d) {
        return 0xFF000000 | 65793 * Colours.doubleToByte(d);
    }

    public static int toGreen(float f) {
        return 0xFF000000 | 256 * Colours.floatToByte(f);
    }

    private static int floatToByte(float f) {
        return Maths.bound((int)((int)(f * 255.0f)), (int)0, (int)255);
    }

    private static int doubleToByte(double d) {
        return Maths.bound((int)((int)(d * 255.0)), (int)0, (int)255);
    }
}

