/*
 * Decompiled with CFR 0.152.
 */
package mikera.gui.interaction;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;

public class Draggable {
    public static void makeDraggable(Component comp) {
        comp.addMouseMotionListener(new Adapter(comp));
    }

    public static class Adapter
    extends MouseMotionAdapter {
        Component comp;
        Point dragStart = new Point(0, 0);

        public Adapter(Component comp) {
            this.comp = comp;
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.dragStart = e.getPoint();
            this.comp.setCursor(Cursor.getPredefinedCursor(12));
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            int startX = this.dragStart.x;
            int startY = this.dragStart.y;
            Point parentLocation = this.comp.getParent().getLocationOnScreen();
            Point mouseLocation = e.getLocationOnScreen();
            this.comp.setLocation(mouseLocation.x - parentLocation.x - startX, mouseLocation.y - parentLocation.y - startY);
        }
    }
}

