/*
 * Decompiled with CFR 0.152.
 */
package mikera.gui;

import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import mikera.gui.Frames;
import mikera.gui.JIcon;
import mikera.image.Colours;

public class ImageUtils {
    public static BufferedImage loadImage(String filename) {
        try {
            URL imageURL = Thread.currentThread().getContextClassLoader().getResource(filename);
            return ImageIO.read(imageURL);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static BufferedImage newImage(int w, int h) {
        BufferedImage result = new BufferedImage(w, h, 2);
        return result;
    }

    public static BufferedImage loadImage(URL imageURL) {
        BufferedImage image;
        try {
            image = ImageIO.read(imageURL);
        }
        catch (IOException e) {
            throw new Error("Image read failed", e);
        }
        return image;
    }

    public static int randomColour() {
        return Colours.randomARGBColour();
    }

    public static BufferedImage scaleImage(BufferedImage img, int w, int h) {
        BufferedImage result = new BufferedImage(w, h, 2);
        Graphics2D g = (Graphics2D)result.getGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.drawImage(img, 0, 0, w, h, null);
        return result;
    }

    public static Frame display(BufferedImage image) {
        return Frames.display(new JIcon(image));
    }

    public static Frame display(BufferedImage image, String s) {
        return Frames.display(new JIcon(image), s);
    }
}

